/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceShareRequest
extends RamRequest
implements ToCopyableBuilder<Builder, UpdateResourceShareRequest> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateResourceShareRequest.getter(UpdateResourceShareRequest::resourceShareArn)).setter(UpdateResourceShareRequest.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateResourceShareRequest.getter(UpdateResourceShareRequest::name)).setter(UpdateResourceShareRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> ALLOW_EXTERNAL_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateResourceShareRequest.getter(UpdateResourceShareRequest::allowExternalPrincipals)).setter(UpdateResourceShareRequest.setter(Builder::allowExternalPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowExternalPrincipals").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateResourceShareRequest.getter(UpdateResourceShareRequest::clientToken)).setter(UpdateResourceShareRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD, NAME_FIELD, ALLOW_EXTERNAL_PRINCIPALS_FIELD, CLIENT_TOKEN_FIELD));
    private final String resourceShareArn;
    private final String name;
    private final Boolean allowExternalPrincipals;
    private final String clientToken;

    private UpdateResourceShareRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArn = builder.resourceShareArn;
        this.name = builder.name;
        this.allowExternalPrincipals = builder.allowExternalPrincipals;
        this.clientToken = builder.clientToken;
    }

    public String resourceShareArn() {
        return this.resourceShareArn;
    }

    public String name() {
        return this.name;
    }

    public Boolean allowExternalPrincipals() {
        return this.allowExternalPrincipals;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowExternalPrincipals());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceShareRequest)) {
            return false;
        }
        UpdateResourceShareRequest other = (UpdateResourceShareRequest)((Object)obj);
        return Objects.equals(this.resourceShareArn(), other.resourceShareArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.allowExternalPrincipals(), other.allowExternalPrincipals()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdateResourceShareRequest").add("ResourceShareArn", (Object)this.resourceShareArn()).add("Name", (Object)this.name()).add("AllowExternalPrincipals", (Object)this.allowExternalPrincipals()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "allowExternalPrincipals": {
                return Optional.ofNullable(clazz.cast(this.allowExternalPrincipals()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceShareRequest, T> g) {
        return obj -> g.apply((UpdateResourceShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String resourceShareArn;
        private String name;
        private Boolean allowExternalPrincipals;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceShareRequest model) {
            super(model);
            this.resourceShareArn(model.resourceShareArn);
            this.name(model.name);
            this.allowExternalPrincipals(model.allowExternalPrincipals);
            this.clientToken(model.clientToken);
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getAllowExternalPrincipals() {
            return this.allowExternalPrincipals;
        }

        @Override
        public final Builder allowExternalPrincipals(Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
            return this;
        }

        public final void setAllowExternalPrincipals(Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceShareRequest build() {
            return new UpdateResourceShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceShareRequest> {
        public Builder resourceShareArn(String var1);

        public Builder name(String var1);

        public Builder allowExternalPrincipals(Boolean var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

