/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.model.ListPrincipalsRequest;
import software.amazon.awssdk.services.ram.model.ListPrincipalsResponse;

public class ListPrincipalsPublisher
implements SdkPublisher<ListPrincipalsResponse> {
    private final RamAsyncClient client;
    private final ListPrincipalsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPrincipalsPublisher(RamAsyncClient client, ListPrincipalsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPrincipalsPublisher(RamAsyncClient client, ListPrincipalsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPrincipalsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPrincipalsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListPrincipalsPublisher resume(ListPrincipalsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPrincipalsPublisher(this.client, (ListPrincipalsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPrincipalsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPrincipalsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPrincipalsResponseFetcher
    implements AsyncPageFetcher<ListPrincipalsResponse> {
        private ListPrincipalsResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPrincipalsResponse> nextPage(ListPrincipalsResponse previousPage) {
            if (previousPage == null) {
                return ListPrincipalsPublisher.this.client.listPrincipals(ListPrincipalsPublisher.this.firstRequest);
            }
            return ListPrincipalsPublisher.this.client.listPrincipals((ListPrincipalsRequest)((Object)ListPrincipalsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

