/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.RamServiceClientConfiguration;
import software.amazon.awssdk.services.ram.internal.RamServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.CreatePermissionRequest;
import software.amazon.awssdk.services.ram.model.CreatePermissionResponse;
import software.amazon.awssdk.services.ram.model.CreatePermissionVersionRequest;
import software.amazon.awssdk.services.ram.model.CreatePermissionVersionResponse;
import software.amazon.awssdk.services.ram.model.CreateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.CreateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DeletePermissionRequest;
import software.amazon.awssdk.services.ram.model.DeletePermissionResponse;
import software.amazon.awssdk.services.ram.model.DeletePermissionVersionRequest;
import software.amazon.awssdk.services.ram.model.DeletePermissionVersionResponse;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationRequest;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse;
import software.amazon.awssdk.services.ram.model.GetPermissionRequest;
import software.amazon.awssdk.services.ram.model.GetPermissionResponse;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceSharesRequest;
import software.amazon.awssdk.services.ram.model.GetResourceSharesResponse;
import software.amazon.awssdk.services.ram.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.ram.model.InvalidClientTokenException;
import software.amazon.awssdk.services.ram.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.ram.model.InvalidNextTokenException;
import software.amazon.awssdk.services.ram.model.InvalidParameterException;
import software.amazon.awssdk.services.ram.model.InvalidPolicyException;
import software.amazon.awssdk.services.ram.model.InvalidResourceTypeException;
import software.amazon.awssdk.services.ram.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionAssociationsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionAssociationsResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionsResponse;
import software.amazon.awssdk.services.ram.model.ListPrincipalsRequest;
import software.amazon.awssdk.services.ram.model.ListPrincipalsResponse;
import software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkRequest;
import software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkResponse;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse;
import software.amazon.awssdk.services.ram.model.ListResourceTypesRequest;
import software.amazon.awssdk.services.ram.model.ListResourceTypesResponse;
import software.amazon.awssdk.services.ram.model.ListResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListResourcesResponse;
import software.amazon.awssdk.services.ram.model.MalformedArnException;
import software.amazon.awssdk.services.ram.model.MalformedPolicyTemplateException;
import software.amazon.awssdk.services.ram.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.ram.model.OperationNotPermittedException;
import software.amazon.awssdk.services.ram.model.PermissionAlreadyExistsException;
import software.amazon.awssdk.services.ram.model.PermissionLimitExceededException;
import software.amazon.awssdk.services.ram.model.PermissionVersionsLimitExceededException;
import software.amazon.awssdk.services.ram.model.PromotePermissionCreatedFromPolicyRequest;
import software.amazon.awssdk.services.ram.model.PromotePermissionCreatedFromPolicyResponse;
import software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyRequest;
import software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyResponse;
import software.amazon.awssdk.services.ram.model.RamException;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.ReplacePermissionAssociationsRequest;
import software.amazon.awssdk.services.ram.model.ReplacePermissionAssociationsResponse;
import software.amazon.awssdk.services.ram.model.ResourceArnNotFoundException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationAlreadyAcceptedException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationAlreadyRejectedException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationArnNotFoundException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationExpiredException;
import software.amazon.awssdk.services.ram.model.ResourceShareLimitExceededException;
import software.amazon.awssdk.services.ram.model.ServerInternalException;
import software.amazon.awssdk.services.ram.model.ServiceUnavailableException;
import software.amazon.awssdk.services.ram.model.SetDefaultPermissionVersionRequest;
import software.amazon.awssdk.services.ram.model.SetDefaultPermissionVersionResponse;
import software.amazon.awssdk.services.ram.model.TagLimitExceededException;
import software.amazon.awssdk.services.ram.model.TagPolicyViolationException;
import software.amazon.awssdk.services.ram.model.TagResourceRequest;
import software.amazon.awssdk.services.ram.model.TagResourceResponse;
import software.amazon.awssdk.services.ram.model.ThrottlingException;
import software.amazon.awssdk.services.ram.model.UnknownResourceException;
import software.amazon.awssdk.services.ram.model.UnmatchedPolicyPermissionException;
import software.amazon.awssdk.services.ram.model.UntagResourceRequest;
import software.amazon.awssdk.services.ram.model.UntagResourceResponse;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse;
import software.amazon.awssdk.services.ram.transform.AcceptResourceShareInvitationRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.AssociateResourceSharePermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.AssociateResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.CreatePermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.CreatePermissionVersionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.CreateResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DeletePermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DeletePermissionVersionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DeleteResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DisassociateResourceSharePermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DisassociateResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.EnableSharingWithAwsOrganizationRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetPermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourcePoliciesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourceShareAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourceShareInvitationsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourceSharesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPendingInvitationResourcesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPermissionAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPermissionVersionsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPermissionsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPrincipalsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListReplacePermissionAssociationsWorkRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListResourceSharePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.PromotePermissionCreatedFromPolicyRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.PromoteResourceShareCreatedFromPolicyRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.RejectResourceShareInvitationRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ReplacePermissionAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.SetDefaultPermissionVersionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.UpdateResourceShareRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultRamAsyncClient
implements RamAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRamAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRamAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"RAM#2.36.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AcceptResourceShareInvitationResponse> acceptResourceShareInvitation(AcceptResourceShareInvitationRequest acceptResourceShareInvitationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptResourceShareInvitationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, acceptResourceShareInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptResourceShareInvitation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptResourceShareInvitationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptResourceShareInvitation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AcceptResourceShareInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)acceptResourceShareInvitationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$acceptResourceShareInvitation$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$acceptResourceShareInvitation$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssociateResourceShareResponse> associateResourceShare(AssociateResourceShareRequest associateResourceShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateResourceShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, associateResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateResourceShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateResourceShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateResourceShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateResourceShareRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$associateResourceShare$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$associateResourceShare$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssociateResourceSharePermissionResponse> associateResourceSharePermission(AssociateResourceSharePermissionRequest associateResourceSharePermissionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateResourceSharePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, associateResourceSharePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateResourceSharePermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateResourceSharePermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateResourceSharePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateResourceSharePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateResourceSharePermissionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$associateResourceSharePermission$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$associateResourceSharePermission$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePermissionResponse> createPermission(CreatePermissionRequest createPermissionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, createPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPermissionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$createPermission$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$createPermission$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePermissionVersionResponse> createPermissionVersion(CreatePermissionVersionRequest createPermissionVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPermissionVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, createPermissionVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePermissionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePermissionVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePermissionVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePermissionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPermissionVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$createPermissionVersion$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$createPermissionVersion$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateResourceShareResponse> createResourceShare(CreateResourceShareRequest createResourceShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createResourceShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, createResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResourceShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResourceShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createResourceShareRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$createResourceShare$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$createResourceShare$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePermissionResponse> deletePermission(DeletePermissionRequest deletePermissionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, deletePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePermissionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$deletePermission$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$deletePermission$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePermissionVersionResponse> deletePermissionVersion(DeletePermissionVersionRequest deletePermissionVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePermissionVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, deletePermissionVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePermissionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermissionVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePermissionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePermissionVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$deletePermissionVersion$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$deletePermissionVersion$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourceShareResponse> deleteResourceShare(DeleteResourceShareRequest deleteResourceShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourceShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourceShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourceShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourceShareRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$deleteResourceShare$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$deleteResourceShare$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateResourceShareResponse> disassociateResourceShare(DisassociateResourceShareRequest disassociateResourceShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateResourceShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateResourceShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateResourceShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateResourceShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateResourceShareRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$disassociateResourceShare$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$disassociateResourceShare$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateResourceSharePermissionResponse> disassociateResourceSharePermission(DisassociateResourceSharePermissionRequest disassociateResourceSharePermissionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateResourceSharePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateResourceSharePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateResourceSharePermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateResourceSharePermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateResourceSharePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateResourceSharePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateResourceSharePermissionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$disassociateResourceSharePermission$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$disassociateResourceSharePermission$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableSharingWithAwsOrganizationResponse> enableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest enableSharingWithAwsOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableSharingWithAwsOrganizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, enableSharingWithAwsOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableSharingWithAwsOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableSharingWithAwsOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSharingWithAwsOrganization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableSharingWithAwsOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableSharingWithAwsOrganizationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$enableSharingWithAwsOrganization$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$enableSharingWithAwsOrganization$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPermissionResponse> getPermission(GetPermissionRequest getPermissionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, getPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetPermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPermissionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$getPermission$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$getPermission$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourcePoliciesResponse> getResourcePolicies(GetResourcePoliciesRequest getResourcePoliciesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, getResourcePoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePoliciesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourcePoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourcePoliciesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$getResourcePolicies$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$getResourcePolicies$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourceShareAssociationsResponse> getResourceShareAssociations(GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceShareAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, getResourceShareAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceShareAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceShareAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceShareAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourceShareAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourceShareAssociationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$getResourceShareAssociations$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$getResourceShareAssociations$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourceShareInvitationsResponse> getResourceShareInvitations(GetResourceShareInvitationsRequest getResourceShareInvitationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceShareInvitationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, getResourceShareInvitationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceShareInvitations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceShareInvitationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceShareInvitations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourceShareInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourceShareInvitationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$getResourceShareInvitations$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$getResourceShareInvitations$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourceSharesResponse> getResourceShares(GetResourceSharesRequest getResourceSharesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceSharesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, getResourceSharesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceShares");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceSharesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceShares").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourceSharesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourceSharesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$getResourceShares$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$getResourceShares$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPendingInvitationResourcesResponse> listPendingInvitationResources(ListPendingInvitationResourcesRequest listPendingInvitationResourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPendingInvitationResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, listPendingInvitationResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPendingInvitationResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPendingInvitationResourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPendingInvitationResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPendingInvitationResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPendingInvitationResourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$listPendingInvitationResources$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$listPendingInvitationResources$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPermissionAssociationsResponse> listPermissionAssociations(ListPermissionAssociationsRequest listPermissionAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPermissionAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, listPermissionAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissionAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissionAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPermissionAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPermissionAssociationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$listPermissionAssociations$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$listPermissionAssociations$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPermissionVersionsResponse> listPermissionVersions(ListPermissionVersionsRequest listPermissionVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPermissionVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, listPermissionVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissionVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissionVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPermissionVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPermissionVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$listPermissionVersions$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$listPermissionVersions$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPermissionsResponse> listPermissions(ListPermissionsRequest listPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, listPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$listPermissions$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$listPermissions$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPrincipalsResponse> listPrincipals(ListPrincipalsRequest listPrincipalsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPrincipalsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, listPrincipalsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPrincipals");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPrincipalsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPrincipals").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPrincipalsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPrincipalsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$listPrincipals$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$listPrincipals$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListReplacePermissionAssociationsWorkResponse> listReplacePermissionAssociationsWork(ListReplacePermissionAssociationsWorkRequest listReplacePermissionAssociationsWorkRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReplacePermissionAssociationsWorkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, listReplacePermissionAssociationsWorkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReplacePermissionAssociationsWork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReplacePermissionAssociationsWorkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReplacePermissionAssociationsWork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListReplacePermissionAssociationsWorkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listReplacePermissionAssociationsWorkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$listReplacePermissionAssociationsWork$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$listReplacePermissionAssociationsWork$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListResourceSharePermissionsResponse> listResourceSharePermissions(ListResourceSharePermissionsRequest listResourceSharePermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceSharePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, listResourceSharePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceSharePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceSharePermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceSharePermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListResourceSharePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listResourceSharePermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$listResourceSharePermissions$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$listResourceSharePermissions$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListResourceTypesResponse> listResourceTypes(ListResourceTypesRequest listResourceTypesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, listResourceTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceTypesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListResourceTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listResourceTypesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$listResourceTypes$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$listResourceTypes$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListResourcesResponse> listResources(ListResourcesRequest listResourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, listResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listResourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$listResources$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$listResources$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PromotePermissionCreatedFromPolicyResponse> promotePermissionCreatedFromPolicy(PromotePermissionCreatedFromPolicyRequest promotePermissionCreatedFromPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)promotePermissionCreatedFromPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, promotePermissionCreatedFromPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PromotePermissionCreatedFromPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PromotePermissionCreatedFromPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PromotePermissionCreatedFromPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PromotePermissionCreatedFromPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)promotePermissionCreatedFromPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$promotePermissionCreatedFromPolicy$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$promotePermissionCreatedFromPolicy$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PromoteResourceShareCreatedFromPolicyResponse> promoteResourceShareCreatedFromPolicy(PromoteResourceShareCreatedFromPolicyRequest promoteResourceShareCreatedFromPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)promoteResourceShareCreatedFromPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, promoteResourceShareCreatedFromPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PromoteResourceShareCreatedFromPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PromoteResourceShareCreatedFromPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PromoteResourceShareCreatedFromPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PromoteResourceShareCreatedFromPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)promoteResourceShareCreatedFromPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$promoteResourceShareCreatedFromPolicy$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$promoteResourceShareCreatedFromPolicy$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RejectResourceShareInvitationResponse> rejectResourceShareInvitation(RejectResourceShareInvitationRequest rejectResourceShareInvitationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectResourceShareInvitationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, rejectResourceShareInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectResourceShareInvitation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectResourceShareInvitationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectResourceShareInvitation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RejectResourceShareInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rejectResourceShareInvitationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$rejectResourceShareInvitation$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$rejectResourceShareInvitation$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReplacePermissionAssociationsResponse> replacePermissionAssociations(ReplacePermissionAssociationsRequest replacePermissionAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)replacePermissionAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, replacePermissionAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReplacePermissionAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReplacePermissionAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReplacePermissionAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ReplacePermissionAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)replacePermissionAssociationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$replacePermissionAssociations$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$replacePermissionAssociations$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetDefaultPermissionVersionResponse> setDefaultPermissionVersion(SetDefaultPermissionVersionRequest setDefaultPermissionVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setDefaultPermissionVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, setDefaultPermissionVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetDefaultPermissionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetDefaultPermissionVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetDefaultPermissionVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetDefaultPermissionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setDefaultPermissionVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$setDefaultPermissionVersion$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$setDefaultPermissionVersion$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$tagResource$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$tagResource$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$untagResource$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$untagResource$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateResourceShareResponse> updateResourceShare(UpdateResourceShareRequest updateResourceShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateResourceShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamAsyncClient.resolveMetricPublishers(clientConfiguration, updateResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResourceShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidResourceTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                    }
                    case "ResourceShareInvitationExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "ResourceShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "UnknownResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                    }
                    case "PermissionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "PermissionVersionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ResourceArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                    }
                    case "UnmatchedPolicyPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyRejectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                    }
                    case "MalformedArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                    }
                    case "InvalidStateTransitionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                    }
                    case "ResourceShareInvitationAlreadyAcceptedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                    }
                    case "ResourceShareInvitationArnNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                    }
                    case "MalformedPolicyTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResourceShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateResourceShareRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRamAsyncClient.lambda$updateResourceShare$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRamAsyncClient.lambda$updateResourceShare$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final RamServiceClientConfiguration serviceClientConfiguration() {
        return new RamServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "ram";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RamException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        RamServiceClientConfigurationBuilder serviceConfigBuilder = new RamServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateResourceShare$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateResourceShare$134(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateResourceShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$130(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$126(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setDefaultPermissionVersion$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setDefaultPermissionVersion$122(List metricPublishers, MetricCollector apiCallMetricCollector, SetDefaultPermissionVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$replacePermissionAssociations$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$replacePermissionAssociations$118(List metricPublishers, MetricCollector apiCallMetricCollector, ReplacePermissionAssociationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rejectResourceShareInvitation$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectResourceShareInvitation$114(List metricPublishers, MetricCollector apiCallMetricCollector, RejectResourceShareInvitationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$promoteResourceShareCreatedFromPolicy$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$promoteResourceShareCreatedFromPolicy$110(List metricPublishers, MetricCollector apiCallMetricCollector, PromoteResourceShareCreatedFromPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$promotePermissionCreatedFromPolicy$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$promotePermissionCreatedFromPolicy$106(List metricPublishers, MetricCollector apiCallMetricCollector, PromotePermissionCreatedFromPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listResources$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResources$102(List metricPublishers, MetricCollector apiCallMetricCollector, ListResourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listResourceTypes$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceTypes$98(List metricPublishers, MetricCollector apiCallMetricCollector, ListResourceTypesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listResourceSharePermissions$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceSharePermissions$94(List metricPublishers, MetricCollector apiCallMetricCollector, ListResourceSharePermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listReplacePermissionAssociationsWork$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReplacePermissionAssociationsWork$90(List metricPublishers, MetricCollector apiCallMetricCollector, ListReplacePermissionAssociationsWorkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPrincipals$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPrincipals$86(List metricPublishers, MetricCollector apiCallMetricCollector, ListPrincipalsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPermissions$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissions$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListPermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPermissionVersions$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissionVersions$78(List metricPublishers, MetricCollector apiCallMetricCollector, ListPermissionVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPermissionAssociations$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissionAssociations$74(List metricPublishers, MetricCollector apiCallMetricCollector, ListPermissionAssociationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPendingInvitationResources$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPendingInvitationResources$70(List metricPublishers, MetricCollector apiCallMetricCollector, ListPendingInvitationResourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourceShares$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceShares$66(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourceSharesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourceShareInvitations$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceShareInvitations$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourceShareInvitationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourceShareAssociations$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceShareAssociations$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourceShareAssociationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourcePolicies$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicies$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourcePoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPermission$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPermission$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetPermissionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableSharingWithAwsOrganization$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableSharingWithAwsOrganization$46(List metricPublishers, MetricCollector apiCallMetricCollector, EnableSharingWithAwsOrganizationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateResourceSharePermission$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateResourceSharePermission$42(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateResourceSharePermissionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateResourceShare$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateResourceShare$38(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateResourceShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteResourceShare$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourceShare$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteResourceShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePermissionVersion$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePermissionVersion$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePermissionVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePermission$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePermission$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePermissionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createResourceShare$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResourceShare$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateResourceShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPermissionVersion$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPermissionVersion$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePermissionVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPermission$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPermission$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePermissionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateResourceSharePermission$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateResourceSharePermission$10(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateResourceSharePermissionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateResourceShare$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateResourceShare$6(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateResourceShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$acceptResourceShareInvitation$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptResourceShareInvitation$2(List metricPublishers, MetricCollector apiCallMetricCollector, AcceptResourceShareInvitationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

