/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.internal.UserAgentUtils;
import software.amazon.awssdk.services.ram.model.ListPrincipalsRequest;
import software.amazon.awssdk.services.ram.model.ListPrincipalsResponse;

public class ListPrincipalsIterable
implements SdkIterable<ListPrincipalsResponse> {
    private final RamClient client;
    private final ListPrincipalsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPrincipalsIterable(RamClient client, ListPrincipalsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPrincipalsResponseFetcher();
    }

    public Iterator<ListPrincipalsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPrincipalsResponseFetcher
    implements SyncPageFetcher<ListPrincipalsResponse> {
        private ListPrincipalsResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPrincipalsResponse nextPage(ListPrincipalsResponse previousPage) {
            if (previousPage == null) {
                return ListPrincipalsIterable.this.client.listPrincipals(ListPrincipalsIterable.this.firstRequest);
            }
            return ListPrincipalsIterable.this.client.listPrincipals((ListPrincipalsRequest)((Object)ListPrincipalsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

