/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.RamServiceClientConfiguration;
import software.amazon.awssdk.services.ram.internal.RamServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.CreatePermissionRequest;
import software.amazon.awssdk.services.ram.model.CreatePermissionResponse;
import software.amazon.awssdk.services.ram.model.CreatePermissionVersionRequest;
import software.amazon.awssdk.services.ram.model.CreatePermissionVersionResponse;
import software.amazon.awssdk.services.ram.model.CreateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.CreateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DeletePermissionRequest;
import software.amazon.awssdk.services.ram.model.DeletePermissionResponse;
import software.amazon.awssdk.services.ram.model.DeletePermissionVersionRequest;
import software.amazon.awssdk.services.ram.model.DeletePermissionVersionResponse;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationRequest;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse;
import software.amazon.awssdk.services.ram.model.GetPermissionRequest;
import software.amazon.awssdk.services.ram.model.GetPermissionResponse;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceSharesRequest;
import software.amazon.awssdk.services.ram.model.GetResourceSharesResponse;
import software.amazon.awssdk.services.ram.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.ram.model.InvalidClientTokenException;
import software.amazon.awssdk.services.ram.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.ram.model.InvalidNextTokenException;
import software.amazon.awssdk.services.ram.model.InvalidParameterException;
import software.amazon.awssdk.services.ram.model.InvalidPolicyException;
import software.amazon.awssdk.services.ram.model.InvalidResourceTypeException;
import software.amazon.awssdk.services.ram.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionAssociationsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionAssociationsResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionsResponse;
import software.amazon.awssdk.services.ram.model.ListPrincipalsRequest;
import software.amazon.awssdk.services.ram.model.ListPrincipalsResponse;
import software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkRequest;
import software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkResponse;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse;
import software.amazon.awssdk.services.ram.model.ListResourceTypesRequest;
import software.amazon.awssdk.services.ram.model.ListResourceTypesResponse;
import software.amazon.awssdk.services.ram.model.ListResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListResourcesResponse;
import software.amazon.awssdk.services.ram.model.MalformedArnException;
import software.amazon.awssdk.services.ram.model.MalformedPolicyTemplateException;
import software.amazon.awssdk.services.ram.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.ram.model.OperationNotPermittedException;
import software.amazon.awssdk.services.ram.model.PermissionAlreadyExistsException;
import software.amazon.awssdk.services.ram.model.PermissionLimitExceededException;
import software.amazon.awssdk.services.ram.model.PermissionVersionsLimitExceededException;
import software.amazon.awssdk.services.ram.model.PromotePermissionCreatedFromPolicyRequest;
import software.amazon.awssdk.services.ram.model.PromotePermissionCreatedFromPolicyResponse;
import software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyRequest;
import software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyResponse;
import software.amazon.awssdk.services.ram.model.RamException;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.ReplacePermissionAssociationsRequest;
import software.amazon.awssdk.services.ram.model.ReplacePermissionAssociationsResponse;
import software.amazon.awssdk.services.ram.model.ResourceArnNotFoundException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationAlreadyAcceptedException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationAlreadyRejectedException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationArnNotFoundException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationExpiredException;
import software.amazon.awssdk.services.ram.model.ResourceShareLimitExceededException;
import software.amazon.awssdk.services.ram.model.ServerInternalException;
import software.amazon.awssdk.services.ram.model.ServiceUnavailableException;
import software.amazon.awssdk.services.ram.model.SetDefaultPermissionVersionRequest;
import software.amazon.awssdk.services.ram.model.SetDefaultPermissionVersionResponse;
import software.amazon.awssdk.services.ram.model.TagLimitExceededException;
import software.amazon.awssdk.services.ram.model.TagPolicyViolationException;
import software.amazon.awssdk.services.ram.model.TagResourceRequest;
import software.amazon.awssdk.services.ram.model.TagResourceResponse;
import software.amazon.awssdk.services.ram.model.ThrottlingException;
import software.amazon.awssdk.services.ram.model.UnknownResourceException;
import software.amazon.awssdk.services.ram.model.UnmatchedPolicyPermissionException;
import software.amazon.awssdk.services.ram.model.UntagResourceRequest;
import software.amazon.awssdk.services.ram.model.UntagResourceResponse;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse;
import software.amazon.awssdk.services.ram.transform.AcceptResourceShareInvitationRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.AssociateResourceSharePermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.AssociateResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.CreatePermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.CreatePermissionVersionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.CreateResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DeletePermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DeletePermissionVersionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DeleteResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DisassociateResourceSharePermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DisassociateResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.EnableSharingWithAwsOrganizationRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetPermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourcePoliciesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourceShareAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourceShareInvitationsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourceSharesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPendingInvitationResourcesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPermissionAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPermissionVersionsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPermissionsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPrincipalsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListReplacePermissionAssociationsWorkRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListResourceSharePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.PromotePermissionCreatedFromPolicyRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.PromoteResourceShareCreatedFromPolicyRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.RejectResourceShareInvitationRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ReplacePermissionAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.SetDefaultPermissionVersionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.UpdateResourceShareRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRamClient
implements RamClient {
    private static final Logger log = Logger.loggerFor(DefaultRamClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRamClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"RAM#2.31.76").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptResourceShareInvitationResponse acceptResourceShareInvitation(AcceptResourceShareInvitationRequest acceptResourceShareInvitationRequest) throws MalformedArnException, OperationNotPermittedException, ResourceShareInvitationArnNotFoundException, ResourceShareInvitationAlreadyAcceptedException, ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, ServerInternalException, ServiceUnavailableException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptResourceShareInvitationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptResourceShareInvitationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, acceptResourceShareInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptResourceShareInvitation");
            AcceptResourceShareInvitationResponse acceptResourceShareInvitationResponse = (AcceptResourceShareInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptResourceShareInvitation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acceptResourceShareInvitationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptResourceShareInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptResourceShareInvitationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$acceptResourceShareInvitation$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateResourceShareResponse associateResourceShare(AssociateResourceShareRequest associateResourceShareRequest) throws IdempotentParameterMismatchException, UnknownResourceException, InvalidStateTransitionException, ResourceShareLimitExceededException, MalformedArnException, InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateResourceShareResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateResourceShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, associateResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateResourceShare");
            AssociateResourceShareResponse associateResourceShareResponse = (AssociateResourceShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateResourceShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateResourceShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateResourceShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$associateResourceShare$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateResourceSharePermissionResponse associateResourceSharePermission(AssociateResourceSharePermissionRequest associateResourceSharePermissionRequest) throws MalformedArnException, UnknownResourceException, InvalidParameterException, InvalidClientTokenException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateResourceSharePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateResourceSharePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, associateResourceSharePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateResourceSharePermission");
            AssociateResourceSharePermissionResponse associateResourceSharePermissionResponse = (AssociateResourceSharePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateResourceSharePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateResourceSharePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateResourceSharePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateResourceSharePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$associateResourceSharePermission$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePermissionResponse createPermission(CreatePermissionRequest createPermissionRequest) throws InvalidParameterException, InvalidPolicyException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, PermissionAlreadyExistsException, MalformedPolicyTemplateException, InvalidClientTokenException, PermissionLimitExceededException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, createPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePermission");
            CreatePermissionResponse createPermissionResponse = (CreatePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$createPermission$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePermissionVersionResponse createPermissionVersion(CreatePermissionVersionRequest createPermissionVersionRequest) throws InvalidParameterException, InvalidPolicyException, ServerInternalException, ServiceUnavailableException, UnknownResourceException, MalformedPolicyTemplateException, MalformedArnException, InvalidClientTokenException, IdempotentParameterMismatchException, PermissionVersionsLimitExceededException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePermissionVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPermissionVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, createPermissionVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePermissionVersion");
            CreatePermissionVersionResponse createPermissionVersionResponse = (CreatePermissionVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePermissionVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPermissionVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePermissionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPermissionVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$createPermissionVersion$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResourceShareResponse createResourceShare(CreateResourceShareRequest createResourceShareRequest) throws IdempotentParameterMismatchException, InvalidStateTransitionException, UnknownResourceException, MalformedArnException, InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException, ResourceShareLimitExceededException, TagPolicyViolationException, TagLimitExceededException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceShareResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createResourceShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, createResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResourceShare");
            CreateResourceShareResponse createResourceShareResponse = (CreateResourceShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResourceShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createResourceShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createResourceShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$createResourceShare$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePermissionResponse deletePermission(DeletePermissionRequest deletePermissionRequest) throws MalformedArnException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, UnknownResourceException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, deletePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePermission");
            DeletePermissionResponse deletePermissionResponse = (DeletePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$deletePermission$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePermissionVersionResponse deletePermissionVersion(DeletePermissionVersionRequest deletePermissionVersionRequest) throws MalformedArnException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, UnknownResourceException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePermissionVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, deletePermissionVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePermissionVersion");
            DeletePermissionVersionResponse deletePermissionVersionResponse = (DeletePermissionVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermissionVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePermissionVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePermissionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePermissionVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$deletePermissionVersion$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourceShareResponse deleteResourceShare(DeleteResourceShareRequest deleteResourceShareRequest) throws OperationNotPermittedException, IdempotentParameterMismatchException, InvalidStateTransitionException, UnknownResourceException, MalformedArnException, InvalidClientTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceShareResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourceShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, deleteResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourceShare");
            DeleteResourceShareResponse deleteResourceShareResponse = (DeleteResourceShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourceShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourceShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourceShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$deleteResourceShare$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateResourceShareResponse disassociateResourceShare(DisassociateResourceShareRequest disassociateResourceShareRequest) throws IdempotentParameterMismatchException, ResourceShareLimitExceededException, MalformedArnException, InvalidStateTransitionException, InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, UnknownResourceException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateResourceShareResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateResourceShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, disassociateResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateResourceShare");
            DisassociateResourceShareResponse disassociateResourceShareResponse = (DisassociateResourceShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateResourceShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateResourceShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateResourceShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$disassociateResourceShare$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateResourceSharePermissionResponse disassociateResourceSharePermission(DisassociateResourceSharePermissionRequest disassociateResourceSharePermissionRequest) throws MalformedArnException, UnknownResourceException, InvalidParameterException, InvalidClientTokenException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, InvalidStateTransitionException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateResourceSharePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateResourceSharePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, disassociateResourceSharePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateResourceSharePermission");
            DisassociateResourceSharePermissionResponse disassociateResourceSharePermissionResponse = (DisassociateResourceSharePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateResourceSharePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateResourceSharePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateResourceSharePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateResourceSharePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$disassociateResourceSharePermission$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableSharingWithAwsOrganizationResponse enableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest enableSharingWithAwsOrganizationRequest) throws OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableSharingWithAwsOrganizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableSharingWithAwsOrganizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, enableSharingWithAwsOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableSharingWithAwsOrganization");
            EnableSharingWithAwsOrganizationResponse enableSharingWithAwsOrganizationResponse = (EnableSharingWithAwsOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSharingWithAwsOrganization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableSharingWithAwsOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableSharingWithAwsOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableSharingWithAwsOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$enableSharingWithAwsOrganization$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPermissionResponse getPermission(GetPermissionRequest getPermissionRequest) throws InvalidParameterException, MalformedArnException, UnknownResourceException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, getPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPermission");
            GetPermissionResponse getPermissionResponse = (GetPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$getPermission$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePoliciesResponse getResourcePolicies(GetResourcePoliciesRequest getResourcePoliciesRequest) throws MalformedArnException, InvalidNextTokenException, InvalidParameterException, ResourceArnNotFoundException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, getResourcePoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicies");
            GetResourcePoliciesResponse getResourcePoliciesResponse = (GetResourcePoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourcePoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$getResourcePolicies$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceShareAssociationsResponse getResourceShareAssociations(GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceShareAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceShareAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, getResourceShareAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceShareAssociations");
            GetResourceShareAssociationsResponse getResourceShareAssociationsResponse = (GetResourceShareAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceShareAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourceShareAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceShareAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceShareAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$getResourceShareAssociations$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceShareInvitationsResponse getResourceShareInvitations(GetResourceShareInvitationsRequest getResourceShareInvitationsRequest) throws ResourceShareInvitationArnNotFoundException, InvalidMaxResultsException, MalformedArnException, UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceShareInvitationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceShareInvitationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, getResourceShareInvitationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceShareInvitations");
            GetResourceShareInvitationsResponse getResourceShareInvitationsResponse = (GetResourceShareInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceShareInvitations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourceShareInvitationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceShareInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceShareInvitationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$getResourceShareInvitations$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceSharesResponse getResourceShares(GetResourceSharesRequest getResourceSharesRequest) throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceSharesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceSharesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, getResourceSharesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceShares");
            GetResourceSharesResponse getResourceSharesResponse = (GetResourceSharesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceShares").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourceSharesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceSharesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceSharesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$getResourceShares$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPendingInvitationResourcesResponse listPendingInvitationResources(ListPendingInvitationResourcesRequest listPendingInvitationResourcesRequest) throws MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, ResourceShareInvitationArnNotFoundException, MissingRequiredParameterException, ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPendingInvitationResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPendingInvitationResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, listPendingInvitationResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPendingInvitationResources");
            ListPendingInvitationResourcesResponse listPendingInvitationResourcesResponse = (ListPendingInvitationResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPendingInvitationResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPendingInvitationResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPendingInvitationResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPendingInvitationResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listPendingInvitationResources$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionAssociationsResponse listPermissionAssociations(ListPermissionAssociationsRequest listPermissionAssociationsRequest) throws InvalidParameterException, MalformedArnException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPermissionAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, listPermissionAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissionAssociations");
            ListPermissionAssociationsResponse listPermissionAssociationsResponse = (ListPermissionAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissionAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPermissionAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPermissionAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPermissionAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listPermissionAssociations$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionVersionsResponse listPermissionVersions(ListPermissionVersionsRequest listPermissionVersionsRequest) throws MalformedArnException, UnknownResourceException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, InvalidParameterException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPermissionVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, listPermissionVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissionVersions");
            ListPermissionVersionsResponse listPermissionVersionsResponse = (ListPermissionVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissionVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPermissionVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPermissionVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPermissionVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listPermissionVersions$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest) throws InvalidParameterException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, listPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissions");
            ListPermissionsResponse listPermissionsResponse = (ListPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listPermissions$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPrincipalsResponse listPrincipals(ListPrincipalsRequest listPrincipalsRequest) throws MalformedArnException, UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPrincipalsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPrincipalsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, listPrincipalsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPrincipals");
            ListPrincipalsResponse listPrincipalsResponse = (ListPrincipalsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPrincipals").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPrincipalsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPrincipalsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPrincipalsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listPrincipals$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReplacePermissionAssociationsWorkResponse listReplacePermissionAssociationsWork(ListReplacePermissionAssociationsWorkRequest listReplacePermissionAssociationsWorkRequest) throws ServerInternalException, ServiceUnavailableException, InvalidNextTokenException, InvalidParameterException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReplacePermissionAssociationsWorkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReplacePermissionAssociationsWorkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, listReplacePermissionAssociationsWorkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReplacePermissionAssociationsWork");
            ListReplacePermissionAssociationsWorkResponse listReplacePermissionAssociationsWorkResponse = (ListReplacePermissionAssociationsWorkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReplacePermissionAssociationsWork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listReplacePermissionAssociationsWorkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReplacePermissionAssociationsWorkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReplacePermissionAssociationsWorkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listReplacePermissionAssociationsWork$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceSharePermissionsResponse listResourceSharePermissions(ListResourceSharePermissionsRequest listResourceSharePermissionsRequest) throws InvalidParameterException, MalformedArnException, UnknownResourceException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceSharePermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceSharePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, listResourceSharePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceSharePermissions");
            ListResourceSharePermissionsResponse listResourceSharePermissionsResponse = (ListResourceSharePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceSharePermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResourceSharePermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceSharePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceSharePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listResourceSharePermissions$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceTypesResponse listResourceTypes(ListResourceTypesRequest listResourceTypesRequest) throws InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, listResourceTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceTypes");
            ListResourceTypesResponse listResourceTypesResponse = (ListResourceTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResourceTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listResourceTypes$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidResourceTypeException, UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, listResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResources");
            ListResourcesResponse listResourcesResponse = (ListResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listResources$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PromotePermissionCreatedFromPolicyResponse promotePermissionCreatedFromPolicy(PromotePermissionCreatedFromPolicyRequest promotePermissionCreatedFromPolicyRequest) throws MalformedArnException, OperationNotPermittedException, InvalidParameterException, MissingRequiredParameterException, ServerInternalException, ServiceUnavailableException, UnknownResourceException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PromotePermissionCreatedFromPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)promotePermissionCreatedFromPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, promotePermissionCreatedFromPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PromotePermissionCreatedFromPolicy");
            PromotePermissionCreatedFromPolicyResponse promotePermissionCreatedFromPolicyResponse = (PromotePermissionCreatedFromPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PromotePermissionCreatedFromPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)promotePermissionCreatedFromPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PromotePermissionCreatedFromPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return promotePermissionCreatedFromPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$promotePermissionCreatedFromPolicy$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PromoteResourceShareCreatedFromPolicyResponse promoteResourceShareCreatedFromPolicy(PromoteResourceShareCreatedFromPolicyRequest promoteResourceShareCreatedFromPolicyRequest) throws MalformedArnException, ResourceShareLimitExceededException, OperationNotPermittedException, InvalidParameterException, MissingRequiredParameterException, ServerInternalException, ServiceUnavailableException, UnknownResourceException, InvalidStateTransitionException, UnmatchedPolicyPermissionException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PromoteResourceShareCreatedFromPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)promoteResourceShareCreatedFromPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, promoteResourceShareCreatedFromPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PromoteResourceShareCreatedFromPolicy");
            PromoteResourceShareCreatedFromPolicyResponse promoteResourceShareCreatedFromPolicyResponse = (PromoteResourceShareCreatedFromPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PromoteResourceShareCreatedFromPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)promoteResourceShareCreatedFromPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PromoteResourceShareCreatedFromPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return promoteResourceShareCreatedFromPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$promoteResourceShareCreatedFromPolicy$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectResourceShareInvitationResponse rejectResourceShareInvitation(RejectResourceShareInvitationRequest rejectResourceShareInvitationRequest) throws MalformedArnException, OperationNotPermittedException, ResourceShareInvitationArnNotFoundException, ResourceShareInvitationAlreadyAcceptedException, ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, ServerInternalException, ServiceUnavailableException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectResourceShareInvitationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectResourceShareInvitationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, rejectResourceShareInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectResourceShareInvitation");
            RejectResourceShareInvitationResponse rejectResourceShareInvitationResponse = (RejectResourceShareInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectResourceShareInvitation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rejectResourceShareInvitationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectResourceShareInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectResourceShareInvitationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$rejectResourceShareInvitation$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplacePermissionAssociationsResponse replacePermissionAssociations(ReplacePermissionAssociationsRequest replacePermissionAssociationsRequest) throws MalformedArnException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, UnknownResourceException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReplacePermissionAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)replacePermissionAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, replacePermissionAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReplacePermissionAssociations");
            ReplacePermissionAssociationsResponse replacePermissionAssociationsResponse = (ReplacePermissionAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReplacePermissionAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)replacePermissionAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReplacePermissionAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return replacePermissionAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$replacePermissionAssociations$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetDefaultPermissionVersionResponse setDefaultPermissionVersion(SetDefaultPermissionVersionRequest setDefaultPermissionVersionRequest) throws InvalidParameterException, MalformedArnException, ServerInternalException, ServiceUnavailableException, UnknownResourceException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetDefaultPermissionVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setDefaultPermissionVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, setDefaultPermissionVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetDefaultPermissionVersion");
            SetDefaultPermissionVersionResponse setDefaultPermissionVersionResponse = (SetDefaultPermissionVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetDefaultPermissionVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setDefaultPermissionVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetDefaultPermissionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setDefaultPermissionVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$setDefaultPermissionVersion$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException, MalformedArnException, UnknownResourceException, TagLimitExceededException, ResourceArnNotFoundException, TagPolicyViolationException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$tagResource$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws UnknownResourceException, InvalidParameterException, MalformedArnException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$untagResource$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResourceShareResponse updateResourceShare(UpdateResourceShareRequest updateResourceShareRequest) throws IdempotentParameterMismatchException, MissingRequiredParameterException, UnknownResourceException, MalformedArnException, InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceShareResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidResourceTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
                }
                case "ResourceShareInvitationExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "ResourceShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "UnknownResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownResourceException::builder).build());
                }
                case "PermissionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionLimitExceededException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "PermissionVersionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionVersionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionVersionsLimitExceededException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ResourceArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotFoundException::builder).build());
                }
                case "UnmatchedPolicyPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmatchedPolicyPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmatchedPolicyPermissionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyRejectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).build());
                }
                case "MalformedArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedArnException::builder).build());
                }
                case "InvalidStateTransitionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
                }
                case "ResourceShareInvitationAlreadyAcceptedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).build());
                }
                case "ResourceShareInvitationArnNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).build());
                }
                case "MalformedPolicyTemplateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyTemplateException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateResourceShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(clientConfiguration, updateResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResourceShare");
            UpdateResourceShareResponse updateResourceShareResponse = (UpdateResourceShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResourceShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateResourceShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateResourceShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$updateResourceShare$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "ram";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        RamServiceClientConfigurationBuilder serviceConfigBuilder = new RamServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RamException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final RamServiceClientConfiguration serviceClientConfiguration() {
        return new RamServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateResourceShare$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setDefaultPermissionVersion$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$replacePermissionAssociations$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectResourceShareInvitation$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$promoteResourceShareCreatedFromPolicy$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$promotePermissionCreatedFromPolicy$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResources$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceTypes$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceSharePermissions$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReplacePermissionAssociationsWork$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPrincipals$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissions$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissionVersions$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissionAssociations$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPendingInvitationResources$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceShares$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceShareInvitations$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceShareAssociations$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicies$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPermission$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableSharingWithAwsOrganization$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateResourceSharePermission$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateResourceShare$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourceShare$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePermissionVersion$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePermission$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResourceShare$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPermissionVersion$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPermission$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateResourceSharePermission$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateResourceShare$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptResourceShareInvitation$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

