/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.ResourceArnListCopier;
import software.amazon.awssdk.services.ram.model.ResourceOwner;
import software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter;
import software.amazon.awssdk.services.ram.model.ResourceShareArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcesRequest
extends RamRequest
implements ToCopyableBuilder<Builder, ListResourcesRequest> {
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceOwner").getter(ListResourcesRequest.getter(ListResourcesRequest::resourceOwnerAsString)).setter(ListResourcesRequest.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principal").getter(ListResourcesRequest.getter(ListResourcesRequest::principal)).setter(ListResourcesRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ListResourcesRequest.getter(ListResourcesRequest::resourceType)).setter(ListResourcesRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceArns").getter(ListResourcesRequest.getter(ListResourcesRequest::resourceArns)).setter(ListResourcesRequest.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_SHARE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceShareArns").getter(ListResourcesRequest.getter(ListResourcesRequest::resourceShareArns)).setter(ListResourcesRequest.setter(Builder::resourceShareArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListResourcesRequest.getter(ListResourcesRequest::nextToken)).setter(ListResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListResourcesRequest.getter(ListResourcesRequest::maxResults)).setter(ListResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceRegionScope").getter(ListResourcesRequest.getter(ListResourcesRequest::resourceRegionScopeAsString)).setter(ListResourcesRequest.setter(Builder::resourceRegionScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRegionScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_OWNER_FIELD, PRINCIPAL_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ARNS_FIELD, RESOURCE_SHARE_ARNS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOURCE_REGION_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourcesRequest.memberNameToFieldInitializer();
    private final String resourceOwner;
    private final String principal;
    private final String resourceType;
    private final List<String> resourceArns;
    private final List<String> resourceShareArns;
    private final String nextToken;
    private final Integer maxResults;
    private final String resourceRegionScope;

    private ListResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceOwner = builder.resourceOwner;
        this.principal = builder.principal;
        this.resourceType = builder.resourceType;
        this.resourceArns = builder.resourceArns;
        this.resourceShareArns = builder.resourceShareArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resourceRegionScope = builder.resourceRegionScope;
    }

    public final ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(this.resourceOwner);
    }

    public final String resourceOwnerAsString() {
        return this.resourceOwner;
    }

    public final String principal() {
        return this.principal;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArns() {
        return this.resourceArns;
    }

    public final boolean hasResourceShareArns() {
        return this.resourceShareArns != null && !(this.resourceShareArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceShareArns() {
        return this.resourceShareArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ResourceRegionScopeFilter resourceRegionScope() {
        return ResourceRegionScopeFilter.fromValue(this.resourceRegionScope);
    }

    public final String resourceRegionScopeAsString() {
        return this.resourceRegionScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceShareArns() ? this.resourceShareArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegionScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesRequest)) {
            return false;
        }
        ListResourcesRequest other = (ListResourcesRequest)((Object)obj);
        return Objects.equals(this.resourceOwnerAsString(), other.resourceOwnerAsString()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.resourceType(), other.resourceType()) && this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns()) && this.hasResourceShareArns() == other.hasResourceShareArns() && Objects.equals(this.resourceShareArns(), other.resourceShareArns()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.resourceRegionScopeAsString(), other.resourceRegionScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourcesRequest").add("ResourceOwner", (Object)this.resourceOwnerAsString()).add("Principal", (Object)this.principal()).add("ResourceType", (Object)this.resourceType()).add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).add("ResourceShareArns", this.hasResourceShareArns() ? this.resourceShareArns() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ResourceRegionScope", (Object)this.resourceRegionScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAsString()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "resourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "resourceShareArns": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "resourceRegionScope": {
                return Optional.ofNullable(clazz.cast(this.resourceRegionScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceOwner", RESOURCE_OWNER_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("resourceArns", RESOURCE_ARNS_FIELD);
        map.put("resourceShareArns", RESOURCE_SHARE_ARNS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("resourceRegionScope", RESOURCE_REGION_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesRequest, T> g) {
        return obj -> g.apply((ListResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String resourceOwner;
        private String principal;
        private String resourceType;
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceShareArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private String resourceRegionScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesRequest model) {
            super(model);
            this.resourceOwner(model.resourceOwner);
            this.principal(model.principal);
            this.resourceType(model.resourceType);
            this.resourceArns(model.resourceArns);
            this.resourceShareArns(model.resourceShareArns);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.resourceRegionScope(model.resourceRegionScope);
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Collection<String> getResourceShareArns() {
            if (this.resourceShareArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceShareArns;
        }

        public final void setResourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
        }

        @Override
        public final Builder resourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareArns(String ... resourceShareArns) {
            this.resourceShareArns(Arrays.asList(resourceShareArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getResourceRegionScope() {
            return this.resourceRegionScope;
        }

        public final void setResourceRegionScope(String resourceRegionScope) {
            this.resourceRegionScope = resourceRegionScope;
        }

        @Override
        public final Builder resourceRegionScope(String resourceRegionScope) {
            this.resourceRegionScope = resourceRegionScope;
            return this;
        }

        @Override
        public final Builder resourceRegionScope(ResourceRegionScopeFilter resourceRegionScope) {
            this.resourceRegionScope(resourceRegionScope == null ? null : resourceRegionScope.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourcesRequest build() {
            return new ListResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourcesRequest> {
        public Builder resourceOwner(String var1);

        public Builder resourceOwner(ResourceOwner var1);

        public Builder principal(String var1);

        public Builder resourceType(String var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder resourceShareArns(Collection<String> var1);

        public Builder resourceShareArns(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder resourceRegionScope(String var1);

        public Builder resourceRegionScope(ResourceRegionScopeFilter var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

