/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse;

public class GetResourcePoliciesIterable
implements SdkIterable<GetResourcePoliciesResponse> {
    private final RamClient client;
    private final GetResourcePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourcePoliciesIterable(RamClient client, GetResourcePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetResourcePoliciesResponseFetcher();
    }

    public Iterator<GetResourcePoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetResourcePoliciesIterable resume(GetResourcePoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetResourcePoliciesIterable(this.client, (GetResourcePoliciesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetResourcePoliciesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetResourcePoliciesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetResourcePoliciesResponseFetcher
    implements SyncPageFetcher<GetResourcePoliciesResponse> {
        private GetResourcePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourcePoliciesResponse nextPage(GetResourcePoliciesResponse previousPage) {
            if (previousPage == null) {
                return GetResourcePoliciesIterable.this.client.getResourcePolicies(GetResourcePoliciesIterable.this.firstRequest);
            }
            return GetResourcePoliciesIterable.this.client.getResourcePolicies((GetResourcePoliciesRequest)((Object)GetResourcePoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

