/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.ListResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListResourcesResponse;

public class ListResourcesIterable
implements SdkIterable<ListResourcesResponse> {
    private final RamClient client;
    private final ListResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourcesIterable(RamClient client, ListResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResourcesResponseFetcher();
    }

    public Iterator<ListResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListResourcesIterable resume(ListResourcesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListResourcesIterable(this.client, (ListResourcesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListResourcesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListResourcesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListResourcesResponseFetcher
    implements SyncPageFetcher<ListResourcesResponse> {
        private ListResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourcesResponse nextPage(ListResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListResourcesIterable.this.client.listResources(ListResourcesIterable.this.firstRequest);
            }
            return ListResourcesIterable.this.client.listResources((ListResourcesRequest)((Object)ListResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

