/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociation;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateResourceShareResponse
extends RamResponse
implements ToCopyableBuilder<Builder, DisassociateResourceShareResponse> {
    private static final SdkField<List<ResourceShareAssociation>> RESOURCE_SHARE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DisassociateResourceShareResponse.getter(DisassociateResourceShareResponse::resourceShareAssociations)).setter(DisassociateResourceShareResponse.setter(Builder::resourceShareAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceShareAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DisassociateResourceShareResponse.getter(DisassociateResourceShareResponse::clientToken)).setter(DisassociateResourceShareResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ASSOCIATIONS_FIELD, CLIENT_TOKEN_FIELD));
    private final List<ResourceShareAssociation> resourceShareAssociations;
    private final String clientToken;

    private DisassociateResourceShareResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShareAssociations = builder.resourceShareAssociations;
        this.clientToken = builder.clientToken;
    }

    public List<ResourceShareAssociation> resourceShareAssociations() {
        return this.resourceShareAssociations;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResourceShareResponse)) {
            return false;
        }
        DisassociateResourceShareResponse other = (DisassociateResourceShareResponse)((Object)obj);
        return Objects.equals(this.resourceShareAssociations(), other.resourceShareAssociations()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"DisassociateResourceShareResponse").add("ResourceShareAssociations", this.resourceShareAssociations()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareAssociations": {
                return Optional.ofNullable(clazz.cast(this.resourceShareAssociations()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResourceShareResponse, T> g) {
        return obj -> g.apply((DisassociateResourceShareResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private List<ResourceShareAssociation> resourceShareAssociations = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResourceShareResponse model) {
            super(model);
            this.resourceShareAssociations(model.resourceShareAssociations);
            this.clientToken(model.clientToken);
        }

        public final Collection<ResourceShareAssociation.Builder> getResourceShareAssociations() {
            return this.resourceShareAssociations != null ? (Collection)this.resourceShareAssociations.stream().map(ResourceShareAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceShareAssociations(Collection<ResourceShareAssociation> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copy(resourceShareAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareAssociations(ResourceShareAssociation ... resourceShareAssociations) {
            this.resourceShareAssociations(Arrays.asList(resourceShareAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder> ... resourceShareAssociations) {
            this.resourceShareAssociations(Stream.of(resourceShareAssociations).map(c -> (ResourceShareAssociation)((ResourceShareAssociation.Builder)ResourceShareAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceShareAssociations(Collection<ResourceShareAssociation.BuilderImpl> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copyFromBuilder(resourceShareAssociations);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public DisassociateResourceShareResponse build() {
            return new DisassociateResourceShareResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateResourceShareResponse> {
        public Builder resourceShareAssociations(Collection<ResourceShareAssociation> var1);

        public Builder resourceShareAssociations(ResourceShareAssociation ... var1);

        public Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder> ... var1);

        public Builder clientToken(String var1);
    }
}

