/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.GroupMember;
import software.amazon.awssdk.services.quicksight.model.GroupMemberListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupMembershipsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListGroupMembershipsResponse> {
    private static final SdkField<List<GroupMember>> GROUP_MEMBER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListGroupMembershipsResponse.getter(ListGroupMembershipsResponse::groupMemberList)).setter(ListGroupMembershipsResponse.setter(Builder::groupMemberList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupMemberList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListGroupMembershipsResponse.getter(ListGroupMembershipsResponse::nextToken)).setter(ListGroupMembershipsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListGroupMembershipsResponse.getter(ListGroupMembershipsResponse::requestId)).setter(ListGroupMembershipsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListGroupMembershipsResponse.getter(ListGroupMembershipsResponse::status)).setter(ListGroupMembershipsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_MEMBER_LIST_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final List<GroupMember> groupMemberList;
    private final String nextToken;
    private final String requestId;
    private final Integer status;

    private ListGroupMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.groupMemberList = builder.groupMemberList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public List<GroupMember> groupMemberList() {
        return this.groupMemberList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String requestId() {
        return this.requestId;
    }

    public Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupMemberList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupMembershipsResponse)) {
            return false;
        }
        ListGroupMembershipsResponse other = (ListGroupMembershipsResponse)((Object)obj);
        return Objects.equals(this.groupMemberList(), other.groupMemberList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"ListGroupMembershipsResponse").add("GroupMemberList", this.groupMemberList()).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupMemberList": {
                return Optional.ofNullable(clazz.cast(this.groupMemberList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupMembershipsResponse, T> g) {
        return obj -> g.apply((ListGroupMembershipsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<GroupMember> groupMemberList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupMembershipsResponse model) {
            super(model);
            this.groupMemberList(model.groupMemberList);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final Collection<GroupMember.Builder> getGroupMemberList() {
            return this.groupMemberList != null ? (Collection)this.groupMemberList.stream().map(GroupMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groupMemberList(Collection<GroupMember> groupMemberList) {
            this.groupMemberList = GroupMemberListCopier.copy(groupMemberList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupMemberList(GroupMember ... groupMemberList) {
            this.groupMemberList(Arrays.asList(groupMemberList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupMemberList(Consumer<GroupMember.Builder> ... groupMemberList) {
            this.groupMemberList(Stream.of(groupMemberList).map(c -> (GroupMember)((GroupMember.Builder)GroupMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroupMemberList(Collection<GroupMember.BuilderImpl> groupMemberList) {
            this.groupMemberList = GroupMemberListCopier.copyFromBuilder(groupMemberList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public ListGroupMembershipsResponse build() {
            return new ListGroupMembershipsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupMembershipsResponse> {
        public Builder groupMemberList(Collection<GroupMember> var1);

        public Builder groupMemberList(GroupMember ... var1);

        public Builder groupMemberList(Consumer<GroupMember.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

