/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExceptionResourceType {
    USER("USER"),
    GROUP("GROUP"),
    NAMESPACE("NAMESPACE"),
    ACCOUNT_SETTINGS("ACCOUNT_SETTINGS"),
    IAMPOLICY_ASSIGNMENT("IAMPOLICY_ASSIGNMENT"),
    DATA_SOURCE("DATA_SOURCE"),
    DATA_SET("DATA_SET"),
    VPC_CONNECTION("VPC_CONNECTION"),
    INGESTION("INGESTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExceptionResourceType> VALUE_MAP;
    private final String value;

    private ExceptionResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExceptionResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExceptionResourceType> knownValues() {
        EnumSet<ExceptionResourceType> knownValues = EnumSet.allOf(ExceptionResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExceptionResourceType.class, ExceptionResourceType::toString);
    }
}

