/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AnalysisDefinition;
import software.amazon.awssdk.services.quicksight.model.AnalysisSourceEntity;
import software.amazon.awssdk.services.quicksight.model.Parameters;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.ValidationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnalysisRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateAnalysisRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateAnalysisRequest.getter(UpdateAnalysisRequest::awsAccountId)).setter(UpdateAnalysisRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisId").getter(UpdateAnalysisRequest.getter(UpdateAnalysisRequest::analysisId)).setter(UpdateAnalysisRequest.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AnalysisId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateAnalysisRequest.getter(UpdateAnalysisRequest::name)).setter(UpdateAnalysisRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Parameters").getter(UpdateAnalysisRequest.getter(UpdateAnalysisRequest::parameters)).setter(UpdateAnalysisRequest.setter(Builder::parameters)).constructor(Parameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final SdkField<AnalysisSourceEntity> SOURCE_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceEntity").getter(UpdateAnalysisRequest.getter(UpdateAnalysisRequest::sourceEntity)).setter(UpdateAnalysisRequest.setter(Builder::sourceEntity)).constructor(AnalysisSourceEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()}).build();
    private static final SdkField<String> THEME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeArn").getter(UpdateAnalysisRequest.getter(UpdateAnalysisRequest::themeArn)).setter(UpdateAnalysisRequest.setter(Builder::themeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()}).build();
    private static final SdkField<AnalysisDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(UpdateAnalysisRequest.getter(UpdateAnalysisRequest::definition)).setter(UpdateAnalysisRequest.setter(Builder::definition)).constructor(AnalysisDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<ValidationStrategy> VALIDATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationStrategy").getter(UpdateAnalysisRequest.getter(UpdateAnalysisRequest::validationStrategy)).setter(UpdateAnalysisRequest.setter(Builder::validationStrategy)).constructor(ValidationStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ANALYSIS_ID_FIELD, NAME_FIELD, PARAMETERS_FIELD, SOURCE_ENTITY_FIELD, THEME_ARN_FIELD, DEFINITION_FIELD, VALIDATION_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAnalysisRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String analysisId;
    private final String name;
    private final Parameters parameters;
    private final AnalysisSourceEntity sourceEntity;
    private final String themeArn;
    private final AnalysisDefinition definition;
    private final ValidationStrategy validationStrategy;

    private UpdateAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.analysisId = builder.analysisId;
        this.name = builder.name;
        this.parameters = builder.parameters;
        this.sourceEntity = builder.sourceEntity;
        this.themeArn = builder.themeArn;
        this.definition = builder.definition;
        this.validationStrategy = builder.validationStrategy;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String analysisId() {
        return this.analysisId;
    }

    public final String name() {
        return this.name;
    }

    public final Parameters parameters() {
        return this.parameters;
    }

    public final AnalysisSourceEntity sourceEntity() {
        return this.sourceEntity;
    }

    public final String themeArn() {
        return this.themeArn;
    }

    public final AnalysisDefinition definition() {
        return this.definition;
    }

    public final ValidationStrategy validationStrategy() {
        return this.validationStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStrategy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnalysisRequest)) {
            return false;
        }
        UpdateAnalysisRequest other = (UpdateAnalysisRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.analysisId(), other.analysisId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.sourceEntity(), other.sourceEntity()) && Objects.equals(this.themeArn(), other.themeArn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.validationStrategy(), other.validationStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAnalysisRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("AnalysisId", (Object)this.analysisId()).add("Name", (Object)this.name()).add("Parameters", (Object)this.parameters()).add("SourceEntity", (Object)this.sourceEntity()).add("ThemeArn", (Object)this.themeArn()).add("Definition", (Object)this.definition()).add("ValidationStrategy", (Object)this.validationStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "SourceEntity": {
                return Optional.ofNullable(clazz.cast(this.sourceEntity()));
            }
            case "ThemeArn": {
                return Optional.ofNullable(clazz.cast(this.themeArn()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "ValidationStrategy": {
                return Optional.ofNullable(clazz.cast(this.validationStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("AnalysisId", ANALYSIS_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("SourceEntity", SOURCE_ENTITY_FIELD);
        map.put("ThemeArn", THEME_ARN_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("ValidationStrategy", VALIDATION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnalysisRequest, T> g) {
        return obj -> g.apply((UpdateAnalysisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String analysisId;
        private String name;
        private Parameters parameters;
        private AnalysisSourceEntity sourceEntity;
        private String themeArn;
        private AnalysisDefinition definition;
        private ValidationStrategy validationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnalysisRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.analysisId(model.analysisId);
            this.name(model.name);
            this.parameters(model.parameters);
            this.sourceEntity(model.sourceEntity);
            this.themeArn(model.themeArn);
            this.definition(model.definition);
            this.validationStrategy(model.validationStrategy);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Parameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final AnalysisSourceEntity.Builder getSourceEntity() {
            return this.sourceEntity != null ? this.sourceEntity.toBuilder() : null;
        }

        public final void setSourceEntity(AnalysisSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        @Override
        public final Builder sourceEntity(AnalysisSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final String getThemeArn() {
            return this.themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final AnalysisDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(AnalysisDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(AnalysisDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final ValidationStrategy.Builder getValidationStrategy() {
            return this.validationStrategy != null ? this.validationStrategy.toBuilder() : null;
        }

        public final void setValidationStrategy(ValidationStrategy.BuilderImpl validationStrategy) {
            this.validationStrategy = validationStrategy != null ? validationStrategy.build() : null;
        }

        @Override
        public final Builder validationStrategy(ValidationStrategy validationStrategy) {
            this.validationStrategy = validationStrategy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnalysisRequest build() {
            return new UpdateAnalysisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnalysisRequest> {
        public Builder awsAccountId(String var1);

        public Builder analysisId(String var1);

        public Builder name(String var1);

        public Builder parameters(Parameters var1);

        default public Builder parameters(Consumer<Parameters.Builder> parameters) {
            return this.parameters((Parameters)((Parameters.Builder)Parameters.builder().applyMutation(parameters)).build());
        }

        public Builder sourceEntity(AnalysisSourceEntity var1);

        default public Builder sourceEntity(Consumer<AnalysisSourceEntity.Builder> sourceEntity) {
            return this.sourceEntity((AnalysisSourceEntity)((AnalysisSourceEntity.Builder)AnalysisSourceEntity.builder().applyMutation(sourceEntity)).build());
        }

        public Builder themeArn(String var1);

        public Builder definition(AnalysisDefinition var1);

        default public Builder definition(Consumer<AnalysisDefinition.Builder> definition) {
            return this.definition((AnalysisDefinition)((AnalysisDefinition.Builder)AnalysisDefinition.builder().applyMutation(definition)).build());
        }

        public Builder validationStrategy(ValidationStrategy var1);

        default public Builder validationStrategy(Consumer<ValidationStrategy.Builder> validationStrategy) {
            return this.validationStrategy((ValidationStrategy)((ValidationStrategy.Builder)ValidationStrategy.builder().applyMutation(validationStrategy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

