/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldOrderListCopier;
import software.amazon.awssdk.services.quicksight.model.TableFieldOption;
import software.amazon.awssdk.services.quicksight.model.TableFieldOptionListCopier;
import software.amazon.awssdk.services.quicksight.model.TablePinnedFieldOptions;
import software.amazon.awssdk.services.quicksight.model.TransposedTableOption;
import software.amazon.awssdk.services.quicksight.model.TransposedTableOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableFieldOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableFieldOptions> {
    private static final SdkField<List<TableFieldOption>> SELECTED_FIELD_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedFieldOptions").getter(TableFieldOptions.getter(TableFieldOptions::selectedFieldOptions)).setter(TableFieldOptions.setter(Builder::selectedFieldOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFieldOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableFieldOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Order").getter(TableFieldOptions.getter(TableFieldOptions::order)).setter(TableFieldOptions.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Order").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TablePinnedFieldOptions> PINNED_FIELD_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PinnedFieldOptions").getter(TableFieldOptions.getter(TableFieldOptions::pinnedFieldOptions)).setter(TableFieldOptions.setter(Builder::pinnedFieldOptions)).constructor(TablePinnedFieldOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinnedFieldOptions").build()}).build();
    private static final SdkField<List<TransposedTableOption>> TRANSPOSED_TABLE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransposedTableOptions").getter(TableFieldOptions.getter(TableFieldOptions::transposedTableOptions)).setter(TableFieldOptions.setter(Builder::transposedTableOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransposedTableOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransposedTableOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_FIELD_OPTIONS_FIELD, ORDER_FIELD, PINNED_FIELD_OPTIONS_FIELD, TRANSPOSED_TABLE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableFieldOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<TableFieldOption> selectedFieldOptions;
    private final List<String> order;
    private final TablePinnedFieldOptions pinnedFieldOptions;
    private final List<TransposedTableOption> transposedTableOptions;

    private TableFieldOptions(BuilderImpl builder) {
        this.selectedFieldOptions = builder.selectedFieldOptions;
        this.order = builder.order;
        this.pinnedFieldOptions = builder.pinnedFieldOptions;
        this.transposedTableOptions = builder.transposedTableOptions;
    }

    public final boolean hasSelectedFieldOptions() {
        return this.selectedFieldOptions != null && !(this.selectedFieldOptions instanceof SdkAutoConstructList);
    }

    public final List<TableFieldOption> selectedFieldOptions() {
        return this.selectedFieldOptions;
    }

    public final boolean hasOrder() {
        return this.order != null && !(this.order instanceof SdkAutoConstructList);
    }

    public final List<String> order() {
        return this.order;
    }

    public final TablePinnedFieldOptions pinnedFieldOptions() {
        return this.pinnedFieldOptions;
    }

    public final boolean hasTransposedTableOptions() {
        return this.transposedTableOptions != null && !(this.transposedTableOptions instanceof SdkAutoConstructList);
    }

    public final List<TransposedTableOption> transposedTableOptions() {
        return this.transposedTableOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedFieldOptions() ? this.selectedFieldOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrder() ? this.order() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pinnedFieldOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransposedTableOptions() ? this.transposedTableOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldOptions)) {
            return false;
        }
        TableFieldOptions other = (TableFieldOptions)obj;
        return this.hasSelectedFieldOptions() == other.hasSelectedFieldOptions() && Objects.equals(this.selectedFieldOptions(), other.selectedFieldOptions()) && this.hasOrder() == other.hasOrder() && Objects.equals(this.order(), other.order()) && Objects.equals(this.pinnedFieldOptions(), other.pinnedFieldOptions()) && this.hasTransposedTableOptions() == other.hasTransposedTableOptions() && Objects.equals(this.transposedTableOptions(), other.transposedTableOptions());
    }

    public final String toString() {
        return ToString.builder((String)"TableFieldOptions").add("SelectedFieldOptions", this.hasSelectedFieldOptions() ? this.selectedFieldOptions() : null).add("Order", this.hasOrder() ? this.order() : null).add("PinnedFieldOptions", (Object)this.pinnedFieldOptions()).add("TransposedTableOptions", this.hasTransposedTableOptions() ? this.transposedTableOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectedFieldOptions": {
                return Optional.ofNullable(clazz.cast(this.selectedFieldOptions()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.order()));
            }
            case "PinnedFieldOptions": {
                return Optional.ofNullable(clazz.cast(this.pinnedFieldOptions()));
            }
            case "TransposedTableOptions": {
                return Optional.ofNullable(clazz.cast(this.transposedTableOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SelectedFieldOptions", SELECTED_FIELD_OPTIONS_FIELD);
        map.put("Order", ORDER_FIELD);
        map.put("PinnedFieldOptions", PINNED_FIELD_OPTIONS_FIELD);
        map.put("TransposedTableOptions", TRANSPOSED_TABLE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableFieldOptions, T> g) {
        return obj -> g.apply((TableFieldOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TableFieldOption> selectedFieldOptions = DefaultSdkAutoConstructList.getInstance();
        private List<String> order = DefaultSdkAutoConstructList.getInstance();
        private TablePinnedFieldOptions pinnedFieldOptions;
        private List<TransposedTableOption> transposedTableOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldOptions model) {
            this.selectedFieldOptions(model.selectedFieldOptions);
            this.order(model.order);
            this.pinnedFieldOptions(model.pinnedFieldOptions);
            this.transposedTableOptions(model.transposedTableOptions);
        }

        public final List<TableFieldOption.Builder> getSelectedFieldOptions() {
            List<TableFieldOption.Builder> result = TableFieldOptionListCopier.copyToBuilder(this.selectedFieldOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedFieldOptions(Collection<TableFieldOption.BuilderImpl> selectedFieldOptions) {
            this.selectedFieldOptions = TableFieldOptionListCopier.copyFromBuilder(selectedFieldOptions);
        }

        @Override
        public final Builder selectedFieldOptions(Collection<TableFieldOption> selectedFieldOptions) {
            this.selectedFieldOptions = TableFieldOptionListCopier.copy(selectedFieldOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFieldOptions(TableFieldOption ... selectedFieldOptions) {
            this.selectedFieldOptions(Arrays.asList(selectedFieldOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFieldOptions(Consumer<TableFieldOption.Builder> ... selectedFieldOptions) {
            this.selectedFieldOptions(Stream.of(selectedFieldOptions).map(c -> (TableFieldOption)((TableFieldOption.Builder)TableFieldOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOrder() {
            if (this.order instanceof SdkAutoConstructList) {
                return null;
            }
            return this.order;
        }

        public final void setOrder(Collection<String> order) {
            this.order = FieldOrderListCopier.copy(order);
        }

        @Override
        public final Builder order(Collection<String> order) {
            this.order = FieldOrderListCopier.copy(order);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder order(String ... order) {
            this.order(Arrays.asList(order));
            return this;
        }

        public final TablePinnedFieldOptions.Builder getPinnedFieldOptions() {
            return this.pinnedFieldOptions != null ? this.pinnedFieldOptions.toBuilder() : null;
        }

        public final void setPinnedFieldOptions(TablePinnedFieldOptions.BuilderImpl pinnedFieldOptions) {
            this.pinnedFieldOptions = pinnedFieldOptions != null ? pinnedFieldOptions.build() : null;
        }

        @Override
        public final Builder pinnedFieldOptions(TablePinnedFieldOptions pinnedFieldOptions) {
            this.pinnedFieldOptions = pinnedFieldOptions;
            return this;
        }

        public final List<TransposedTableOption.Builder> getTransposedTableOptions() {
            List<TransposedTableOption.Builder> result = TransposedTableOptionListCopier.copyToBuilder(this.transposedTableOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransposedTableOptions(Collection<TransposedTableOption.BuilderImpl> transposedTableOptions) {
            this.transposedTableOptions = TransposedTableOptionListCopier.copyFromBuilder(transposedTableOptions);
        }

        @Override
        public final Builder transposedTableOptions(Collection<TransposedTableOption> transposedTableOptions) {
            this.transposedTableOptions = TransposedTableOptionListCopier.copy(transposedTableOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transposedTableOptions(TransposedTableOption ... transposedTableOptions) {
            this.transposedTableOptions(Arrays.asList(transposedTableOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transposedTableOptions(Consumer<TransposedTableOption.Builder> ... transposedTableOptions) {
            this.transposedTableOptions(Stream.of(transposedTableOptions).map(c -> (TransposedTableOption)((TransposedTableOption.Builder)TransposedTableOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TableFieldOptions build() {
            return new TableFieldOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableFieldOptions> {
        public Builder selectedFieldOptions(Collection<TableFieldOption> var1);

        public Builder selectedFieldOptions(TableFieldOption ... var1);

        public Builder selectedFieldOptions(Consumer<TableFieldOption.Builder> ... var1);

        public Builder order(Collection<String> var1);

        public Builder order(String ... var1);

        public Builder pinnedFieldOptions(TablePinnedFieldOptions var1);

        default public Builder pinnedFieldOptions(Consumer<TablePinnedFieldOptions.Builder> pinnedFieldOptions) {
            return this.pinnedFieldOptions((TablePinnedFieldOptions)((TablePinnedFieldOptions.Builder)TablePinnedFieldOptions.builder().applyMutation(pinnedFieldOptions)).build());
        }

        public Builder transposedTableOptions(Collection<TransposedTableOption> var1);

        public Builder transposedTableOptions(TransposedTableOption ... var1);

        public Builder transposedTableOptions(Consumer<TransposedTableOption.Builder> ... var1);
    }
}

