/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FilterSelectableValues;
import software.amazon.awssdk.services.quicksight.model.ListControlDisplayOptions;
import software.amazon.awssdk.services.quicksight.model.SheetControlListType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultFilterListControlOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultFilterListControlOptions> {
    private static final SdkField<ListControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayOptions").getter(DefaultFilterListControlOptions.getter(DefaultFilterListControlOptions::displayOptions)).setter(DefaultFilterListControlOptions.setter(Builder::displayOptions)).constructor(ListControlDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DefaultFilterListControlOptions.getter(DefaultFilterListControlOptions::typeAsString)).setter(DefaultFilterListControlOptions.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<FilterSelectableValues> SELECTABLE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectableValues").getter(DefaultFilterListControlOptions.getter(DefaultFilterListControlOptions::selectableValues)).setter(DefaultFilterListControlOptions.setter(Builder::selectableValues)).constructor(FilterSelectableValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectableValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_OPTIONS_FIELD, TYPE_FIELD, SELECTABLE_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DefaultFilterListControlOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ListControlDisplayOptions displayOptions;
    private final String type;
    private final FilterSelectableValues selectableValues;

    private DefaultFilterListControlOptions(BuilderImpl builder) {
        this.displayOptions = builder.displayOptions;
        this.type = builder.type;
        this.selectableValues = builder.selectableValues;
    }

    public final ListControlDisplayOptions displayOptions() {
        return this.displayOptions;
    }

    public final SheetControlListType type() {
        return SheetControlListType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final FilterSelectableValues selectableValues() {
        return this.selectableValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectableValues());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFilterListControlOptions)) {
            return false;
        }
        DefaultFilterListControlOptions other = (DefaultFilterListControlOptions)obj;
        return Objects.equals(this.displayOptions(), other.displayOptions()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.selectableValues(), other.selectableValues());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultFilterListControlOptions").add("DisplayOptions", (Object)this.displayOptions()).add("Type", (Object)this.typeAsString()).add("SelectableValues", (Object)this.selectableValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.displayOptions()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SelectableValues": {
                return Optional.ofNullable(clazz.cast(this.selectableValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SelectableValues", SELECTABLE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultFilterListControlOptions, T> g) {
        return obj -> g.apply((DefaultFilterListControlOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ListControlDisplayOptions displayOptions;
        private String type;
        private FilterSelectableValues selectableValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultFilterListControlOptions model) {
            this.displayOptions(model.displayOptions);
            this.type(model.type);
            this.selectableValues(model.selectableValues);
        }

        public final ListControlDisplayOptions.Builder getDisplayOptions() {
            return this.displayOptions != null ? this.displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(ListControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(ListControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SheetControlListType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final FilterSelectableValues.Builder getSelectableValues() {
            return this.selectableValues != null ? this.selectableValues.toBuilder() : null;
        }

        public final void setSelectableValues(FilterSelectableValues.BuilderImpl selectableValues) {
            this.selectableValues = selectableValues != null ? selectableValues.build() : null;
        }

        @Override
        public final Builder selectableValues(FilterSelectableValues selectableValues) {
            this.selectableValues = selectableValues;
            return this;
        }

        public DefaultFilterListControlOptions build() {
            return new DefaultFilterListControlOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultFilterListControlOptions> {
        public Builder displayOptions(ListControlDisplayOptions var1);

        default public Builder displayOptions(Consumer<ListControlDisplayOptions.Builder> displayOptions) {
            return this.displayOptions((ListControlDisplayOptions)((ListControlDisplayOptions.Builder)ListControlDisplayOptions.builder().applyMutation(displayOptions)).build());
        }

        public Builder type(String var1);

        public Builder type(SheetControlListType var1);

        public Builder selectableValues(FilterSelectableValues var1);

        default public Builder selectableValues(Consumer<FilterSelectableValues.Builder> selectableValues) {
            return this.selectableValues((FilterSelectableValues)((FilterSelectableValues.Builder)FilterSelectableValues.builder().applyMutation(selectableValues)).build());
        }
    }
}

