/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.SpecialValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomColor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomColor> {
    private static final SdkField<String> FIELD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldValue").getter(CustomColor.getter(CustomColor::fieldValue)).setter(CustomColor.setter(Builder::fieldValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldValue").build()}).build();
    private static final SdkField<String> COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Color").getter(CustomColor.getter(CustomColor::color)).setter(CustomColor.setter(Builder::color)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()}).build();
    private static final SdkField<String> SPECIAL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpecialValue").getter(CustomColor.getter(CustomColor::specialValueAsString)).setter(CustomColor.setter(Builder::specialValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpecialValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_VALUE_FIELD, COLOR_FIELD, SPECIAL_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomColor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldValue;
    private final String color;
    private final String specialValue;

    private CustomColor(BuilderImpl builder) {
        this.fieldValue = builder.fieldValue;
        this.color = builder.color;
        this.specialValue = builder.specialValue;
    }

    public final String fieldValue() {
        return this.fieldValue;
    }

    public final String color() {
        return this.color;
    }

    public final SpecialValue specialValue() {
        return SpecialValue.fromValue(this.specialValue);
    }

    public final String specialValueAsString() {
        return this.specialValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.color());
        hashCode = 31 * hashCode + Objects.hashCode(this.specialValueAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomColor)) {
            return false;
        }
        CustomColor other = (CustomColor)obj;
        return Objects.equals(this.fieldValue(), other.fieldValue()) && Objects.equals(this.color(), other.color()) && Objects.equals(this.specialValueAsString(), other.specialValueAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomColor").add("FieldValue", (Object)(this.fieldValue() == null ? null : "*** Sensitive Data Redacted ***")).add("Color", (Object)this.color()).add("SpecialValue", (Object)this.specialValueAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldValue": {
                return Optional.ofNullable(clazz.cast(this.fieldValue()));
            }
            case "Color": {
                return Optional.ofNullable(clazz.cast(this.color()));
            }
            case "SpecialValue": {
                return Optional.ofNullable(clazz.cast(this.specialValueAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FieldValue", FIELD_VALUE_FIELD);
        map.put("Color", COLOR_FIELD);
        map.put("SpecialValue", SPECIAL_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomColor, T> g) {
        return obj -> g.apply((CustomColor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldValue;
        private String color;
        private String specialValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomColor model) {
            this.fieldValue(model.fieldValue);
            this.color(model.color);
            this.specialValue(model.specialValue);
        }

        public final String getFieldValue() {
            return this.fieldValue;
        }

        public final void setFieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        @Override
        public final Builder fieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
            return this;
        }

        public final String getColor() {
            return this.color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final String getSpecialValue() {
            return this.specialValue;
        }

        public final void setSpecialValue(String specialValue) {
            this.specialValue = specialValue;
        }

        @Override
        public final Builder specialValue(String specialValue) {
            this.specialValue = specialValue;
            return this;
        }

        @Override
        public final Builder specialValue(SpecialValue specialValue) {
            this.specialValue(specialValue == null ? null : specialValue.toString());
            return this;
        }

        public CustomColor build() {
            return new CustomColor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomColor> {
        public Builder fieldValue(String var1);

        public Builder color(String var1);

        public Builder specialValue(String var1);

        public Builder specialValue(SpecialValue var1);
    }
}

