/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.PivotTableFieldSubtotalOptions;
import software.amazon.awssdk.services.quicksight.model.PivotTableFieldSubtotalOptionsListCopier;
import software.amazon.awssdk.services.quicksight.model.PivotTableSubtotalLevel;
import software.amazon.awssdk.services.quicksight.model.TableCellStyle;
import software.amazon.awssdk.services.quicksight.model.TableStyleTarget;
import software.amazon.awssdk.services.quicksight.model.TableStyleTargetListCopier;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubtotalOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubtotalOptions> {
    private static final SdkField<String> TOTALS_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalsVisibility").getter(SubtotalOptions.getter(SubtotalOptions::totalsVisibilityAsString)).setter(SubtotalOptions.setter(Builder::totalsVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalsVisibility").build()}).build();
    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomLabel").getter(SubtotalOptions.getter(SubtotalOptions::customLabel)).setter(SubtotalOptions.setter(Builder::customLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()}).build();
    private static final SdkField<String> FIELD_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldLevel").getter(SubtotalOptions.getter(SubtotalOptions::fieldLevelAsString)).setter(SubtotalOptions.setter(Builder::fieldLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevel").build()}).build();
    private static final SdkField<List<PivotTableFieldSubtotalOptions>> FIELD_LEVEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldLevelOptions").getter(SubtotalOptions.getter(SubtotalOptions::fieldLevelOptions)).setter(SubtotalOptions.setter(Builder::fieldLevelOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PivotTableFieldSubtotalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TableCellStyle> TOTAL_CELL_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TotalCellStyle").getter(SubtotalOptions.getter(SubtotalOptions::totalCellStyle)).setter(SubtotalOptions.setter(Builder::totalCellStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCellStyle").build()}).build();
    private static final SdkField<TableCellStyle> VALUE_CELL_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueCellStyle").getter(SubtotalOptions.getter(SubtotalOptions::valueCellStyle)).setter(SubtotalOptions.setter(Builder::valueCellStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueCellStyle").build()}).build();
    private static final SdkField<TableCellStyle> METRIC_HEADER_CELL_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricHeaderCellStyle").getter(SubtotalOptions.getter(SubtotalOptions::metricHeaderCellStyle)).setter(SubtotalOptions.setter(Builder::metricHeaderCellStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricHeaderCellStyle").build()}).build();
    private static final SdkField<List<TableStyleTarget>> STYLE_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StyleTargets").getter(SubtotalOptions.getter(SubtotalOptions::styleTargets)).setter(SubtotalOptions.setter(Builder::styleTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StyleTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableStyleTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTALS_VISIBILITY_FIELD, CUSTOM_LABEL_FIELD, FIELD_LEVEL_FIELD, FIELD_LEVEL_OPTIONS_FIELD, TOTAL_CELL_STYLE_FIELD, VALUE_CELL_STYLE_FIELD, METRIC_HEADER_CELL_STYLE_FIELD, STYLE_TARGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubtotalOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String totalsVisibility;
    private final String customLabel;
    private final String fieldLevel;
    private final List<PivotTableFieldSubtotalOptions> fieldLevelOptions;
    private final TableCellStyle totalCellStyle;
    private final TableCellStyle valueCellStyle;
    private final TableCellStyle metricHeaderCellStyle;
    private final List<TableStyleTarget> styleTargets;

    private SubtotalOptions(BuilderImpl builder) {
        this.totalsVisibility = builder.totalsVisibility;
        this.customLabel = builder.customLabel;
        this.fieldLevel = builder.fieldLevel;
        this.fieldLevelOptions = builder.fieldLevelOptions;
        this.totalCellStyle = builder.totalCellStyle;
        this.valueCellStyle = builder.valueCellStyle;
        this.metricHeaderCellStyle = builder.metricHeaderCellStyle;
        this.styleTargets = builder.styleTargets;
    }

    public final Visibility totalsVisibility() {
        return Visibility.fromValue(this.totalsVisibility);
    }

    public final String totalsVisibilityAsString() {
        return this.totalsVisibility;
    }

    public final String customLabel() {
        return this.customLabel;
    }

    public final PivotTableSubtotalLevel fieldLevel() {
        return PivotTableSubtotalLevel.fromValue(this.fieldLevel);
    }

    public final String fieldLevelAsString() {
        return this.fieldLevel;
    }

    public final boolean hasFieldLevelOptions() {
        return this.fieldLevelOptions != null && !(this.fieldLevelOptions instanceof SdkAutoConstructList);
    }

    public final List<PivotTableFieldSubtotalOptions> fieldLevelOptions() {
        return this.fieldLevelOptions;
    }

    public final TableCellStyle totalCellStyle() {
        return this.totalCellStyle;
    }

    public final TableCellStyle valueCellStyle() {
        return this.valueCellStyle;
    }

    public final TableCellStyle metricHeaderCellStyle() {
        return this.metricHeaderCellStyle;
    }

    public final boolean hasStyleTargets() {
        return this.styleTargets != null && !(this.styleTargets instanceof SdkAutoConstructList);
    }

    public final List<TableStyleTarget> styleTargets() {
        return this.styleTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalsVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldLevelOptions() ? this.fieldLevelOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricHeaderCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStyleTargets() ? this.styleTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubtotalOptions)) {
            return false;
        }
        SubtotalOptions other = (SubtotalOptions)obj;
        return Objects.equals(this.totalsVisibilityAsString(), other.totalsVisibilityAsString()) && Objects.equals(this.customLabel(), other.customLabel()) && Objects.equals(this.fieldLevelAsString(), other.fieldLevelAsString()) && this.hasFieldLevelOptions() == other.hasFieldLevelOptions() && Objects.equals(this.fieldLevelOptions(), other.fieldLevelOptions()) && Objects.equals(this.totalCellStyle(), other.totalCellStyle()) && Objects.equals(this.valueCellStyle(), other.valueCellStyle()) && Objects.equals(this.metricHeaderCellStyle(), other.metricHeaderCellStyle()) && this.hasStyleTargets() == other.hasStyleTargets() && Objects.equals(this.styleTargets(), other.styleTargets());
    }

    public final String toString() {
        return ToString.builder((String)"SubtotalOptions").add("TotalsVisibility", (Object)this.totalsVisibilityAsString()).add("CustomLabel", (Object)this.customLabel()).add("FieldLevel", (Object)this.fieldLevelAsString()).add("FieldLevelOptions", this.hasFieldLevelOptions() ? this.fieldLevelOptions() : null).add("TotalCellStyle", (Object)this.totalCellStyle()).add("ValueCellStyle", (Object)this.valueCellStyle()).add("MetricHeaderCellStyle", (Object)this.metricHeaderCellStyle()).add("StyleTargets", this.hasStyleTargets() ? this.styleTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalsVisibility": {
                return Optional.ofNullable(clazz.cast(this.totalsVisibilityAsString()));
            }
            case "CustomLabel": {
                return Optional.ofNullable(clazz.cast(this.customLabel()));
            }
            case "FieldLevel": {
                return Optional.ofNullable(clazz.cast(this.fieldLevelAsString()));
            }
            case "FieldLevelOptions": {
                return Optional.ofNullable(clazz.cast(this.fieldLevelOptions()));
            }
            case "TotalCellStyle": {
                return Optional.ofNullable(clazz.cast(this.totalCellStyle()));
            }
            case "ValueCellStyle": {
                return Optional.ofNullable(clazz.cast(this.valueCellStyle()));
            }
            case "MetricHeaderCellStyle": {
                return Optional.ofNullable(clazz.cast(this.metricHeaderCellStyle()));
            }
            case "StyleTargets": {
                return Optional.ofNullable(clazz.cast(this.styleTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TotalsVisibility", TOTALS_VISIBILITY_FIELD);
        map.put("CustomLabel", CUSTOM_LABEL_FIELD);
        map.put("FieldLevel", FIELD_LEVEL_FIELD);
        map.put("FieldLevelOptions", FIELD_LEVEL_OPTIONS_FIELD);
        map.put("TotalCellStyle", TOTAL_CELL_STYLE_FIELD);
        map.put("ValueCellStyle", VALUE_CELL_STYLE_FIELD);
        map.put("MetricHeaderCellStyle", METRIC_HEADER_CELL_STYLE_FIELD);
        map.put("StyleTargets", STYLE_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubtotalOptions, T> g) {
        return obj -> g.apply((SubtotalOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String totalsVisibility;
        private String customLabel;
        private String fieldLevel;
        private List<PivotTableFieldSubtotalOptions> fieldLevelOptions = DefaultSdkAutoConstructList.getInstance();
        private TableCellStyle totalCellStyle;
        private TableCellStyle valueCellStyle;
        private TableCellStyle metricHeaderCellStyle;
        private List<TableStyleTarget> styleTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubtotalOptions model) {
            this.totalsVisibility(model.totalsVisibility);
            this.customLabel(model.customLabel);
            this.fieldLevel(model.fieldLevel);
            this.fieldLevelOptions(model.fieldLevelOptions);
            this.totalCellStyle(model.totalCellStyle);
            this.valueCellStyle(model.valueCellStyle);
            this.metricHeaderCellStyle(model.metricHeaderCellStyle);
            this.styleTargets(model.styleTargets);
        }

        public final String getTotalsVisibility() {
            return this.totalsVisibility;
        }

        public final void setTotalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
        }

        @Override
        public final Builder totalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
            return this;
        }

        @Override
        public final Builder totalsVisibility(Visibility totalsVisibility) {
            this.totalsVisibility(totalsVisibility == null ? null : totalsVisibility.toString());
            return this;
        }

        public final String getCustomLabel() {
            return this.customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public final String getFieldLevel() {
            return this.fieldLevel;
        }

        public final void setFieldLevel(String fieldLevel) {
            this.fieldLevel = fieldLevel;
        }

        @Override
        public final Builder fieldLevel(String fieldLevel) {
            this.fieldLevel = fieldLevel;
            return this;
        }

        @Override
        public final Builder fieldLevel(PivotTableSubtotalLevel fieldLevel) {
            this.fieldLevel(fieldLevel == null ? null : fieldLevel.toString());
            return this;
        }

        public final List<PivotTableFieldSubtotalOptions.Builder> getFieldLevelOptions() {
            List<PivotTableFieldSubtotalOptions.Builder> result = PivotTableFieldSubtotalOptionsListCopier.copyToBuilder(this.fieldLevelOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldLevelOptions(Collection<PivotTableFieldSubtotalOptions.BuilderImpl> fieldLevelOptions) {
            this.fieldLevelOptions = PivotTableFieldSubtotalOptionsListCopier.copyFromBuilder(fieldLevelOptions);
        }

        @Override
        public final Builder fieldLevelOptions(Collection<PivotTableFieldSubtotalOptions> fieldLevelOptions) {
            this.fieldLevelOptions = PivotTableFieldSubtotalOptionsListCopier.copy(fieldLevelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldLevelOptions(PivotTableFieldSubtotalOptions ... fieldLevelOptions) {
            this.fieldLevelOptions(Arrays.asList(fieldLevelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldLevelOptions(Consumer<PivotTableFieldSubtotalOptions.Builder> ... fieldLevelOptions) {
            this.fieldLevelOptions(Stream.of(fieldLevelOptions).map(c -> (PivotTableFieldSubtotalOptions)((PivotTableFieldSubtotalOptions.Builder)PivotTableFieldSubtotalOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TableCellStyle.Builder getTotalCellStyle() {
            return this.totalCellStyle != null ? this.totalCellStyle.toBuilder() : null;
        }

        public final void setTotalCellStyle(TableCellStyle.BuilderImpl totalCellStyle) {
            this.totalCellStyle = totalCellStyle != null ? totalCellStyle.build() : null;
        }

        @Override
        public final Builder totalCellStyle(TableCellStyle totalCellStyle) {
            this.totalCellStyle = totalCellStyle;
            return this;
        }

        public final TableCellStyle.Builder getValueCellStyle() {
            return this.valueCellStyle != null ? this.valueCellStyle.toBuilder() : null;
        }

        public final void setValueCellStyle(TableCellStyle.BuilderImpl valueCellStyle) {
            this.valueCellStyle = valueCellStyle != null ? valueCellStyle.build() : null;
        }

        @Override
        public final Builder valueCellStyle(TableCellStyle valueCellStyle) {
            this.valueCellStyle = valueCellStyle;
            return this;
        }

        public final TableCellStyle.Builder getMetricHeaderCellStyle() {
            return this.metricHeaderCellStyle != null ? this.metricHeaderCellStyle.toBuilder() : null;
        }

        public final void setMetricHeaderCellStyle(TableCellStyle.BuilderImpl metricHeaderCellStyle) {
            this.metricHeaderCellStyle = metricHeaderCellStyle != null ? metricHeaderCellStyle.build() : null;
        }

        @Override
        public final Builder metricHeaderCellStyle(TableCellStyle metricHeaderCellStyle) {
            this.metricHeaderCellStyle = metricHeaderCellStyle;
            return this;
        }

        public final List<TableStyleTarget.Builder> getStyleTargets() {
            List<TableStyleTarget.Builder> result = TableStyleTargetListCopier.copyToBuilder(this.styleTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStyleTargets(Collection<TableStyleTarget.BuilderImpl> styleTargets) {
            this.styleTargets = TableStyleTargetListCopier.copyFromBuilder(styleTargets);
        }

        @Override
        public final Builder styleTargets(Collection<TableStyleTarget> styleTargets) {
            this.styleTargets = TableStyleTargetListCopier.copy(styleTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder styleTargets(TableStyleTarget ... styleTargets) {
            this.styleTargets(Arrays.asList(styleTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder styleTargets(Consumer<TableStyleTarget.Builder> ... styleTargets) {
            this.styleTargets(Stream.of(styleTargets).map(c -> (TableStyleTarget)((TableStyleTarget.Builder)TableStyleTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SubtotalOptions build() {
            return new SubtotalOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubtotalOptions> {
        public Builder totalsVisibility(String var1);

        public Builder totalsVisibility(Visibility var1);

        public Builder customLabel(String var1);

        public Builder fieldLevel(String var1);

        public Builder fieldLevel(PivotTableSubtotalLevel var1);

        public Builder fieldLevelOptions(Collection<PivotTableFieldSubtotalOptions> var1);

        public Builder fieldLevelOptions(PivotTableFieldSubtotalOptions ... var1);

        public Builder fieldLevelOptions(Consumer<PivotTableFieldSubtotalOptions.Builder> ... var1);

        public Builder totalCellStyle(TableCellStyle var1);

        default public Builder totalCellStyle(Consumer<TableCellStyle.Builder> totalCellStyle) {
            return this.totalCellStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(totalCellStyle)).build());
        }

        public Builder valueCellStyle(TableCellStyle var1);

        default public Builder valueCellStyle(Consumer<TableCellStyle.Builder> valueCellStyle) {
            return this.valueCellStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(valueCellStyle)).build());
        }

        public Builder metricHeaderCellStyle(TableCellStyle var1);

        default public Builder metricHeaderCellStyle(Consumer<TableCellStyle.Builder> metricHeaderCellStyle) {
            return this.metricHeaderCellStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(metricHeaderCellStyle)).build());
        }

        public Builder styleTargets(Collection<TableStyleTarget> var1);

        public Builder styleTargets(TableStyleTarget ... var1);

        public Builder styleTargets(Consumer<TableStyleTarget.Builder> ... var1);
    }
}

