/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTemplateResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateTemplateResponse.Builder, UpdateTemplateResponse> {
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(UpdateTemplateResponse::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateTemplateResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionArn").getter(getter(UpdateTemplateResponse::versionArn)).setter(setter(Builder::versionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionArn").build()).build();

    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationStatus").getter(getter(UpdateTemplateResponse::creationStatusAsString))
            .setter(setter(Builder::creationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(UpdateTemplateResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(UpdateTemplateResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ID_FIELD, ARN_FIELD,
            VERSION_ARN_FIELD, CREATION_STATUS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String templateId;

    private final String arn;

    private final String versionArn;

    private final String creationStatus;

    private final Integer status;

    private final String requestId;

    private UpdateTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateId = builder.templateId;
        this.arn = builder.arn;
        this.versionArn = builder.versionArn;
        this.creationStatus = builder.creationStatus;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The ID for the template.
     * </p>
     * 
     * @return The ID for the template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN for the template, including the version information of the first version.
     * </p>
     * 
     * @return The ARN for the template, including the version information of the first version.
     */
    public final String versionArn() {
        return versionArn;
    }

    /**
     * <p>
     * The creation status of the template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The creation status of the template.
     * @see ResourceStatus
     */
    public final ResourceStatus creationStatus() {
        return ResourceStatus.fromValue(creationStatus);
    }

    /**
     * <p>
     * The creation status of the template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The creation status of the template.
     * @see ResourceStatus
     */
    public final String creationStatusAsString() {
        return creationStatus;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(versionArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateResponse)) {
            return false;
        }
        UpdateTemplateResponse other = (UpdateTemplateResponse) obj;
        return Objects.equals(templateId(), other.templateId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(versionArn(), other.versionArn())
                && Objects.equals(creationStatusAsString(), other.creationStatusAsString())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTemplateResponse").add("TemplateId", templateId()).add("Arn", arn())
                .add("VersionArn", versionArn()).add("CreationStatus", creationStatusAsString()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "VersionArn":
            return Optional.ofNullable(clazz.cast(versionArn()));
        case "CreationStatus":
            return Optional.ofNullable(clazz.cast(creationStatusAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateId", TEMPLATE_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("VersionArn", VERSION_ARN_FIELD);
        map.put("CreationStatus", CREATION_STATUS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateResponse, T> g) {
        return obj -> g.apply((UpdateTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTemplateResponse> {
        /**
         * <p>
         * The ID for the template.
         * </p>
         * 
         * @param templateId
         *        The ID for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the template.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN for the template, including the version information of the first version.
         * </p>
         * 
         * @param versionArn
         *        The ARN for the template, including the version information of the first version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionArn(String versionArn);

        /**
         * <p>
         * The creation status of the template.
         * </p>
         * 
         * @param creationStatus
         *        The creation status of the template.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder creationStatus(String creationStatus);

        /**
         * <p>
         * The creation status of the template.
         * </p>
         * 
         * @param creationStatus
         *        The creation status of the template.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder creationStatus(ResourceStatus creationStatus);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String templateId;

        private String arn;

        private String versionArn;

        private String creationStatus;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateResponse model) {
            super(model);
            templateId(model.templateId);
            arn(model.arn);
            versionArn(model.versionArn);
            creationStatus(model.creationStatus);
            status(model.status);
            requestId(model.requestId);
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVersionArn() {
            return versionArn;
        }

        public final void setVersionArn(String versionArn) {
            this.versionArn = versionArn;
        }

        @Override
        public final Builder versionArn(String versionArn) {
            this.versionArn = versionArn;
            return this;
        }

        public final String getCreationStatus() {
            return creationStatus;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(ResourceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public UpdateTemplateResponse build() {
            return new UpdateTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
