/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a topic refresh schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRefreshSchedule implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRefreshSchedule.Builder, TopicRefreshSchedule> {
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEnabled").getter(getter(TopicRefreshSchedule::isEnabled)).setter(setter(Builder::isEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEnabled").build()).build();

    private static final SdkField<Boolean> BASED_ON_SPICE_SCHEDULE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BasedOnSpiceSchedule").getter(getter(TopicRefreshSchedule::basedOnSpiceSchedule))
            .setter(setter(Builder::basedOnSpiceSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasedOnSpiceSchedule").build())
            .build();

    private static final SdkField<Instant> STARTING_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartingAt").getter(getter(TopicRefreshSchedule::startingAt)).setter(setter(Builder::startingAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingAt").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(TopicRefreshSchedule::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<String> REPEAT_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepeatAt").getter(getter(TopicRefreshSchedule::repeatAt)).setter(setter(Builder::repeatAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepeatAt").build()).build();

    private static final SdkField<String> TOPIC_SCHEDULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicScheduleType").getter(getter(TopicRefreshSchedule::topicScheduleTypeAsString))
            .setter(setter(Builder::topicScheduleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicScheduleType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_ENABLED_FIELD,
            BASED_ON_SPICE_SCHEDULE_FIELD, STARTING_AT_FIELD, TIMEZONE_FIELD, REPEAT_AT_FIELD, TOPIC_SCHEDULE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isEnabled;

    private final Boolean basedOnSpiceSchedule;

    private final Instant startingAt;

    private final String timezone;

    private final String repeatAt;

    private final String topicScheduleType;

    private TopicRefreshSchedule(BuilderImpl builder) {
        this.isEnabled = builder.isEnabled;
        this.basedOnSpiceSchedule = builder.basedOnSpiceSchedule;
        this.startingAt = builder.startingAt;
        this.timezone = builder.timezone;
        this.repeatAt = builder.repeatAt;
        this.topicScheduleType = builder.topicScheduleType;
    }

    /**
     * <p>
     * A Boolean value that controls whether to schedule is enabled.
     * </p>
     * 
     * @return A Boolean value that controls whether to schedule is enabled.
     */
    public final Boolean isEnabled() {
        return isEnabled;
    }

    /**
     * <p>
     * A Boolean value that controls whether to schedule runs at the same schedule that is specified in SPICE dataset.
     * </p>
     * 
     * @return A Boolean value that controls whether to schedule runs at the same schedule that is specified in SPICE
     *         dataset.
     */
    public final Boolean basedOnSpiceSchedule() {
        return basedOnSpiceSchedule;
    }

    /**
     * <p>
     * The starting date and time for the refresh schedule.
     * </p>
     * 
     * @return The starting date and time for the refresh schedule.
     */
    public final Instant startingAt() {
        return startingAt;
    }

    /**
     * <p>
     * The timezone that you want the refresh schedule to use.
     * </p>
     * 
     * @return The timezone that you want the refresh schedule to use.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * The time of day when the refresh should run, for example, Monday-Sunday.
     * </p>
     * 
     * @return The time of day when the refresh should run, for example, Monday-Sunday.
     */
    public final String repeatAt() {
        return repeatAt;
    }

    /**
     * <p>
     * The type of refresh schedule. Valid values for this structure are <code>HOURLY</code>, <code>DAILY</code>,
     * <code>WEEKLY</code>, and <code>MONTHLY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #topicScheduleType}
     * will return {@link TopicScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #topicScheduleTypeAsString}.
     * </p>
     * 
     * @return The type of refresh schedule. Valid values for this structure are <code>HOURLY</code>, <code>DAILY</code>
     *         , <code>WEEKLY</code>, and <code>MONTHLY</code>.
     * @see TopicScheduleType
     */
    public final TopicScheduleType topicScheduleType() {
        return TopicScheduleType.fromValue(topicScheduleType);
    }

    /**
     * <p>
     * The type of refresh schedule. Valid values for this structure are <code>HOURLY</code>, <code>DAILY</code>,
     * <code>WEEKLY</code>, and <code>MONTHLY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #topicScheduleType}
     * will return {@link TopicScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #topicScheduleTypeAsString}.
     * </p>
     * 
     * @return The type of refresh schedule. Valid values for this structure are <code>HOURLY</code>, <code>DAILY</code>
     *         , <code>WEEKLY</code>, and <code>MONTHLY</code>.
     * @see TopicScheduleType
     */
    public final String topicScheduleTypeAsString() {
        return topicScheduleType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(basedOnSpiceSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(startingAt());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(repeatAt());
        hashCode = 31 * hashCode + Objects.hashCode(topicScheduleTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRefreshSchedule)) {
            return false;
        }
        TopicRefreshSchedule other = (TopicRefreshSchedule) obj;
        return Objects.equals(isEnabled(), other.isEnabled())
                && Objects.equals(basedOnSpiceSchedule(), other.basedOnSpiceSchedule())
                && Objects.equals(startingAt(), other.startingAt()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(repeatAt(), other.repeatAt())
                && Objects.equals(topicScheduleTypeAsString(), other.topicScheduleTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicRefreshSchedule").add("IsEnabled", isEnabled())
                .add("BasedOnSpiceSchedule", basedOnSpiceSchedule()).add("StartingAt", startingAt()).add("Timezone", timezone())
                .add("RepeatAt", repeatAt()).add("TopicScheduleType", topicScheduleTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsEnabled":
            return Optional.ofNullable(clazz.cast(isEnabled()));
        case "BasedOnSpiceSchedule":
            return Optional.ofNullable(clazz.cast(basedOnSpiceSchedule()));
        case "StartingAt":
            return Optional.ofNullable(clazz.cast(startingAt()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "RepeatAt":
            return Optional.ofNullable(clazz.cast(repeatAt()));
        case "TopicScheduleType":
            return Optional.ofNullable(clazz.cast(topicScheduleTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IsEnabled", IS_ENABLED_FIELD);
        map.put("BasedOnSpiceSchedule", BASED_ON_SPICE_SCHEDULE_FIELD);
        map.put("StartingAt", STARTING_AT_FIELD);
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("RepeatAt", REPEAT_AT_FIELD);
        map.put("TopicScheduleType", TOPIC_SCHEDULE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicRefreshSchedule, T> g) {
        return obj -> g.apply((TopicRefreshSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRefreshSchedule> {
        /**
         * <p>
         * A Boolean value that controls whether to schedule is enabled.
         * </p>
         * 
         * @param isEnabled
         *        A Boolean value that controls whether to schedule is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEnabled(Boolean isEnabled);

        /**
         * <p>
         * A Boolean value that controls whether to schedule runs at the same schedule that is specified in SPICE
         * dataset.
         * </p>
         * 
         * @param basedOnSpiceSchedule
         *        A Boolean value that controls whether to schedule runs at the same schedule that is specified in SPICE
         *        dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basedOnSpiceSchedule(Boolean basedOnSpiceSchedule);

        /**
         * <p>
         * The starting date and time for the refresh schedule.
         * </p>
         * 
         * @param startingAt
         *        The starting date and time for the refresh schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingAt(Instant startingAt);

        /**
         * <p>
         * The timezone that you want the refresh schedule to use.
         * </p>
         * 
         * @param timezone
         *        The timezone that you want the refresh schedule to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The time of day when the refresh should run, for example, Monday-Sunday.
         * </p>
         * 
         * @param repeatAt
         *        The time of day when the refresh should run, for example, Monday-Sunday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repeatAt(String repeatAt);

        /**
         * <p>
         * The type of refresh schedule. Valid values for this structure are <code>HOURLY</code>, <code>DAILY</code>,
         * <code>WEEKLY</code>, and <code>MONTHLY</code>.
         * </p>
         * 
         * @param topicScheduleType
         *        The type of refresh schedule. Valid values for this structure are <code>HOURLY</code>,
         *        <code>DAILY</code>, <code>WEEKLY</code>, and <code>MONTHLY</code>.
         * @see TopicScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicScheduleType
         */
        Builder topicScheduleType(String topicScheduleType);

        /**
         * <p>
         * The type of refresh schedule. Valid values for this structure are <code>HOURLY</code>, <code>DAILY</code>,
         * <code>WEEKLY</code>, and <code>MONTHLY</code>.
         * </p>
         * 
         * @param topicScheduleType
         *        The type of refresh schedule. Valid values for this structure are <code>HOURLY</code>,
         *        <code>DAILY</code>, <code>WEEKLY</code>, and <code>MONTHLY</code>.
         * @see TopicScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicScheduleType
         */
        Builder topicScheduleType(TopicScheduleType topicScheduleType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isEnabled;

        private Boolean basedOnSpiceSchedule;

        private Instant startingAt;

        private String timezone;

        private String repeatAt;

        private String topicScheduleType;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRefreshSchedule model) {
            isEnabled(model.isEnabled);
            basedOnSpiceSchedule(model.basedOnSpiceSchedule);
            startingAt(model.startingAt);
            timezone(model.timezone);
            repeatAt(model.repeatAt);
            topicScheduleType(model.topicScheduleType);
        }

        public final Boolean getIsEnabled() {
            return isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final Boolean getBasedOnSpiceSchedule() {
            return basedOnSpiceSchedule;
        }

        public final void setBasedOnSpiceSchedule(Boolean basedOnSpiceSchedule) {
            this.basedOnSpiceSchedule = basedOnSpiceSchedule;
        }

        @Override
        public final Builder basedOnSpiceSchedule(Boolean basedOnSpiceSchedule) {
            this.basedOnSpiceSchedule = basedOnSpiceSchedule;
            return this;
        }

        public final Instant getStartingAt() {
            return startingAt;
        }

        public final void setStartingAt(Instant startingAt) {
            this.startingAt = startingAt;
        }

        @Override
        public final Builder startingAt(Instant startingAt) {
            this.startingAt = startingAt;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getRepeatAt() {
            return repeatAt;
        }

        public final void setRepeatAt(String repeatAt) {
            this.repeatAt = repeatAt;
        }

        @Override
        public final Builder repeatAt(String repeatAt) {
            this.repeatAt = repeatAt;
            return this;
        }

        public final String getTopicScheduleType() {
            return topicScheduleType;
        }

        public final void setTopicScheduleType(String topicScheduleType) {
            this.topicScheduleType = topicScheduleType;
        }

        @Override
        public final Builder topicScheduleType(String topicScheduleType) {
            this.topicScheduleType = topicScheduleType;
            return this;
        }

        @Override
        public final Builder topicScheduleType(TopicScheduleType topicScheduleType) {
            this.topicScheduleType(topicScheduleType == null ? null : topicScheduleType.toString());
            return this;
        }

        @Override
        public TopicRefreshSchedule build() {
            return new TopicRefreshSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
