/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The top movers and bottom movers computation setup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopBottomMoversComputation implements SdkPojo, Serializable,
        ToCopyableBuilder<TopBottomMoversComputation.Builder, TopBottomMoversComputation> {
    private static final SdkField<String> COMPUTATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputationId").getter(getter(TopBottomMoversComputation::computationId))
            .setter(setter(Builder::computationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TopBottomMoversComputation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DimensionField> TIME_FIELD = SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
            .memberName("Time").getter(getter(TopBottomMoversComputation::time)).setter(setter(Builder::time))
            .constructor(DimensionField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final SdkField<DimensionField> CATEGORY_FIELD = SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
            .memberName("Category").getter(getter(TopBottomMoversComputation::category)).setter(setter(Builder::category))
            .constructor(DimensionField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<MeasureField> VALUE_FIELD = SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
            .memberName("Value").getter(getter(TopBottomMoversComputation::value)).setter(setter(Builder::value))
            .constructor(MeasureField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Integer> MOVER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MoverSize").getter(getter(TopBottomMoversComputation::moverSize)).setter(setter(Builder::moverSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoverSize").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(TopBottomMoversComputation::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TopBottomMoversComputation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_ID_FIELD,
            NAME_FIELD, TIME_FIELD, CATEGORY_FIELD, VALUE_FIELD, MOVER_SIZE_FIELD, SORT_ORDER_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String computationId;

    private final String name;

    private final DimensionField time;

    private final DimensionField category;

    private final MeasureField value;

    private final Integer moverSize;

    private final String sortOrder;

    private final String type;

    private TopBottomMoversComputation(BuilderImpl builder) {
        this.computationId = builder.computationId;
        this.name = builder.name;
        this.time = builder.time;
        this.category = builder.category;
        this.value = builder.value;
        this.moverSize = builder.moverSize;
        this.sortOrder = builder.sortOrder;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID for a computation.
     * </p>
     * 
     * @return The ID for a computation.
     */
    public final String computationId() {
        return computationId;
    }

    /**
     * <p>
     * The name of a computation.
     * </p>
     * 
     * @return The name of a computation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time field that is used in a computation.
     * </p>
     * 
     * @return The time field that is used in a computation.
     */
    public final DimensionField time() {
        return time;
    }

    /**
     * <p>
     * The category field that is used in a computation.
     * </p>
     * 
     * @return The category field that is used in a computation.
     */
    public final DimensionField category() {
        return category;
    }

    /**
     * <p>
     * The value field that is used in a computation.
     * </p>
     * 
     * @return The value field that is used in a computation.
     */
    public final MeasureField value() {
        return value;
    }

    /**
     * <p>
     * The mover size setup of the top and bottom movers computation.
     * </p>
     * 
     * @return The mover size setup of the top and bottom movers computation.
     */
    public final Integer moverSize() {
        return moverSize;
    }

    /**
     * <p>
     * The sort order setup of the top and bottom movers computation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link TopBottomSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order setup of the top and bottom movers computation.
     * @see TopBottomSortOrder
     */
    public final TopBottomSortOrder sortOrder() {
        return TopBottomSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order setup of the top and bottom movers computation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link TopBottomSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order setup of the top and bottom movers computation.
     * @see TopBottomSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The computation type. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * TOP: Top movers computation.
     * </p>
     * </li>
     * <li>
     * <p>
     * BOTTOM: Bottom movers computation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TopBottomComputationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The computation type. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TOP: Top movers computation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BOTTOM: Bottom movers computation.
     *         </p>
     *         </li>
     * @see TopBottomComputationType
     */
    public final TopBottomComputationType type() {
        return TopBottomComputationType.fromValue(type);
    }

    /**
     * <p>
     * The computation type. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * TOP: Top movers computation.
     * </p>
     * </li>
     * <li>
     * <p>
     * BOTTOM: Bottom movers computation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TopBottomComputationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The computation type. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TOP: Top movers computation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BOTTOM: Bottom movers computation.
     *         </p>
     *         </li>
     * @see TopBottomComputationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(moverSize());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopBottomMoversComputation)) {
            return false;
        }
        TopBottomMoversComputation other = (TopBottomMoversComputation) obj;
        return Objects.equals(computationId(), other.computationId()) && Objects.equals(name(), other.name())
                && Objects.equals(time(), other.time()) && Objects.equals(category(), other.category())
                && Objects.equals(value(), other.value()) && Objects.equals(moverSize(), other.moverSize())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopBottomMoversComputation").add("ComputationId", computationId()).add("Name", name())
                .add("Time", time()).add("Category", category()).add("Value", value()).add("MoverSize", moverSize())
                .add("SortOrder", sortOrderAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputationId":
            return Optional.ofNullable(clazz.cast(computationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "MoverSize":
            return Optional.ofNullable(clazz.cast(moverSize()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputationId", COMPUTATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Time", TIME_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("MoverSize", MOVER_SIZE_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopBottomMoversComputation, T> g) {
        return obj -> g.apply((TopBottomMoversComputation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopBottomMoversComputation> {
        /**
         * <p>
         * The ID for a computation.
         * </p>
         * 
         * @param computationId
         *        The ID for a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationId(String computationId);

        /**
         * <p>
         * The name of a computation.
         * </p>
         * 
         * @param name
         *        The name of a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time field that is used in a computation.
         * </p>
         * 
         * @param time
         *        The time field that is used in a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(DimensionField time);

        /**
         * <p>
         * The time field that is used in a computation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DimensionField.Builder} avoiding the need
         * to create one manually via {@link DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DimensionField.Builder#build()} is called immediately and its
         * result is passed to {@link #time(DimensionField)}.
         * 
         * @param time
         *        a consumer that will call methods on {@link DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #time(DimensionField)
         */
        default Builder time(Consumer<DimensionField.Builder> time) {
            return time(DimensionField.builder().applyMutation(time).build());
        }

        /**
         * <p>
         * The category field that is used in a computation.
         * </p>
         * 
         * @param category
         *        The category field that is used in a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(DimensionField category);

        /**
         * <p>
         * The category field that is used in a computation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DimensionField.Builder} avoiding the need
         * to create one manually via {@link DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DimensionField.Builder#build()} is called immediately and its
         * result is passed to {@link #category(DimensionField)}.
         * 
         * @param category
         *        a consumer that will call methods on {@link DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #category(DimensionField)
         */
        default Builder category(Consumer<DimensionField.Builder> category) {
            return category(DimensionField.builder().applyMutation(category).build());
        }

        /**
         * <p>
         * The value field that is used in a computation.
         * </p>
         * 
         * @param value
         *        The value field that is used in a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(MeasureField value);

        /**
         * <p>
         * The value field that is used in a computation.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeasureField.Builder} avoiding the need
         * to create one manually via {@link MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeasureField.Builder#build()} is called immediately and its
         * result is passed to {@link #value(MeasureField)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(MeasureField)
         */
        default Builder value(Consumer<MeasureField.Builder> value) {
            return value(MeasureField.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The mover size setup of the top and bottom movers computation.
         * </p>
         * 
         * @param moverSize
         *        The mover size setup of the top and bottom movers computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moverSize(Integer moverSize);

        /**
         * <p>
         * The sort order setup of the top and bottom movers computation.
         * </p>
         * 
         * @param sortOrder
         *        The sort order setup of the top and bottom movers computation.
         * @see TopBottomSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopBottomSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order setup of the top and bottom movers computation.
         * </p>
         * 
         * @param sortOrder
         *        The sort order setup of the top and bottom movers computation.
         * @see TopBottomSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopBottomSortOrder
         */
        Builder sortOrder(TopBottomSortOrder sortOrder);

        /**
         * <p>
         * The computation type. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TOP: Top movers computation.
         * </p>
         * </li>
         * <li>
         * <p>
         * BOTTOM: Bottom movers computation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The computation type. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TOP: Top movers computation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BOTTOM: Bottom movers computation.
         *        </p>
         *        </li>
         * @see TopBottomComputationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopBottomComputationType
         */
        Builder type(String type);

        /**
         * <p>
         * The computation type. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TOP: Top movers computation.
         * </p>
         * </li>
         * <li>
         * <p>
         * BOTTOM: Bottom movers computation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The computation type. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TOP: Top movers computation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BOTTOM: Bottom movers computation.
         *        </p>
         *        </li>
         * @see TopBottomComputationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopBottomComputationType
         */
        Builder type(TopBottomComputationType type);
    }

    static final class BuilderImpl implements Builder {
        private String computationId;

        private String name;

        private DimensionField time;

        private DimensionField category;

        private MeasureField value;

        private Integer moverSize;

        private String sortOrder;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TopBottomMoversComputation model) {
            computationId(model.computationId);
            name(model.name);
            time(model.time);
            category(model.category);
            value(model.value);
            moverSize(model.moverSize);
            sortOrder(model.sortOrder);
            type(model.type);
        }

        public final String getComputationId() {
            return computationId;
        }

        public final void setComputationId(String computationId) {
            this.computationId = computationId;
        }

        @Override
        public final Builder computationId(String computationId) {
            this.computationId = computationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DimensionField.Builder getTime() {
            return time != null ? time.toBuilder() : null;
        }

        public final void setTime(DimensionField.BuilderImpl time) {
            this.time = time != null ? time.build() : null;
        }

        @Override
        public final Builder time(DimensionField time) {
            this.time = time;
            return this;
        }

        public final DimensionField.Builder getCategory() {
            return category != null ? category.toBuilder() : null;
        }

        public final void setCategory(DimensionField.BuilderImpl category) {
            this.category = category != null ? category.build() : null;
        }

        @Override
        public final Builder category(DimensionField category) {
            this.category = category;
            return this;
        }

        public final MeasureField.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(MeasureField.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MeasureField value) {
            this.value = value;
            return this;
        }

        public final Integer getMoverSize() {
            return moverSize;
        }

        public final void setMoverSize(Integer moverSize) {
            this.moverSize = moverSize;
        }

        @Override
        public final Builder moverSize(Integer moverSize) {
            this.moverSize = moverSize;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(TopBottomSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TopBottomComputationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public TopBottomMoversComputation build() {
            return new TopBottomMoversComputation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
