/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field wells for a table visual.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableFieldWells implements SdkPojo, Serializable, ToCopyableBuilder<TableFieldWells.Builder, TableFieldWells> {
    private static final SdkField<TableAggregatedFieldWells> TABLE_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<TableAggregatedFieldWells> builder(MarshallingType.SDK_POJO).memberName("TableAggregatedFieldWells")
            .getter(getter(TableFieldWells::tableAggregatedFieldWells)).setter(setter(Builder::tableAggregatedFieldWells))
            .constructor(TableAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableAggregatedFieldWells").build())
            .build();

    private static final SdkField<TableUnaggregatedFieldWells> TABLE_UNAGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<TableUnaggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("TableUnaggregatedFieldWells")
            .getter(getter(TableFieldWells::tableUnaggregatedFieldWells))
            .setter(setter(Builder::tableUnaggregatedFieldWells))
            .constructor(TableUnaggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableUnaggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TABLE_AGGREGATED_FIELD_WELLS_FIELD, TABLE_UNAGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TableAggregatedFieldWells tableAggregatedFieldWells;

    private final TableUnaggregatedFieldWells tableUnaggregatedFieldWells;

    private TableFieldWells(BuilderImpl builder) {
        this.tableAggregatedFieldWells = builder.tableAggregatedFieldWells;
        this.tableUnaggregatedFieldWells = builder.tableUnaggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field well for the table.
     * </p>
     * 
     * @return The aggregated field well for the table.
     */
    public final TableAggregatedFieldWells tableAggregatedFieldWells() {
        return tableAggregatedFieldWells;
    }

    /**
     * <p>
     * The unaggregated field well for the table.
     * </p>
     * 
     * @return The unaggregated field well for the table.
     */
    public final TableUnaggregatedFieldWells tableUnaggregatedFieldWells() {
        return tableUnaggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableAggregatedFieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(tableUnaggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldWells)) {
            return false;
        }
        TableFieldWells other = (TableFieldWells) obj;
        return Objects.equals(tableAggregatedFieldWells(), other.tableAggregatedFieldWells())
                && Objects.equals(tableUnaggregatedFieldWells(), other.tableUnaggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableFieldWells").add("TableAggregatedFieldWells", tableAggregatedFieldWells())
                .add("TableUnaggregatedFieldWells", tableUnaggregatedFieldWells()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(tableAggregatedFieldWells()));
        case "TableUnaggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(tableUnaggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TableAggregatedFieldWells", TABLE_AGGREGATED_FIELD_WELLS_FIELD);
        map.put("TableUnaggregatedFieldWells", TABLE_UNAGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableFieldWells, T> g) {
        return obj -> g.apply((TableFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableFieldWells> {
        /**
         * <p>
         * The aggregated field well for the table.
         * </p>
         * 
         * @param tableAggregatedFieldWells
         *        The aggregated field well for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableAggregatedFieldWells(TableAggregatedFieldWells tableAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field well for the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link TableAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableAggregatedFieldWells.Builder#build()} is called immediately
         * and its result is passed to {@link #tableAggregatedFieldWells(TableAggregatedFieldWells)}.
         * 
         * @param tableAggregatedFieldWells
         *        a consumer that will call methods on {@link TableAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableAggregatedFieldWells(TableAggregatedFieldWells)
         */
        default Builder tableAggregatedFieldWells(Consumer<TableAggregatedFieldWells.Builder> tableAggregatedFieldWells) {
            return tableAggregatedFieldWells(TableAggregatedFieldWells.builder().applyMutation(tableAggregatedFieldWells).build());
        }

        /**
         * <p>
         * The unaggregated field well for the table.
         * </p>
         * 
         * @param tableUnaggregatedFieldWells
         *        The unaggregated field well for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableUnaggregatedFieldWells(TableUnaggregatedFieldWells tableUnaggregatedFieldWells);

        /**
         * <p>
         * The unaggregated field well for the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableUnaggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link TableUnaggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableUnaggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to {@link #tableUnaggregatedFieldWells(TableUnaggregatedFieldWells)}.
         * 
         * @param tableUnaggregatedFieldWells
         *        a consumer that will call methods on {@link TableUnaggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableUnaggregatedFieldWells(TableUnaggregatedFieldWells)
         */
        default Builder tableUnaggregatedFieldWells(Consumer<TableUnaggregatedFieldWells.Builder> tableUnaggregatedFieldWells) {
            return tableUnaggregatedFieldWells(TableUnaggregatedFieldWells.builder().applyMutation(tableUnaggregatedFieldWells)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TableAggregatedFieldWells tableAggregatedFieldWells;

        private TableUnaggregatedFieldWells tableUnaggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldWells model) {
            tableAggregatedFieldWells(model.tableAggregatedFieldWells);
            tableUnaggregatedFieldWells(model.tableUnaggregatedFieldWells);
        }

        public final TableAggregatedFieldWells.Builder getTableAggregatedFieldWells() {
            return tableAggregatedFieldWells != null ? tableAggregatedFieldWells.toBuilder() : null;
        }

        public final void setTableAggregatedFieldWells(TableAggregatedFieldWells.BuilderImpl tableAggregatedFieldWells) {
            this.tableAggregatedFieldWells = tableAggregatedFieldWells != null ? tableAggregatedFieldWells.build() : null;
        }

        @Override
        public final Builder tableAggregatedFieldWells(TableAggregatedFieldWells tableAggregatedFieldWells) {
            this.tableAggregatedFieldWells = tableAggregatedFieldWells;
            return this;
        }

        public final TableUnaggregatedFieldWells.Builder getTableUnaggregatedFieldWells() {
            return tableUnaggregatedFieldWells != null ? tableUnaggregatedFieldWells.toBuilder() : null;
        }

        public final void setTableUnaggregatedFieldWells(TableUnaggregatedFieldWells.BuilderImpl tableUnaggregatedFieldWells) {
            this.tableUnaggregatedFieldWells = tableUnaggregatedFieldWells != null ? tableUnaggregatedFieldWells.build() : null;
        }

        @Override
        public final Builder tableUnaggregatedFieldWells(TableUnaggregatedFieldWells tableUnaggregatedFieldWells) {
            this.tableUnaggregatedFieldWells = tableUnaggregatedFieldWells;
            return this;
        }

        @Override
        public TableFieldWells build() {
            return new TableFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
