/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the dashboard you want to embed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredUserDashboardEmbeddingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RegisteredUserDashboardEmbeddingConfiguration.Builder, RegisteredUserDashboardEmbeddingConfiguration> {
    private static final SdkField<String> INITIAL_DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialDashboardId").getter(getter(RegisteredUserDashboardEmbeddingConfiguration::initialDashboardId))
            .setter(setter(Builder::initialDashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialDashboardId").build())
            .build();

    private static final SdkField<RegisteredUserDashboardFeatureConfigurations> FEATURE_CONFIGURATIONS_FIELD = SdkField
            .<RegisteredUserDashboardFeatureConfigurations> builder(MarshallingType.SDK_POJO).memberName("FeatureConfigurations")
            .getter(getter(RegisteredUserDashboardEmbeddingConfiguration::featureConfigurations))
            .setter(setter(Builder::featureConfigurations)).constructor(RegisteredUserDashboardFeatureConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureConfigurations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_DASHBOARD_ID_FIELD,
            FEATURE_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String initialDashboardId;

    private final RegisteredUserDashboardFeatureConfigurations featureConfigurations;

    private RegisteredUserDashboardEmbeddingConfiguration(BuilderImpl builder) {
        this.initialDashboardId = builder.initialDashboardId;
        this.featureConfigurations = builder.featureConfigurations;
    }

    /**
     * <p>
     * The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL.
     * When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has permissions to
     * view it.
     * </p>
     * <p>
     * If the user does not have permission to view this dashboard, they see a permissions error message.
     * </p>
     * 
     * @return The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output
     *         URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has
     *         permissions to view it.</p>
     *         <p>
     *         If the user does not have permission to view this dashboard, they see a permissions error message.
     */
    public final String initialDashboardId() {
        return initialDashboardId;
    }

    /**
     * <p>
     * The feature configurations of an embbedded Amazon QuickSight dashboard.
     * </p>
     * 
     * @return The feature configurations of an embbedded Amazon QuickSight dashboard.
     */
    public final RegisteredUserDashboardFeatureConfigurations featureConfigurations() {
        return featureConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialDashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(featureConfigurations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredUserDashboardEmbeddingConfiguration)) {
            return false;
        }
        RegisteredUserDashboardEmbeddingConfiguration other = (RegisteredUserDashboardEmbeddingConfiguration) obj;
        return Objects.equals(initialDashboardId(), other.initialDashboardId())
                && Objects.equals(featureConfigurations(), other.featureConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredUserDashboardEmbeddingConfiguration").add("InitialDashboardId", initialDashboardId())
                .add("FeatureConfigurations", featureConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialDashboardId":
            return Optional.ofNullable(clazz.cast(initialDashboardId()));
        case "FeatureConfigurations":
            return Optional.ofNullable(clazz.cast(featureConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InitialDashboardId", INITIAL_DASHBOARD_ID_FIELD);
        map.put("FeatureConfigurations", FEATURE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisteredUserDashboardEmbeddingConfiguration, T> g) {
        return obj -> g.apply((RegisteredUserDashboardEmbeddingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredUserDashboardEmbeddingConfiguration> {
        /**
         * <p>
         * The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output
         * URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has
         * permissions to view it.
         * </p>
         * <p>
         * If the user does not have permission to view this dashboard, they see a permissions error message.
         * </p>
         * 
         * @param initialDashboardId
         *        The dashboard ID for the dashboard that you want the user to see first. This ID is included in the
         *        output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user
         *        has permissions to view it.</p>
         *        <p>
         *        If the user does not have permission to view this dashboard, they see a permissions error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialDashboardId(String initialDashboardId);

        /**
         * <p>
         * The feature configurations of an embbedded Amazon QuickSight dashboard.
         * </p>
         * 
         * @param featureConfigurations
         *        The feature configurations of an embbedded Amazon QuickSight dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureConfigurations(RegisteredUserDashboardFeatureConfigurations featureConfigurations);

        /**
         * <p>
         * The feature configurations of an embbedded Amazon QuickSight dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RegisteredUserDashboardFeatureConfigurations.Builder} avoiding the need to create one manually via
         * {@link RegisteredUserDashboardFeatureConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegisteredUserDashboardFeatureConfigurations.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #featureConfigurations(RegisteredUserDashboardFeatureConfigurations)}.
         * 
         * @param featureConfigurations
         *        a consumer that will call methods on {@link RegisteredUserDashboardFeatureConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featureConfigurations(RegisteredUserDashboardFeatureConfigurations)
         */
        default Builder featureConfigurations(Consumer<RegisteredUserDashboardFeatureConfigurations.Builder> featureConfigurations) {
            return featureConfigurations(RegisteredUserDashboardFeatureConfigurations.builder()
                    .applyMutation(featureConfigurations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String initialDashboardId;

        private RegisteredUserDashboardFeatureConfigurations featureConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredUserDashboardEmbeddingConfiguration model) {
            initialDashboardId(model.initialDashboardId);
            featureConfigurations(model.featureConfigurations);
        }

        public final String getInitialDashboardId() {
            return initialDashboardId;
        }

        public final void setInitialDashboardId(String initialDashboardId) {
            this.initialDashboardId = initialDashboardId;
        }

        @Override
        public final Builder initialDashboardId(String initialDashboardId) {
            this.initialDashboardId = initialDashboardId;
            return this;
        }

        public final RegisteredUserDashboardFeatureConfigurations.Builder getFeatureConfigurations() {
            return featureConfigurations != null ? featureConfigurations.toBuilder() : null;
        }

        public final void setFeatureConfigurations(RegisteredUserDashboardFeatureConfigurations.BuilderImpl featureConfigurations) {
            this.featureConfigurations = featureConfigurations != null ? featureConfigurations.build() : null;
        }

        @Override
        public final Builder featureConfigurations(RegisteredUserDashboardFeatureConfigurations featureConfigurations) {
            this.featureConfigurations = featureConfigurations;
            return this;
        }

        @Override
        public RegisteredUserDashboardEmbeddingConfiguration build() {
            return new RegisteredUserDashboardEmbeddingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
