/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The plugin visual configuration. This includes the field wells, sorting options, and persisted options of the plugin
 * visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PluginVisualConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PluginVisualConfiguration.Builder, PluginVisualConfiguration> {
    private static final SdkField<List<PluginVisualFieldWell>> FIELD_WELLS_FIELD = SdkField
            .<List<PluginVisualFieldWell>> builder(MarshallingType.LIST)
            .memberName("FieldWells")
            .getter(getter(PluginVisualConfiguration::fieldWells))
            .setter(setter(Builder::fieldWells))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PluginVisualFieldWell> builder(MarshallingType.SDK_POJO)
                                            .constructor(PluginVisualFieldWell::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PluginVisualOptions> VISUAL_OPTIONS_FIELD = SdkField
            .<PluginVisualOptions> builder(MarshallingType.SDK_POJO).memberName("VisualOptions")
            .getter(getter(PluginVisualConfiguration::visualOptions)).setter(setter(Builder::visualOptions))
            .constructor(PluginVisualOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualOptions").build()).build();

    private static final SdkField<PluginVisualSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<PluginVisualSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(PluginVisualConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(PluginVisualSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            VISUAL_OPTIONS_FIELD, SORT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PluginVisualFieldWell> fieldWells;

    private final PluginVisualOptions visualOptions;

    private final PluginVisualSortConfiguration sortConfiguration;

    private PluginVisualConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.visualOptions = builder.visualOptions;
        this.sortConfiguration = builder.sortConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldWells property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFieldWells() {
        return fieldWells != null && !(fieldWells instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The field wells configuration of the plugin visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldWells} method.
     * </p>
     * 
     * @return The field wells configuration of the plugin visual.
     */
    public final List<PluginVisualFieldWell> fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The persisted properties of the plugin visual.
     * </p>
     * 
     * @return The persisted properties of the plugin visual.
     */
    public final PluginVisualOptions visualOptions() {
        return visualOptions;
    }

    /**
     * <p>
     * The sort configuration of the plugin visual.
     * </p>
     * 
     * @return The sort configuration of the plugin visual.
     */
    public final PluginVisualSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldWells() ? fieldWells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(visualOptions());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginVisualConfiguration)) {
            return false;
        }
        PluginVisualConfiguration other = (PluginVisualConfiguration) obj;
        return hasFieldWells() == other.hasFieldWells() && Objects.equals(fieldWells(), other.fieldWells())
                && Objects.equals(visualOptions(), other.visualOptions())
                && Objects.equals(sortConfiguration(), other.sortConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PluginVisualConfiguration").add("FieldWells", hasFieldWells() ? fieldWells() : null)
                .add("VisualOptions", visualOptions()).add("SortConfiguration", sortConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "VisualOptions":
            return Optional.ofNullable(clazz.cast(visualOptions()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("VisualOptions", VISUAL_OPTIONS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginVisualConfiguration, T> g) {
        return obj -> g.apply((PluginVisualConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PluginVisualConfiguration> {
        /**
         * <p>
         * The field wells configuration of the plugin visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells configuration of the plugin visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(Collection<PluginVisualFieldWell> fieldWells);

        /**
         * <p>
         * The field wells configuration of the plugin visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells configuration of the plugin visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(PluginVisualFieldWell... fieldWells);

        /**
         * <p>
         * The field wells configuration of the plugin visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.PluginVisualFieldWell.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.PluginVisualFieldWell#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.PluginVisualFieldWell.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldWells(List<PluginVisualFieldWell>)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.PluginVisualFieldWell.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(java.util.Collection<PluginVisualFieldWell>)
         */
        Builder fieldWells(Consumer<PluginVisualFieldWell.Builder>... fieldWells);

        /**
         * <p>
         * The persisted properties of the plugin visual.
         * </p>
         * 
         * @param visualOptions
         *        The persisted properties of the plugin visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualOptions(PluginVisualOptions visualOptions);

        /**
         * <p>
         * The persisted properties of the plugin visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link PluginVisualOptions.Builder} avoiding the
         * need to create one manually via {@link PluginVisualOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PluginVisualOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #visualOptions(PluginVisualOptions)}.
         * 
         * @param visualOptions
         *        a consumer that will call methods on {@link PluginVisualOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualOptions(PluginVisualOptions)
         */
        default Builder visualOptions(Consumer<PluginVisualOptions.Builder> visualOptions) {
            return visualOptions(PluginVisualOptions.builder().applyMutation(visualOptions).build());
        }

        /**
         * <p>
         * The sort configuration of the plugin visual.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of the plugin visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(PluginVisualSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of the plugin visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link PluginVisualSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link PluginVisualSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PluginVisualSortConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sortConfiguration(PluginVisualSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link PluginVisualSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(PluginVisualSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<PluginVisualSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(PluginVisualSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<PluginVisualFieldWell> fieldWells = DefaultSdkAutoConstructList.getInstance();

        private PluginVisualOptions visualOptions;

        private PluginVisualSortConfiguration sortConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginVisualConfiguration model) {
            fieldWells(model.fieldWells);
            visualOptions(model.visualOptions);
            sortConfiguration(model.sortConfiguration);
        }

        public final List<PluginVisualFieldWell.Builder> getFieldWells() {
            List<PluginVisualFieldWell.Builder> result = PluginVisualFieldWellsCopier.copyToBuilder(this.fieldWells);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldWells(Collection<PluginVisualFieldWell.BuilderImpl> fieldWells) {
            this.fieldWells = PluginVisualFieldWellsCopier.copyFromBuilder(fieldWells);
        }

        @Override
        public final Builder fieldWells(Collection<PluginVisualFieldWell> fieldWells) {
            this.fieldWells = PluginVisualFieldWellsCopier.copy(fieldWells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldWells(PluginVisualFieldWell... fieldWells) {
            fieldWells(Arrays.asList(fieldWells));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldWells(Consumer<PluginVisualFieldWell.Builder>... fieldWells) {
            fieldWells(Stream.of(fieldWells).map(c -> PluginVisualFieldWell.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final PluginVisualOptions.Builder getVisualOptions() {
            return visualOptions != null ? visualOptions.toBuilder() : null;
        }

        public final void setVisualOptions(PluginVisualOptions.BuilderImpl visualOptions) {
            this.visualOptions = visualOptions != null ? visualOptions.build() : null;
        }

        @Override
        public final Builder visualOptions(PluginVisualOptions visualOptions) {
            this.visualOptions = visualOptions;
            return this;
        }

        public final PluginVisualSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(PluginVisualSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(PluginVisualSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        @Override
        public PluginVisualConfiguration build() {
            return new PluginVisualConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
