/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collapse state options for the pivot table field options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableFieldCollapseStateOption implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableFieldCollapseStateOption.Builder, PivotTableFieldCollapseStateOption> {
    private static final SdkField<PivotTableFieldCollapseStateTarget> TARGET_FIELD = SdkField
            .<PivotTableFieldCollapseStateTarget> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(PivotTableFieldCollapseStateOption::target)).setter(setter(Builder::target))
            .constructor(PivotTableFieldCollapseStateTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(PivotTableFieldCollapseStateOption::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PivotTableFieldCollapseStateTarget target;

    private final String state;

    private PivotTableFieldCollapseStateOption(BuilderImpl builder) {
        this.target = builder.target;
        this.state = builder.state;
    }

    /**
     * <p>
     * A tagged-union object that sets the collapse state.
     * </p>
     * 
     * @return A tagged-union object that sets the collapse state.
     */
    public final PivotTableFieldCollapseStateTarget target() {
        return target;
    }

    /**
     * <p>
     * The state of the field target of a pivot table. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COLLAPSED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPANDED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PivotTableFieldCollapseState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the field target of a pivot table. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COLLAPSED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPANDED</code>
     *         </p>
     *         </li>
     * @see PivotTableFieldCollapseState
     */
    public final PivotTableFieldCollapseState state() {
        return PivotTableFieldCollapseState.fromValue(state);
    }

    /**
     * <p>
     * The state of the field target of a pivot table. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COLLAPSED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPANDED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PivotTableFieldCollapseState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the field target of a pivot table. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COLLAPSED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPANDED</code>
     *         </p>
     *         </li>
     * @see PivotTableFieldCollapseState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableFieldCollapseStateOption)) {
            return false;
        }
        PivotTableFieldCollapseStateOption other = (PivotTableFieldCollapseStateOption) obj;
        return Objects.equals(target(), other.target()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableFieldCollapseStateOption").add("Target", target()).add("State", stateAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Target", TARGET_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTableFieldCollapseStateOption, T> g) {
        return obj -> g.apply((PivotTableFieldCollapseStateOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableFieldCollapseStateOption> {
        /**
         * <p>
         * A tagged-union object that sets the collapse state.
         * </p>
         * 
         * @param target
         *        A tagged-union object that sets the collapse state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(PivotTableFieldCollapseStateTarget target);

        /**
         * <p>
         * A tagged-union object that sets the collapse state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PivotTableFieldCollapseStateTarget.Builder} avoiding the need to create one manually via
         * {@link PivotTableFieldCollapseStateTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableFieldCollapseStateTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #target(PivotTableFieldCollapseStateTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link PivotTableFieldCollapseStateTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(PivotTableFieldCollapseStateTarget)
         */
        default Builder target(Consumer<PivotTableFieldCollapseStateTarget.Builder> target) {
            return target(PivotTableFieldCollapseStateTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * The state of the field target of a pivot table. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COLLAPSED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPANDED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The state of the field target of a pivot table. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COLLAPSED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPANDED</code>
         *        </p>
         *        </li>
         * @see PivotTableFieldCollapseState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PivotTableFieldCollapseState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the field target of a pivot table. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COLLAPSED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPANDED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The state of the field target of a pivot table. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COLLAPSED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPANDED</code>
         *        </p>
         *        </li>
         * @see PivotTableFieldCollapseState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PivotTableFieldCollapseState
         */
        Builder state(PivotTableFieldCollapseState state);
    }

    static final class BuilderImpl implements Builder {
        private PivotTableFieldCollapseStateTarget target;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableFieldCollapseStateOption model) {
            target(model.target);
            state(model.state);
        }

        public final PivotTableFieldCollapseStateTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(PivotTableFieldCollapseStateTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(PivotTableFieldCollapseStateTarget target) {
            this.target = target;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PivotTableFieldCollapseState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public PivotTableFieldCollapseStateOption build() {
            return new PivotTableFieldCollapseStateOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
