/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control to display a list with buttons or boxes that are used to select either a single value or multiple values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterListControl implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterListControl.Builder, ParameterListControl> {
    private static final SdkField<String> PARAMETER_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterControlId").getter(getter(ParameterListControl::parameterControlId))
            .setter(setter(Builder::parameterControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterControlId").build())
            .build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(ParameterListControl::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SOURCE_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceParameterName").getter(getter(ParameterListControl::sourceParameterName))
            .setter(setter(Builder::sourceParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParameterName").build())
            .build();

    private static final SdkField<ListControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<ListControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(ParameterListControl::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(ListControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ParameterListControl::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<ParameterSelectableValues> SELECTABLE_VALUES_FIELD = SdkField
            .<ParameterSelectableValues> builder(MarshallingType.SDK_POJO).memberName("SelectableValues")
            .getter(getter(ParameterListControl::selectableValues)).setter(setter(Builder::selectableValues))
            .constructor(ParameterSelectableValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectableValues").build()).build();

    private static final SdkField<CascadingControlConfiguration> CASCADING_CONTROL_CONFIGURATION_FIELD = SdkField
            .<CascadingControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CascadingControlConfiguration")
            .getter(getter(ParameterListControl::cascadingControlConfiguration))
            .setter(setter(Builder::cascadingControlConfiguration))
            .constructor(CascadingControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CascadingControlConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_CONTROL_ID_FIELD,
            TITLE_FIELD, SOURCE_PARAMETER_NAME_FIELD, DISPLAY_OPTIONS_FIELD, TYPE_FIELD, SELECTABLE_VALUES_FIELD,
            CASCADING_CONTROL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parameterControlId;

    private final String title;

    private final String sourceParameterName;

    private final ListControlDisplayOptions displayOptions;

    private final String type;

    private final ParameterSelectableValues selectableValues;

    private final CascadingControlConfiguration cascadingControlConfiguration;

    private ParameterListControl(BuilderImpl builder) {
        this.parameterControlId = builder.parameterControlId;
        this.title = builder.title;
        this.sourceParameterName = builder.sourceParameterName;
        this.displayOptions = builder.displayOptions;
        this.type = builder.type;
        this.selectableValues = builder.selectableValues;
        this.cascadingControlConfiguration = builder.cascadingControlConfiguration;
    }

    /**
     * <p>
     * The ID of the <code>ParameterListControl</code>.
     * </p>
     * 
     * @return The ID of the <code>ParameterListControl</code>.
     */
    public final String parameterControlId() {
        return parameterControlId;
    }

    /**
     * <p>
     * The title of the <code>ParameterListControl</code>.
     * </p>
     * 
     * @return The title of the <code>ParameterListControl</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The source parameter name of the <code>ParameterListControl</code>.
     * </p>
     * 
     * @return The source parameter name of the <code>ParameterListControl</code>.
     */
    public final String sourceParameterName() {
        return sourceParameterName;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final ListControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    /**
     * <p>
     * The type of <code>ParameterListControl</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of <code>ParameterListControl</code>.
     * @see SheetControlListType
     */
    public final SheetControlListType type() {
        return SheetControlListType.fromValue(type);
    }

    /**
     * <p>
     * The type of <code>ParameterListControl</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of <code>ParameterListControl</code>.
     * @see SheetControlListType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A list of selectable values that are used in a control.
     * </p>
     * 
     * @return A list of selectable values that are used in a control.
     */
    public final ParameterSelectableValues selectableValues() {
        return selectableValues;
    }

    /**
     * <p>
     * The values that are displayed in a control can be configured to only show values that are valid based on what's
     * selected in other controls.
     * </p>
     * 
     * @return The values that are displayed in a control can be configured to only show values that are valid based on
     *         what's selected in other controls.
     */
    public final CascadingControlConfiguration cascadingControlConfiguration() {
        return cascadingControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(sourceParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(selectableValues());
        hashCode = 31 * hashCode + Objects.hashCode(cascadingControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterListControl)) {
            return false;
        }
        ParameterListControl other = (ParameterListControl) obj;
        return Objects.equals(parameterControlId(), other.parameterControlId()) && Objects.equals(title(), other.title())
                && Objects.equals(sourceParameterName(), other.sourceParameterName())
                && Objects.equals(displayOptions(), other.displayOptions())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(selectableValues(), other.selectableValues())
                && Objects.equals(cascadingControlConfiguration(), other.cascadingControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterListControl").add("ParameterControlId", parameterControlId()).add("Title", title())
                .add("SourceParameterName", sourceParameterName()).add("DisplayOptions", displayOptions())
                .add("Type", typeAsString()).add("SelectableValues", selectableValues())
                .add("CascadingControlConfiguration", cascadingControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterControlId":
            return Optional.ofNullable(clazz.cast(parameterControlId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "SourceParameterName":
            return Optional.ofNullable(clazz.cast(sourceParameterName()));
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SelectableValues":
            return Optional.ofNullable(clazz.cast(selectableValues()));
        case "CascadingControlConfiguration":
            return Optional.ofNullable(clazz.cast(cascadingControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterControlId", PARAMETER_CONTROL_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("SourceParameterName", SOURCE_PARAMETER_NAME_FIELD);
        map.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SelectableValues", SELECTABLE_VALUES_FIELD);
        map.put("CascadingControlConfiguration", CASCADING_CONTROL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterListControl, T> g) {
        return obj -> g.apply((ParameterListControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterListControl> {
        /**
         * <p>
         * The ID of the <code>ParameterListControl</code>.
         * </p>
         * 
         * @param parameterControlId
         *        The ID of the <code>ParameterListControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterControlId(String parameterControlId);

        /**
         * <p>
         * The title of the <code>ParameterListControl</code>.
         * </p>
         * 
         * @param title
         *        The title of the <code>ParameterListControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The source parameter name of the <code>ParameterListControl</code>.
         * </p>
         * 
         * @param sourceParameterName
         *        The source parameter name of the <code>ParameterListControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParameterName(String sourceParameterName);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(ListControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListControlDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link ListControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListControlDisplayOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #displayOptions(ListControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link ListControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(ListControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<ListControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(ListControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }

        /**
         * <p>
         * The type of <code>ParameterListControl</code>.
         * </p>
         * 
         * @param type
         *        The type of <code>ParameterListControl</code>.
         * @see SheetControlListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlListType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of <code>ParameterListControl</code>.
         * </p>
         * 
         * @param type
         *        The type of <code>ParameterListControl</code>.
         * @see SheetControlListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlListType
         */
        Builder type(SheetControlListType type);

        /**
         * <p>
         * A list of selectable values that are used in a control.
         * </p>
         * 
         * @param selectableValues
         *        A list of selectable values that are used in a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectableValues(ParameterSelectableValues selectableValues);

        /**
         * <p>
         * A list of selectable values that are used in a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterSelectableValues.Builder}
         * avoiding the need to create one manually via {@link ParameterSelectableValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterSelectableValues.Builder#build()} is called immediately
         * and its result is passed to {@link #selectableValues(ParameterSelectableValues)}.
         * 
         * @param selectableValues
         *        a consumer that will call methods on {@link ParameterSelectableValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectableValues(ParameterSelectableValues)
         */
        default Builder selectableValues(Consumer<ParameterSelectableValues.Builder> selectableValues) {
            return selectableValues(ParameterSelectableValues.builder().applyMutation(selectableValues).build());
        }

        /**
         * <p>
         * The values that are displayed in a control can be configured to only show values that are valid based on
         * what's selected in other controls.
         * </p>
         * 
         * @param cascadingControlConfiguration
         *        The values that are displayed in a control can be configured to only show values that are valid based
         *        on what's selected in other controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cascadingControlConfiguration(CascadingControlConfiguration cascadingControlConfiguration);

        /**
         * <p>
         * The values that are displayed in a control can be configured to only show values that are valid based on
         * what's selected in other controls.
         * </p>
         * This is a convenience method that creates an instance of the {@link CascadingControlConfiguration.Builder}
         * avoiding the need to create one manually via {@link CascadingControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CascadingControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cascadingControlConfiguration(CascadingControlConfiguration)}.
         * 
         * @param cascadingControlConfiguration
         *        a consumer that will call methods on {@link CascadingControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cascadingControlConfiguration(CascadingControlConfiguration)
         */
        default Builder cascadingControlConfiguration(
                Consumer<CascadingControlConfiguration.Builder> cascadingControlConfiguration) {
            return cascadingControlConfiguration(CascadingControlConfiguration.builder()
                    .applyMutation(cascadingControlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String parameterControlId;

        private String title;

        private String sourceParameterName;

        private ListControlDisplayOptions displayOptions;

        private String type;

        private ParameterSelectableValues selectableValues;

        private CascadingControlConfiguration cascadingControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterListControl model) {
            parameterControlId(model.parameterControlId);
            title(model.title);
            sourceParameterName(model.sourceParameterName);
            displayOptions(model.displayOptions);
            type(model.type);
            selectableValues(model.selectableValues);
            cascadingControlConfiguration(model.cascadingControlConfiguration);
        }

        public final String getParameterControlId() {
            return parameterControlId;
        }

        public final void setParameterControlId(String parameterControlId) {
            this.parameterControlId = parameterControlId;
        }

        @Override
        public final Builder parameterControlId(String parameterControlId) {
            this.parameterControlId = parameterControlId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSourceParameterName() {
            return sourceParameterName;
        }

        public final void setSourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
        }

        @Override
        public final Builder sourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
            return this;
        }

        public final ListControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(ListControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(ListControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SheetControlListType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ParameterSelectableValues.Builder getSelectableValues() {
            return selectableValues != null ? selectableValues.toBuilder() : null;
        }

        public final void setSelectableValues(ParameterSelectableValues.BuilderImpl selectableValues) {
            this.selectableValues = selectableValues != null ? selectableValues.build() : null;
        }

        @Override
        public final Builder selectableValues(ParameterSelectableValues selectableValues) {
            this.selectableValues = selectableValues;
            return this;
        }

        public final CascadingControlConfiguration.Builder getCascadingControlConfiguration() {
            return cascadingControlConfiguration != null ? cascadingControlConfiguration.toBuilder() : null;
        }

        public final void setCascadingControlConfiguration(CascadingControlConfiguration.BuilderImpl cascadingControlConfiguration) {
            this.cascadingControlConfiguration = cascadingControlConfiguration != null ? cascadingControlConfiguration.build()
                    : null;
        }

        @Override
        public final Builder cascadingControlConfiguration(CascadingControlConfiguration cascadingControlConfiguration) {
            this.cascadingControlConfiguration = cascadingControlConfiguration;
            return this;
        }

        @Override
        public ParameterListControl build() {
            return new ParameterListControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
