/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The control of a parameter that users can interact with in a dashboard or an analysis.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterControl implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterControl.Builder, ParameterControl> {
    private static final SdkField<ParameterDateTimePickerControl> DATE_TIME_PICKER_FIELD = SdkField
            .<ParameterDateTimePickerControl> builder(MarshallingType.SDK_POJO).memberName("DateTimePicker")
            .getter(getter(ParameterControl::dateTimePicker)).setter(setter(Builder::dateTimePicker))
            .constructor(ParameterDateTimePickerControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimePicker").build()).build();

    private static final SdkField<ParameterListControl> LIST_FIELD = SdkField
            .<ParameterListControl> builder(MarshallingType.SDK_POJO).memberName("List").getter(getter(ParameterControl::list))
            .setter(setter(Builder::list)).constructor(ParameterListControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("List").build()).build();

    private static final SdkField<ParameterDropDownControl> DROPDOWN_FIELD = SdkField
            .<ParameterDropDownControl> builder(MarshallingType.SDK_POJO).memberName("Dropdown")
            .getter(getter(ParameterControl::dropdown)).setter(setter(Builder::dropdown))
            .constructor(ParameterDropDownControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dropdown").build()).build();

    private static final SdkField<ParameterTextFieldControl> TEXT_FIELD_FIELD = SdkField
            .<ParameterTextFieldControl> builder(MarshallingType.SDK_POJO).memberName("TextField")
            .getter(getter(ParameterControl::textField)).setter(setter(Builder::textField))
            .constructor(ParameterTextFieldControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextField").build()).build();

    private static final SdkField<ParameterTextAreaControl> TEXT_AREA_FIELD = SdkField
            .<ParameterTextAreaControl> builder(MarshallingType.SDK_POJO).memberName("TextArea")
            .getter(getter(ParameterControl::textArea)).setter(setter(Builder::textArea))
            .constructor(ParameterTextAreaControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextArea").build()).build();

    private static final SdkField<ParameterSliderControl> SLIDER_FIELD = SdkField
            .<ParameterSliderControl> builder(MarshallingType.SDK_POJO).memberName("Slider")
            .getter(getter(ParameterControl::slider)).setter(setter(Builder::slider))
            .constructor(ParameterSliderControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_TIME_PICKER_FIELD,
            LIST_FIELD, DROPDOWN_FIELD, TEXT_FIELD_FIELD, TEXT_AREA_FIELD, SLIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ParameterDateTimePickerControl dateTimePicker;

    private final ParameterListControl list;

    private final ParameterDropDownControl dropdown;

    private final ParameterTextFieldControl textField;

    private final ParameterTextAreaControl textArea;

    private final ParameterSliderControl slider;

    private ParameterControl(BuilderImpl builder) {
        this.dateTimePicker = builder.dateTimePicker;
        this.list = builder.list;
        this.dropdown = builder.dropdown;
        this.textField = builder.textField;
        this.textArea = builder.textArea;
        this.slider = builder.slider;
    }

    /**
     * <p>
     * A control from a date parameter that specifies date and time.
     * </p>
     * 
     * @return A control from a date parameter that specifies date and time.
     */
    public final ParameterDateTimePickerControl dateTimePicker() {
        return dateTimePicker;
    }

    /**
     * <p>
     * A control to display a list with buttons or boxes that are used to select either a single value or multiple
     * values.
     * </p>
     * 
     * @return A control to display a list with buttons or boxes that are used to select either a single value or
     *         multiple values.
     */
    public final ParameterListControl list() {
        return list;
    }

    /**
     * <p>
     * A control to display a dropdown list with buttons that are used to select a single value.
     * </p>
     * 
     * @return A control to display a dropdown list with buttons that are used to select a single value.
     */
    public final ParameterDropDownControl dropdown() {
        return dropdown;
    }

    /**
     * <p>
     * A control to display a text box that is used to enter a single entry.
     * </p>
     * 
     * @return A control to display a text box that is used to enter a single entry.
     */
    public final ParameterTextFieldControl textField() {
        return textField;
    }

    /**
     * <p>
     * A control to display a text box that is used to enter multiple entries.
     * </p>
     * 
     * @return A control to display a text box that is used to enter multiple entries.
     */
    public final ParameterTextAreaControl textArea() {
        return textArea;
    }

    /**
     * <p>
     * A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
     * </p>
     * 
     * @return A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
     */
    public final ParameterSliderControl slider() {
        return slider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateTimePicker());
        hashCode = 31 * hashCode + Objects.hashCode(list());
        hashCode = 31 * hashCode + Objects.hashCode(dropdown());
        hashCode = 31 * hashCode + Objects.hashCode(textField());
        hashCode = 31 * hashCode + Objects.hashCode(textArea());
        hashCode = 31 * hashCode + Objects.hashCode(slider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterControl)) {
            return false;
        }
        ParameterControl other = (ParameterControl) obj;
        return Objects.equals(dateTimePicker(), other.dateTimePicker()) && Objects.equals(list(), other.list())
                && Objects.equals(dropdown(), other.dropdown()) && Objects.equals(textField(), other.textField())
                && Objects.equals(textArea(), other.textArea()) && Objects.equals(slider(), other.slider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterControl").add("DateTimePicker", dateTimePicker()).add("List", list())
                .add("Dropdown", dropdown()).add("TextField", textField()).add("TextArea", textArea()).add("Slider", slider())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DateTimePicker":
            return Optional.ofNullable(clazz.cast(dateTimePicker()));
        case "List":
            return Optional.ofNullable(clazz.cast(list()));
        case "Dropdown":
            return Optional.ofNullable(clazz.cast(dropdown()));
        case "TextField":
            return Optional.ofNullable(clazz.cast(textField()));
        case "TextArea":
            return Optional.ofNullable(clazz.cast(textArea()));
        case "Slider":
            return Optional.ofNullable(clazz.cast(slider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DateTimePicker", DATE_TIME_PICKER_FIELD);
        map.put("List", LIST_FIELD);
        map.put("Dropdown", DROPDOWN_FIELD);
        map.put("TextField", TEXT_FIELD_FIELD);
        map.put("TextArea", TEXT_AREA_FIELD);
        map.put("Slider", SLIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterControl, T> g) {
        return obj -> g.apply((ParameterControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterControl> {
        /**
         * <p>
         * A control from a date parameter that specifies date and time.
         * </p>
         * 
         * @param dateTimePicker
         *        A control from a date parameter that specifies date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimePicker(ParameterDateTimePickerControl dateTimePicker);

        /**
         * <p>
         * A control from a date parameter that specifies date and time.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterDateTimePickerControl.Builder}
         * avoiding the need to create one manually via {@link ParameterDateTimePickerControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterDateTimePickerControl.Builder#build()} is called
         * immediately and its result is passed to {@link #dateTimePicker(ParameterDateTimePickerControl)}.
         * 
         * @param dateTimePicker
         *        a consumer that will call methods on {@link ParameterDateTimePickerControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimePicker(ParameterDateTimePickerControl)
         */
        default Builder dateTimePicker(Consumer<ParameterDateTimePickerControl.Builder> dateTimePicker) {
            return dateTimePicker(ParameterDateTimePickerControl.builder().applyMutation(dateTimePicker).build());
        }

        /**
         * <p>
         * A control to display a list with buttons or boxes that are used to select either a single value or multiple
         * values.
         * </p>
         * 
         * @param list
         *        A control to display a list with buttons or boxes that are used to select either a single value or
         *        multiple values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder list(ParameterListControl list);

        /**
         * <p>
         * A control to display a list with buttons or boxes that are used to select either a single value or multiple
         * values.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterListControl.Builder} avoiding
         * the need to create one manually via {@link ParameterListControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterListControl.Builder#build()} is called immediately and
         * its result is passed to {@link #list(ParameterListControl)}.
         * 
         * @param list
         *        a consumer that will call methods on {@link ParameterListControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #list(ParameterListControl)
         */
        default Builder list(Consumer<ParameterListControl.Builder> list) {
            return list(ParameterListControl.builder().applyMutation(list).build());
        }

        /**
         * <p>
         * A control to display a dropdown list with buttons that are used to select a single value.
         * </p>
         * 
         * @param dropdown
         *        A control to display a dropdown list with buttons that are used to select a single value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dropdown(ParameterDropDownControl dropdown);

        /**
         * <p>
         * A control to display a dropdown list with buttons that are used to select a single value.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterDropDownControl.Builder}
         * avoiding the need to create one manually via {@link ParameterDropDownControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterDropDownControl.Builder#build()} is called immediately
         * and its result is passed to {@link #dropdown(ParameterDropDownControl)}.
         * 
         * @param dropdown
         *        a consumer that will call methods on {@link ParameterDropDownControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dropdown(ParameterDropDownControl)
         */
        default Builder dropdown(Consumer<ParameterDropDownControl.Builder> dropdown) {
            return dropdown(ParameterDropDownControl.builder().applyMutation(dropdown).build());
        }

        /**
         * <p>
         * A control to display a text box that is used to enter a single entry.
         * </p>
         * 
         * @param textField
         *        A control to display a text box that is used to enter a single entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textField(ParameterTextFieldControl textField);

        /**
         * <p>
         * A control to display a text box that is used to enter a single entry.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterTextFieldControl.Builder}
         * avoiding the need to create one manually via {@link ParameterTextFieldControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterTextFieldControl.Builder#build()} is called immediately
         * and its result is passed to {@link #textField(ParameterTextFieldControl)}.
         * 
         * @param textField
         *        a consumer that will call methods on {@link ParameterTextFieldControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textField(ParameterTextFieldControl)
         */
        default Builder textField(Consumer<ParameterTextFieldControl.Builder> textField) {
            return textField(ParameterTextFieldControl.builder().applyMutation(textField).build());
        }

        /**
         * <p>
         * A control to display a text box that is used to enter multiple entries.
         * </p>
         * 
         * @param textArea
         *        A control to display a text box that is used to enter multiple entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textArea(ParameterTextAreaControl textArea);

        /**
         * <p>
         * A control to display a text box that is used to enter multiple entries.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterTextAreaControl.Builder}
         * avoiding the need to create one manually via {@link ParameterTextAreaControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterTextAreaControl.Builder#build()} is called immediately
         * and its result is passed to {@link #textArea(ParameterTextAreaControl)}.
         * 
         * @param textArea
         *        a consumer that will call methods on {@link ParameterTextAreaControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textArea(ParameterTextAreaControl)
         */
        default Builder textArea(Consumer<ParameterTextAreaControl.Builder> textArea) {
            return textArea(ParameterTextAreaControl.builder().applyMutation(textArea).build());
        }

        /**
         * <p>
         * A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
         * </p>
         * 
         * @param slider
         *        A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slider(ParameterSliderControl slider);

        /**
         * <p>
         * A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterSliderControl.Builder} avoiding
         * the need to create one manually via {@link ParameterSliderControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterSliderControl.Builder#build()} is called immediately and
         * its result is passed to {@link #slider(ParameterSliderControl)}.
         * 
         * @param slider
         *        a consumer that will call methods on {@link ParameterSliderControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slider(ParameterSliderControl)
         */
        default Builder slider(Consumer<ParameterSliderControl.Builder> slider) {
            return slider(ParameterSliderControl.builder().applyMutation(slider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ParameterDateTimePickerControl dateTimePicker;

        private ParameterListControl list;

        private ParameterDropDownControl dropdown;

        private ParameterTextFieldControl textField;

        private ParameterTextAreaControl textArea;

        private ParameterSliderControl slider;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterControl model) {
            dateTimePicker(model.dateTimePicker);
            list(model.list);
            dropdown(model.dropdown);
            textField(model.textField);
            textArea(model.textArea);
            slider(model.slider);
        }

        public final ParameterDateTimePickerControl.Builder getDateTimePicker() {
            return dateTimePicker != null ? dateTimePicker.toBuilder() : null;
        }

        public final void setDateTimePicker(ParameterDateTimePickerControl.BuilderImpl dateTimePicker) {
            this.dateTimePicker = dateTimePicker != null ? dateTimePicker.build() : null;
        }

        @Override
        public final Builder dateTimePicker(ParameterDateTimePickerControl dateTimePicker) {
            this.dateTimePicker = dateTimePicker;
            return this;
        }

        public final ParameterListControl.Builder getList() {
            return list != null ? list.toBuilder() : null;
        }

        public final void setList(ParameterListControl.BuilderImpl list) {
            this.list = list != null ? list.build() : null;
        }

        @Override
        public final Builder list(ParameterListControl list) {
            this.list = list;
            return this;
        }

        public final ParameterDropDownControl.Builder getDropdown() {
            return dropdown != null ? dropdown.toBuilder() : null;
        }

        public final void setDropdown(ParameterDropDownControl.BuilderImpl dropdown) {
            this.dropdown = dropdown != null ? dropdown.build() : null;
        }

        @Override
        public final Builder dropdown(ParameterDropDownControl dropdown) {
            this.dropdown = dropdown;
            return this;
        }

        public final ParameterTextFieldControl.Builder getTextField() {
            return textField != null ? textField.toBuilder() : null;
        }

        public final void setTextField(ParameterTextFieldControl.BuilderImpl textField) {
            this.textField = textField != null ? textField.build() : null;
        }

        @Override
        public final Builder textField(ParameterTextFieldControl textField) {
            this.textField = textField;
            return this;
        }

        public final ParameterTextAreaControl.Builder getTextArea() {
            return textArea != null ? textArea.toBuilder() : null;
        }

        public final void setTextArea(ParameterTextAreaControl.BuilderImpl textArea) {
            this.textArea = textArea != null ? textArea.build() : null;
        }

        @Override
        public final Builder textArea(ParameterTextAreaControl textArea) {
            this.textArea = textArea;
            return this;
        }

        public final ParameterSliderControl.Builder getSlider() {
            return slider != null ? slider.toBuilder() : null;
        }

        public final void setSlider(ParameterSliderControl.BuilderImpl slider) {
            this.slider = slider != null ? slider.build() : null;
        }

        @Override
        public final Builder slider(ParameterSliderControl slider) {
            this.slider = slider;
            return this;
        }

        @Override
        public ParameterControl build() {
            return new ParameterControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
