/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The color palette.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Palette implements SdkPojo, Serializable, ToCopyableBuilder<Palette.Builder, Palette> {
    private static final SdkField<String> FOREGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Foreground").getter(getter(Palette::foreground)).setter(setter(Builder::foreground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Foreground").build()).build();

    private static final SdkField<String> BACKGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Background").getter(getter(Palette::background)).setter(setter(Builder::background))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Background").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOREGROUND_FIELD,
            BACKGROUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String foreground;

    private final String background;

    private Palette(BuilderImpl builder) {
        this.foreground = builder.foreground;
        this.background = builder.background;
    }

    /**
     * <p>
     * The foreground color.
     * </p>
     * 
     * @return The foreground color.
     */
    public final String foreground() {
        return foreground;
    }

    /**
     * <p>
     * The background color.
     * </p>
     * 
     * @return The background color.
     */
    public final String background() {
        return background;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(foreground());
        hashCode = 31 * hashCode + Objects.hashCode(background());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Palette)) {
            return false;
        }
        Palette other = (Palette) obj;
        return Objects.equals(foreground(), other.foreground()) && Objects.equals(background(), other.background());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Palette").add("Foreground", foreground()).add("Background", background()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Foreground":
            return Optional.ofNullable(clazz.cast(foreground()));
        case "Background":
            return Optional.ofNullable(clazz.cast(background()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Foreground", FOREGROUND_FIELD);
        map.put("Background", BACKGROUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Palette, T> g) {
        return obj -> g.apply((Palette) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Palette> {
        /**
         * <p>
         * The foreground color.
         * </p>
         * 
         * @param foreground
         *        The foreground color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foreground(String foreground);

        /**
         * <p>
         * The background color.
         * </p>
         * 
         * @param background
         *        The background color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder background(String background);
    }

    static final class BuilderImpl implements Builder {
        private String foreground;

        private String background;

        private BuilderImpl() {
        }

        private BuilderImpl(Palette model) {
            foreground(model.foreground);
            background(model.background);
        }

        public final String getForeground() {
            return foreground;
        }

        public final void setForeground(String foreground) {
            this.foreground = foreground;
        }

        @Override
        public final Builder foreground(String foreground) {
            this.foreground = foreground;
            return this;
        }

        public final String getBackground() {
            return background;
        }

        public final void setBackground(String background) {
            this.background = background;
        }

        @Override
        public final Builder background(String background) {
            this.background = background;
            return this;
        }

        @Override
        public Palette build() {
            return new Palette(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
