/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBrandsResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListBrandsResponse.Builder, ListBrandsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBrandsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<BrandSummary>> BRANDS_FIELD = SdkField
            .<List<BrandSummary>> builder(MarshallingType.LIST)
            .memberName("Brands")
            .getter(getter(ListBrandsResponse::brands))
            .setter(setter(Builder::brands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrandSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrandSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_TOKEN_FIELD, BRANDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<BrandSummary> brands;

    private ListBrandsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.brands = builder.brands;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Brands property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBrands() {
        return brands != null && !(brands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all brands in your Amazon Web Services account. This structure provides basic information about each
     * brand.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBrands} method.
     * </p>
     * 
     * @return A list of all brands in your Amazon Web Services account. This structure provides basic information about
     *         each brand.
     */
    public final List<BrandSummary> brands() {
        return brands;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasBrands() ? brands() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBrandsResponse)) {
            return false;
        }
        ListBrandsResponse other = (ListBrandsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasBrands() == other.hasBrands()
                && Objects.equals(brands(), other.brands());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBrandsResponse").add("NextToken", nextToken()).add("Brands", hasBrands() ? brands() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Brands":
            return Optional.ofNullable(clazz.cast(brands()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Brands", BRANDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBrandsResponse, T> g) {
        return obj -> g.apply((ListBrandsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBrandsResponse> {
        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of all brands in your Amazon Web Services account. This structure provides basic information about
         * each brand.
         * </p>
         * 
         * @param brands
         *        A list of all brands in your Amazon Web Services account. This structure provides basic information
         *        about each brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brands(Collection<BrandSummary> brands);

        /**
         * <p>
         * A list of all brands in your Amazon Web Services account. This structure provides basic information about
         * each brand.
         * </p>
         * 
         * @param brands
         *        A list of all brands in your Amazon Web Services account. This structure provides basic information
         *        about each brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brands(BrandSummary... brands);

        /**
         * <p>
         * A list of all brands in your Amazon Web Services account. This structure provides basic information about
         * each brand.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.BrandSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.BrandSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.BrandSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #brands(List<BrandSummary>)}.
         * 
         * @param brands
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.BrandSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brands(java.util.Collection<BrandSummary>)
         */
        Builder brands(Consumer<BrandSummary.Builder>... brands);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<BrandSummary> brands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBrandsResponse model) {
            super(model);
            nextToken(model.nextToken);
            brands(model.brands);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BrandSummary.Builder> getBrands() {
            List<BrandSummary.Builder> result = BrandSummaryListCopier.copyToBuilder(this.brands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrands(Collection<BrandSummary.BuilderImpl> brands) {
            this.brands = BrandSummaryListCopier.copyFromBuilder(brands);
        }

        @Override
        public final Builder brands(Collection<BrandSummary> brands) {
            this.brands = BrandSummaryListCopier.copy(brands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brands(BrandSummary... brands) {
            brands(Arrays.asList(brands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brands(Consumer<BrandSummary.Builder>... brands) {
            brands(Stream.of(brands).map(c -> BrandSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBrandsResponse build() {
            return new ListBrandsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
