/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The point style for a point layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialPointStyle implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialPointStyle.Builder, GeospatialPointStyle> {
    private static final SdkField<GeospatialCircleSymbolStyle> CIRCLE_SYMBOL_STYLE_FIELD = SdkField
            .<GeospatialCircleSymbolStyle> builder(MarshallingType.SDK_POJO).memberName("CircleSymbolStyle")
            .getter(getter(GeospatialPointStyle::circleSymbolStyle)).setter(setter(Builder::circleSymbolStyle))
            .constructor(GeospatialCircleSymbolStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CircleSymbolStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIRCLE_SYMBOL_STYLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialCircleSymbolStyle circleSymbolStyle;

    private GeospatialPointStyle(BuilderImpl builder) {
        this.circleSymbolStyle = builder.circleSymbolStyle;
    }

    /**
     * <p>
     * The circle symbol style for a point layer.
     * </p>
     * 
     * @return The circle symbol style for a point layer.
     */
    public final GeospatialCircleSymbolStyle circleSymbolStyle() {
        return circleSymbolStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(circleSymbolStyle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialPointStyle)) {
            return false;
        }
        GeospatialPointStyle other = (GeospatialPointStyle) obj;
        return Objects.equals(circleSymbolStyle(), other.circleSymbolStyle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialPointStyle").add("CircleSymbolStyle", circleSymbolStyle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CircleSymbolStyle":
            return Optional.ofNullable(clazz.cast(circleSymbolStyle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CircleSymbolStyle", CIRCLE_SYMBOL_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialPointStyle, T> g) {
        return obj -> g.apply((GeospatialPointStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialPointStyle> {
        /**
         * <p>
         * The circle symbol style for a point layer.
         * </p>
         * 
         * @param circleSymbolStyle
         *        The circle symbol style for a point layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder circleSymbolStyle(GeospatialCircleSymbolStyle circleSymbolStyle);

        /**
         * <p>
         * The circle symbol style for a point layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialCircleSymbolStyle.Builder}
         * avoiding the need to create one manually via {@link GeospatialCircleSymbolStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialCircleSymbolStyle.Builder#build()} is called
         * immediately and its result is passed to {@link #circleSymbolStyle(GeospatialCircleSymbolStyle)}.
         * 
         * @param circleSymbolStyle
         *        a consumer that will call methods on {@link GeospatialCircleSymbolStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #circleSymbolStyle(GeospatialCircleSymbolStyle)
         */
        default Builder circleSymbolStyle(Consumer<GeospatialCircleSymbolStyle.Builder> circleSymbolStyle) {
            return circleSymbolStyle(GeospatialCircleSymbolStyle.builder().applyMutation(circleSymbolStyle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialCircleSymbolStyle circleSymbolStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialPointStyle model) {
            circleSymbolStyle(model.circleSymbolStyle);
        }

        public final GeospatialCircleSymbolStyle.Builder getCircleSymbolStyle() {
            return circleSymbolStyle != null ? circleSymbolStyle.toBuilder() : null;
        }

        public final void setCircleSymbolStyle(GeospatialCircleSymbolStyle.BuilderImpl circleSymbolStyle) {
            this.circleSymbolStyle = circleSymbolStyle != null ? circleSymbolStyle.build() : null;
        }

        @Override
        public final Builder circleSymbolStyle(GeospatialCircleSymbolStyle circleSymbolStyle) {
            this.circleSymbolStyle = circleSymbolStyle;
            return this;
        }

        @Override
        public GeospatialPointStyle build() {
            return new GeospatialPointStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
