/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The values that are displayed in a control can be configured to only show values that are valid based on what's
 * selected in other controls.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CascadingControlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CascadingControlConfiguration.Builder, CascadingControlConfiguration> {
    private static final SdkField<List<CascadingControlSource>> SOURCE_CONTROLS_FIELD = SdkField
            .<List<CascadingControlSource>> builder(MarshallingType.LIST)
            .memberName("SourceControls")
            .getter(getter(CascadingControlConfiguration::sourceControls))
            .setter(setter(Builder::sourceControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CascadingControlSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(CascadingControlSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CONTROLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CascadingControlSource> sourceControls;

    private CascadingControlConfiguration(BuilderImpl builder) {
        this.sourceControls = builder.sourceControls;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceControls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceControls() {
        return sourceControls != null && !(sourceControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of source controls that determine the values that are used in the current control.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceControls} method.
     * </p>
     * 
     * @return A list of source controls that determine the values that are used in the current control.
     */
    public final List<CascadingControlSource> sourceControls() {
        return sourceControls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceControls() ? sourceControls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CascadingControlConfiguration)) {
            return false;
        }
        CascadingControlConfiguration other = (CascadingControlConfiguration) obj;
        return hasSourceControls() == other.hasSourceControls() && Objects.equals(sourceControls(), other.sourceControls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CascadingControlConfiguration")
                .add("SourceControls", hasSourceControls() ? sourceControls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceControls":
            return Optional.ofNullable(clazz.cast(sourceControls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceControls", SOURCE_CONTROLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CascadingControlConfiguration, T> g) {
        return obj -> g.apply((CascadingControlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CascadingControlConfiguration> {
        /**
         * <p>
         * A list of source controls that determine the values that are used in the current control.
         * </p>
         * 
         * @param sourceControls
         *        A list of source controls that determine the values that are used in the current control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceControls(Collection<CascadingControlSource> sourceControls);

        /**
         * <p>
         * A list of source controls that determine the values that are used in the current control.
         * </p>
         * 
         * @param sourceControls
         *        A list of source controls that determine the values that are used in the current control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceControls(CascadingControlSource... sourceControls);

        /**
         * <p>
         * A list of source controls that determine the values that are used in the current control.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.CascadingControlSource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.CascadingControlSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.CascadingControlSource.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceControls(List<CascadingControlSource>)}.
         * 
         * @param sourceControls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.CascadingControlSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceControls(java.util.Collection<CascadingControlSource>)
         */
        Builder sourceControls(Consumer<CascadingControlSource.Builder>... sourceControls);
    }

    static final class BuilderImpl implements Builder {
        private List<CascadingControlSource> sourceControls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CascadingControlConfiguration model) {
            sourceControls(model.sourceControls);
        }

        public final List<CascadingControlSource.Builder> getSourceControls() {
            List<CascadingControlSource.Builder> result = CascadingControlSourceListCopier.copyToBuilder(this.sourceControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceControls(Collection<CascadingControlSource.BuilderImpl> sourceControls) {
            this.sourceControls = CascadingControlSourceListCopier.copyFromBuilder(sourceControls);
        }

        @Override
        public final Builder sourceControls(Collection<CascadingControlSource> sourceControls) {
            this.sourceControls = CascadingControlSourceListCopier.copy(sourceControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceControls(CascadingControlSource... sourceControls) {
            sourceControls(Arrays.asList(sourceControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceControls(Consumer<CascadingControlSource.Builder>... sourceControls) {
            sourceControls(Stream.of(sourceControls).map(c -> CascadingControlSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CascadingControlConfiguration build() {
            return new CascadingControlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
