/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The element style.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrandElementStyle implements SdkPojo, Serializable,
        ToCopyableBuilder<BrandElementStyle.Builder, BrandElementStyle> {
    private static final SdkField<NavbarStyle> NAVBAR_STYLE_FIELD = SdkField.<NavbarStyle> builder(MarshallingType.SDK_POJO)
            .memberName("NavbarStyle").getter(getter(BrandElementStyle::navbarStyle)).setter(setter(Builder::navbarStyle))
            .constructor(NavbarStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NavbarStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAVBAR_STYLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NavbarStyle navbarStyle;

    private BrandElementStyle(BuilderImpl builder) {
        this.navbarStyle = builder.navbarStyle;
    }

    /**
     * <p>
     * The navigation bar style.
     * </p>
     * 
     * @return The navigation bar style.
     */
    public final NavbarStyle navbarStyle() {
        return navbarStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(navbarStyle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrandElementStyle)) {
            return false;
        }
        BrandElementStyle other = (BrandElementStyle) obj;
        return Objects.equals(navbarStyle(), other.navbarStyle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrandElementStyle").add("NavbarStyle", navbarStyle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NavbarStyle":
            return Optional.ofNullable(clazz.cast(navbarStyle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NavbarStyle", NAVBAR_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrandElementStyle, T> g) {
        return obj -> g.apply((BrandElementStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrandElementStyle> {
        /**
         * <p>
         * The navigation bar style.
         * </p>
         * 
         * @param navbarStyle
         *        The navigation bar style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder navbarStyle(NavbarStyle navbarStyle);

        /**
         * <p>
         * The navigation bar style.
         * </p>
         * This is a convenience method that creates an instance of the {@link NavbarStyle.Builder} avoiding the need to
         * create one manually via {@link NavbarStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NavbarStyle.Builder#build()} is called immediately and its result
         * is passed to {@link #navbarStyle(NavbarStyle)}.
         * 
         * @param navbarStyle
         *        a consumer that will call methods on {@link NavbarStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #navbarStyle(NavbarStyle)
         */
        default Builder navbarStyle(Consumer<NavbarStyle.Builder> navbarStyle) {
            return navbarStyle(NavbarStyle.builder().applyMutation(navbarStyle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NavbarStyle navbarStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(BrandElementStyle model) {
            navbarStyle(model.navbarStyle);
        }

        public final NavbarStyle.Builder getNavbarStyle() {
            return navbarStyle != null ? navbarStyle.toBuilder() : null;
        }

        public final void setNavbarStyle(NavbarStyle.BuilderImpl navbarStyle) {
            this.navbarStyle = navbarStyle != null ? navbarStyle.build() : null;
        }

        @Override
        public final Builder navbarStyle(NavbarStyle navbarStyle) {
            this.navbarStyle = navbarStyle;
            return this;
        }

        @Override
        public BrandElementStyle build() {
            return new BrandElementStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
