/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AssetBundleImportJobAnalysisOverrideTagsListCopier {
    static List<AssetBundleImportJobAnalysisOverrideTags> copy(
            Collection<? extends AssetBundleImportJobAnalysisOverrideTags> assetBundleImportJobAnalysisOverrideTagsListParam) {
        List<AssetBundleImportJobAnalysisOverrideTags> list;
        if (assetBundleImportJobAnalysisOverrideTagsListParam == null
                || assetBundleImportJobAnalysisOverrideTagsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AssetBundleImportJobAnalysisOverrideTags> modifiableList = new ArrayList<>(
                    assetBundleImportJobAnalysisOverrideTagsListParam.size());
            assetBundleImportJobAnalysisOverrideTagsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AssetBundleImportJobAnalysisOverrideTags> copyFromBuilder(
            Collection<? extends AssetBundleImportJobAnalysisOverrideTags.Builder> assetBundleImportJobAnalysisOverrideTagsListParam) {
        List<AssetBundleImportJobAnalysisOverrideTags> list;
        if (assetBundleImportJobAnalysisOverrideTagsListParam == null
                || assetBundleImportJobAnalysisOverrideTagsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AssetBundleImportJobAnalysisOverrideTags> modifiableList = new ArrayList<>(
                    assetBundleImportJobAnalysisOverrideTagsListParam.size());
            assetBundleImportJobAnalysisOverrideTagsListParam.forEach(entry -> {
                AssetBundleImportJobAnalysisOverrideTags member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AssetBundleImportJobAnalysisOverrideTags.Builder> copyToBuilder(
            Collection<? extends AssetBundleImportJobAnalysisOverrideTags> assetBundleImportJobAnalysisOverrideTagsListParam) {
        List<AssetBundleImportJobAnalysisOverrideTags.Builder> list;
        if (assetBundleImportJobAnalysisOverrideTagsListParam == null
                || assetBundleImportJobAnalysisOverrideTagsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AssetBundleImportJobAnalysisOverrideTags.Builder> modifiableList = new ArrayList<>(
                    assetBundleImportJobAnalysisOverrideTagsListParam.size());
            assetBundleImportJobAnalysisOverrideTagsListParam.forEach(entry -> {
                AssetBundleImportJobAnalysisOverrideTags.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
