/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the export job that includes details of the job's configuration and its current status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleExportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetBundleExportJobSummary.Builder, AssetBundleExportJobSummary> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(AssetBundleExportJobSummary::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AssetBundleExportJobSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(AssetBundleExportJobSummary::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> ASSET_BUNDLE_EXPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetBundleExportJobId").getter(getter(AssetBundleExportJobSummary::assetBundleExportJobId))
            .setter(setter(Builder::assetBundleExportJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleExportJobId").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_ALL_DEPENDENCIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeAllDependencies").getter(getter(AssetBundleExportJobSummary::includeAllDependencies))
            .setter(setter(Builder::includeAllDependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllDependencies").build())
            .build();

    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportFormat").getter(getter(AssetBundleExportJobSummary::exportFormatAsString))
            .setter(setter(Builder::exportFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()).build();

    private static final SdkField<Boolean> INCLUDE_PERMISSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludePermissions").getter(getter(AssetBundleExportJobSummary::includePermissions))
            .setter(setter(Builder::includePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePermissions").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeTags").getter(getter(AssetBundleExportJobSummary::includeTags))
            .setter(setter(Builder::includeTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, ARN_FIELD,
            CREATED_TIME_FIELD, ASSET_BUNDLE_EXPORT_JOB_ID_FIELD, INCLUDE_ALL_DEPENDENCIES_FIELD, EXPORT_FORMAT_FIELD,
            INCLUDE_PERMISSIONS_FIELD, INCLUDE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobStatus;

    private final String arn;

    private final Instant createdTime;

    private final String assetBundleExportJobId;

    private final Boolean includeAllDependencies;

    private final String exportFormat;

    private final Boolean includePermissions;

    private final Boolean includeTags;

    private AssetBundleExportJobSummary(BuilderImpl builder) {
        this.jobStatus = builder.jobStatus;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.assetBundleExportJobId = builder.assetBundleExportJobId;
        this.includeAllDependencies = builder.includeAllDependencies;
        this.exportFormat = builder.exportFormat;
        this.includePermissions = builder.includePermissions;
        this.includeTags = builder.includeTags;
    }

    /**
     * <p>
     * The current status of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link AssetBundleExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the export job.
     * @see AssetBundleExportJobStatus
     */
    public final AssetBundleExportJobStatus jobStatus() {
        return AssetBundleExportJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link AssetBundleExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the export job.
     * @see AssetBundleExportJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The ARN of the export job.
     * </p>
     * 
     * @return The ARN of the export job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time that the export job was created.
     * </p>
     * 
     * @return The time that the export job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The ID of the export job.
     * </p>
     * 
     * @return The ID of the export job.
     */
    public final String assetBundleExportJobId() {
        return assetBundleExportJobId;
    }

    /**
     * <p>
     * The flag that determines the inclusion of resource dependencies in the returned asset bundle.
     * </p>
     * 
     * @return The flag that determines the inclusion of resource dependencies in the returned asset bundle.
     */
    public final Boolean includeAllDependencies() {
        return includeAllDependencies;
    }

    /**
     * <p>
     * The format for the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link AssetBundleExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The format for the export job.
     * @see AssetBundleExportFormat
     */
    public final AssetBundleExportFormat exportFormat() {
        return AssetBundleExportFormat.fromValue(exportFormat);
    }

    /**
     * <p>
     * The format for the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link AssetBundleExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The format for the export job.
     * @see AssetBundleExportFormat
     */
    public final String exportFormatAsString() {
        return exportFormat;
    }

    /**
     * <p>
     * The flag that determines the inclusion of permissions associated with each resource ARN.
     * </p>
     * 
     * @return The flag that determines the inclusion of permissions associated with each resource ARN.
     */
    public final Boolean includePermissions() {
        return includePermissions;
    }

    /**
     * <p>
     * The flag that determines the inclusion of tags associated with each resource ARN.
     * </p>
     * 
     * @return The flag that determines the inclusion of tags associated with each resource ARN.
     */
    public final Boolean includeTags() {
        return includeTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(assetBundleExportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(includeAllDependencies());
        hashCode = 31 * hashCode + Objects.hashCode(exportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(includeTags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleExportJobSummary)) {
            return false;
        }
        AssetBundleExportJobSummary other = (AssetBundleExportJobSummary) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(assetBundleExportJobId(), other.assetBundleExportJobId())
                && Objects.equals(includeAllDependencies(), other.includeAllDependencies())
                && Objects.equals(exportFormatAsString(), other.exportFormatAsString())
                && Objects.equals(includePermissions(), other.includePermissions())
                && Objects.equals(includeTags(), other.includeTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleExportJobSummary").add("JobStatus", jobStatusAsString()).add("Arn", arn())
                .add("CreatedTime", createdTime()).add("AssetBundleExportJobId", assetBundleExportJobId())
                .add("IncludeAllDependencies", includeAllDependencies()).add("ExportFormat", exportFormatAsString())
                .add("IncludePermissions", includePermissions()).add("IncludeTags", includeTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "AssetBundleExportJobId":
            return Optional.ofNullable(clazz.cast(assetBundleExportJobId()));
        case "IncludeAllDependencies":
            return Optional.ofNullable(clazz.cast(includeAllDependencies()));
        case "ExportFormat":
            return Optional.ofNullable(clazz.cast(exportFormatAsString()));
        case "IncludePermissions":
            return Optional.ofNullable(clazz.cast(includePermissions()));
        case "IncludeTags":
            return Optional.ofNullable(clazz.cast(includeTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("AssetBundleExportJobId", ASSET_BUNDLE_EXPORT_JOB_ID_FIELD);
        map.put("IncludeAllDependencies", INCLUDE_ALL_DEPENDENCIES_FIELD);
        map.put("ExportFormat", EXPORT_FORMAT_FIELD);
        map.put("IncludePermissions", INCLUDE_PERMISSIONS_FIELD);
        map.put("IncludeTags", INCLUDE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleExportJobSummary, T> g) {
        return obj -> g.apply((AssetBundleExportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleExportJobSummary> {
        /**
         * <p>
         * The current status of the export job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the export job.
         * @see AssetBundleExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the export job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the export job.
         * @see AssetBundleExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportJobStatus
         */
        Builder jobStatus(AssetBundleExportJobStatus jobStatus);

        /**
         * <p>
         * The ARN of the export job.
         * </p>
         * 
         * @param arn
         *        The ARN of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time that the export job was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The ID of the export job.
         * </p>
         * 
         * @param assetBundleExportJobId
         *        The ID of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetBundleExportJobId(String assetBundleExportJobId);

        /**
         * <p>
         * The flag that determines the inclusion of resource dependencies in the returned asset bundle.
         * </p>
         * 
         * @param includeAllDependencies
         *        The flag that determines the inclusion of resource dependencies in the returned asset bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAllDependencies(Boolean includeAllDependencies);

        /**
         * <p>
         * The format for the export job.
         * </p>
         * 
         * @param exportFormat
         *        The format for the export job.
         * @see AssetBundleExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportFormat
         */
        Builder exportFormat(String exportFormat);

        /**
         * <p>
         * The format for the export job.
         * </p>
         * 
         * @param exportFormat
         *        The format for the export job.
         * @see AssetBundleExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportFormat
         */
        Builder exportFormat(AssetBundleExportFormat exportFormat);

        /**
         * <p>
         * The flag that determines the inclusion of permissions associated with each resource ARN.
         * </p>
         * 
         * @param includePermissions
         *        The flag that determines the inclusion of permissions associated with each resource ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includePermissions(Boolean includePermissions);

        /**
         * <p>
         * The flag that determines the inclusion of tags associated with each resource ARN.
         * </p>
         * 
         * @param includeTags
         *        The flag that determines the inclusion of tags associated with each resource ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTags(Boolean includeTags);
    }

    static final class BuilderImpl implements Builder {
        private String jobStatus;

        private String arn;

        private Instant createdTime;

        private String assetBundleExportJobId;

        private Boolean includeAllDependencies;

        private String exportFormat;

        private Boolean includePermissions;

        private Boolean includeTags;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleExportJobSummary model) {
            jobStatus(model.jobStatus);
            arn(model.arn);
            createdTime(model.createdTime);
            assetBundleExportJobId(model.assetBundleExportJobId);
            includeAllDependencies(model.includeAllDependencies);
            exportFormat(model.exportFormat);
            includePermissions(model.includePermissions);
            includeTags(model.includeTags);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(AssetBundleExportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getAssetBundleExportJobId() {
            return assetBundleExportJobId;
        }

        public final void setAssetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
        }

        @Override
        public final Builder assetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
            return this;
        }

        public final Boolean getIncludeAllDependencies() {
            return includeAllDependencies;
        }

        public final void setIncludeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
        }

        @Override
        public final Builder includeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
            return this;
        }

        public final String getExportFormat() {
            return exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        public final Builder exportFormat(AssetBundleExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        public final Boolean getIncludePermissions() {
            return includePermissions;
        }

        public final void setIncludePermissions(Boolean includePermissions) {
            this.includePermissions = includePermissions;
        }

        @Override
        public final Builder includePermissions(Boolean includePermissions) {
            this.includePermissions = includePermissions;
            return this;
        }

        public final Boolean getIncludeTags() {
            return includeTags;
        }

        public final void setIncludeTags(Boolean includeTags) {
            this.includeTags = includeTags;
        }

        @Override
        public final Builder includeTags(Boolean includeTags) {
            this.includeTags = includeTags;
            return this;
        }

        @Override
        public AssetBundleExportJobSummary build() {
            return new AssetBundleExportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
