/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.SnapshotFileSheetSelectionScope;
import software.amazon.awssdk.services.quicksight.model.SnapshotFileSheetSelectionVisualIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotFileSheetSelection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotFileSheetSelection> {
    private static final SdkField<String> SHEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SheetId").getter(SnapshotFileSheetSelection.getter(SnapshotFileSheetSelection::sheetId)).setter(SnapshotFileSheetSelection.setter(Builder::sheetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetId").build()}).build();
    private static final SdkField<String> SELECTION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionScope").getter(SnapshotFileSheetSelection.getter(SnapshotFileSheetSelection::selectionScopeAsString)).setter(SnapshotFileSheetSelection.setter(Builder::selectionScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionScope").build()}).build();
    private static final SdkField<List<String>> VISUAL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VisualIds").getter(SnapshotFileSheetSelection.getter(SnapshotFileSheetSelection::visualIds)).setter(SnapshotFileSheetSelection.setter(Builder::visualIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_ID_FIELD, SELECTION_SCOPE_FIELD, VISUAL_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SheetId", SHEET_ID_FIELD);
            this.put("SelectionScope", SELECTION_SCOPE_FIELD);
            this.put("VisualIds", VISUAL_IDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sheetId;
    private final String selectionScope;
    private final List<String> visualIds;

    private SnapshotFileSheetSelection(BuilderImpl builder) {
        this.sheetId = builder.sheetId;
        this.selectionScope = builder.selectionScope;
        this.visualIds = builder.visualIds;
    }

    public final String sheetId() {
        return this.sheetId;
    }

    public final SnapshotFileSheetSelectionScope selectionScope() {
        return SnapshotFileSheetSelectionScope.fromValue(this.selectionScope);
    }

    public final String selectionScopeAsString() {
        return this.selectionScope;
    }

    public final boolean hasVisualIds() {
        return this.visualIds != null && !(this.visualIds instanceof SdkAutoConstructList);
    }

    public final List<String> visualIds() {
        return this.visualIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sheetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVisualIds() ? this.visualIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotFileSheetSelection)) {
            return false;
        }
        SnapshotFileSheetSelection other = (SnapshotFileSheetSelection)obj;
        return Objects.equals(this.sheetId(), other.sheetId()) && Objects.equals(this.selectionScopeAsString(), other.selectionScopeAsString()) && this.hasVisualIds() == other.hasVisualIds() && Objects.equals(this.visualIds(), other.visualIds());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotFileSheetSelection").add("SheetId", (Object)this.sheetId()).add("SelectionScope", (Object)this.selectionScopeAsString()).add("VisualIds", this.hasVisualIds() ? this.visualIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SheetId": {
                return Optional.ofNullable(clazz.cast(this.sheetId()));
            }
            case "SelectionScope": {
                return Optional.ofNullable(clazz.cast(this.selectionScopeAsString()));
            }
            case "VisualIds": {
                return Optional.ofNullable(clazz.cast(this.visualIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotFileSheetSelection, T> g) {
        return obj -> g.apply((SnapshotFileSheetSelection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sheetId;
        private String selectionScope;
        private List<String> visualIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotFileSheetSelection model) {
            this.sheetId(model.sheetId);
            this.selectionScope(model.selectionScope);
            this.visualIds(model.visualIds);
        }

        public final String getSheetId() {
            return this.sheetId;
        }

        public final void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        @Override
        public final Builder sheetId(String sheetId) {
            this.sheetId = sheetId;
            return this;
        }

        public final String getSelectionScope() {
            return this.selectionScope;
        }

        public final void setSelectionScope(String selectionScope) {
            this.selectionScope = selectionScope;
        }

        @Override
        public final Builder selectionScope(String selectionScope) {
            this.selectionScope = selectionScope;
            return this;
        }

        @Override
        public final Builder selectionScope(SnapshotFileSheetSelectionScope selectionScope) {
            this.selectionScope(selectionScope == null ? null : selectionScope.toString());
            return this;
        }

        public final Collection<String> getVisualIds() {
            if (this.visualIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.visualIds;
        }

        public final void setVisualIds(Collection<String> visualIds) {
            this.visualIds = SnapshotFileSheetSelectionVisualIdListCopier.copy(visualIds);
        }

        @Override
        public final Builder visualIds(Collection<String> visualIds) {
            this.visualIds = SnapshotFileSheetSelectionVisualIdListCopier.copy(visualIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visualIds(String ... visualIds) {
            this.visualIds(Arrays.asList(visualIds));
            return this;
        }

        public SnapshotFileSheetSelection build() {
            return new SnapshotFileSheetSelection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotFileSheetSelection> {
        public Builder sheetId(String var1);

        public Builder selectionScope(String var1);

        public Builder selectionScope(SnapshotFileSheetSelectionScope var1);

        public Builder visualIds(Collection<String> var1);

        public Builder visualIds(String ... var1);
    }
}

