/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.SheetImageTooltipText;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SheetImageTooltipConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SheetImageTooltipConfiguration> {
    private static final SdkField<SheetImageTooltipText> TOOLTIP_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TooltipText").getter(SheetImageTooltipConfiguration.getter(SheetImageTooltipConfiguration::tooltipText)).setter(SheetImageTooltipConfiguration.setter(Builder::tooltipText)).constructor(SheetImageTooltipText::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipText").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(SheetImageTooltipConfiguration.getter(SheetImageTooltipConfiguration::visibilityAsString)).setter(SheetImageTooltipConfiguration.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOLTIP_TEXT_FIELD, VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TooltipText", TOOLTIP_TEXT_FIELD);
            this.put("Visibility", VISIBILITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SheetImageTooltipText tooltipText;
    private final String visibility;

    private SheetImageTooltipConfiguration(BuilderImpl builder) {
        this.tooltipText = builder.tooltipText;
        this.visibility = builder.visibility;
    }

    public final SheetImageTooltipText tooltipText() {
        return this.tooltipText;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltipText());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetImageTooltipConfiguration)) {
            return false;
        }
        SheetImageTooltipConfiguration other = (SheetImageTooltipConfiguration)obj;
        return Objects.equals(this.tooltipText(), other.tooltipText()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SheetImageTooltipConfiguration").add("TooltipText", (Object)this.tooltipText()).add("Visibility", (Object)this.visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TooltipText": {
                return Optional.ofNullable(clazz.cast(this.tooltipText()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SheetImageTooltipConfiguration, T> g) {
        return obj -> g.apply((SheetImageTooltipConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SheetImageTooltipText tooltipText;
        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetImageTooltipConfiguration model) {
            this.tooltipText(model.tooltipText);
            this.visibility(model.visibility);
        }

        public final SheetImageTooltipText.Builder getTooltipText() {
            return this.tooltipText != null ? this.tooltipText.toBuilder() : null;
        }

        public final void setTooltipText(SheetImageTooltipText.BuilderImpl tooltipText) {
            this.tooltipText = tooltipText != null ? tooltipText.build() : null;
        }

        @Override
        public final Builder tooltipText(SheetImageTooltipText tooltipText) {
            this.tooltipText = tooltipText;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public SheetImageTooltipConfiguration build() {
            return new SheetImageTooltipConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SheetImageTooltipConfiguration> {
        public Builder tooltipText(SheetImageTooltipText var1);

        default public Builder tooltipText(Consumer<SheetImageTooltipText.Builder> tooltipText) {
            return this.tooltipText((SheetImageTooltipText)((SheetImageTooltipText.Builder)SheetImageTooltipText.builder().applyMutation(tooltipText)).build());
        }

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);
    }
}

