/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.InsightConfiguration;
import software.amazon.awssdk.services.quicksight.model.VisualCustomAction;
import software.amazon.awssdk.services.quicksight.model.VisualCustomActionListCopier;
import software.amazon.awssdk.services.quicksight.model.VisualSubtitleLabelOptions;
import software.amazon.awssdk.services.quicksight.model.VisualTitleLabelOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightVisual
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VisualId").getter(InsightVisual.getter(InsightVisual::visualId)).setter(InsightVisual.setter(Builder::visualId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()}).build();
    private static final SdkField<VisualTitleLabelOptions> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Title").getter(InsightVisual.getter(InsightVisual::title)).setter(InsightVisual.setter(Builder::title)).constructor(VisualTitleLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<VisualSubtitleLabelOptions> SUBTITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subtitle").getter(InsightVisual.getter(InsightVisual::subtitle)).setter(InsightVisual.setter(Builder::subtitle)).constructor(VisualSubtitleLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtitle").build()}).build();
    private static final SdkField<InsightConfiguration> INSIGHT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InsightConfiguration").getter(InsightVisual.getter(InsightVisual::insightConfiguration)).setter(InsightVisual.setter(Builder::insightConfiguration)).constructor(InsightConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightConfiguration").build()}).build();
    private static final SdkField<List<VisualCustomAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(InsightVisual.getter(InsightVisual::actions)).setter(InsightVisual.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VisualCustomAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_SET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetIdentifier").getter(InsightVisual.getter(InsightVisual::dataSetIdentifier)).setter(InsightVisual.setter(Builder::dataSetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD, TITLE_FIELD, SUBTITLE_FIELD, INSIGHT_CONFIGURATION_FIELD, ACTIONS_FIELD, DATA_SET_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String visualId;
    private final VisualTitleLabelOptions title;
    private final VisualSubtitleLabelOptions subtitle;
    private final InsightConfiguration insightConfiguration;
    private final List<VisualCustomAction> actions;
    private final String dataSetIdentifier;

    private InsightVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.insightConfiguration = builder.insightConfiguration;
        this.actions = builder.actions;
        this.dataSetIdentifier = builder.dataSetIdentifier;
    }

    public final String visualId() {
        return this.visualId;
    }

    public final VisualTitleLabelOptions title() {
        return this.title;
    }

    public final VisualSubtitleLabelOptions subtitle() {
        return this.subtitle;
    }

    public final InsightConfiguration insightConfiguration() {
        return this.insightConfiguration;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<VisualCustomAction> actions() {
        return this.actions;
    }

    public final String dataSetIdentifier() {
        return this.dataSetIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visualId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightVisual)) {
            return false;
        }
        InsightVisual other = (InsightVisual)obj;
        return Objects.equals(this.visualId(), other.visualId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.subtitle(), other.subtitle()) && Objects.equals(this.insightConfiguration(), other.insightConfiguration()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.dataSetIdentifier(), other.dataSetIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"InsightVisual").add("VisualId", (Object)this.visualId()).add("Title", (Object)this.title()).add("Subtitle", (Object)this.subtitle()).add("InsightConfiguration", (Object)this.insightConfiguration()).add("Actions", this.hasActions() ? this.actions() : null).add("DataSetIdentifier", (Object)this.dataSetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VisualId": {
                return Optional.ofNullable(clazz.cast(this.visualId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Subtitle": {
                return Optional.ofNullable(clazz.cast(this.subtitle()));
            }
            case "InsightConfiguration": {
                return Optional.ofNullable(clazz.cast(this.insightConfiguration()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "DataSetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataSetIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightVisual, T> g) {
        return obj -> g.apply((InsightVisual)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visualId;
        private VisualTitleLabelOptions title;
        private VisualSubtitleLabelOptions subtitle;
        private InsightConfiguration insightConfiguration;
        private List<VisualCustomAction> actions = DefaultSdkAutoConstructList.getInstance();
        private String dataSetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightVisual model) {
            this.visualId(model.visualId);
            this.title(model.title);
            this.subtitle(model.subtitle);
            this.insightConfiguration(model.insightConfiguration);
            this.actions(model.actions);
            this.dataSetIdentifier(model.dataSetIdentifier);
        }

        public final String getVisualId() {
            return this.visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final VisualTitleLabelOptions.Builder getTitle() {
            return this.title != null ? this.title.toBuilder() : null;
        }

        public final void setTitle(VisualTitleLabelOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(VisualTitleLabelOptions title) {
            this.title = title;
            return this;
        }

        public final VisualSubtitleLabelOptions.Builder getSubtitle() {
            return this.subtitle != null ? this.subtitle.toBuilder() : null;
        }

        public final void setSubtitle(VisualSubtitleLabelOptions.BuilderImpl subtitle) {
            this.subtitle = subtitle != null ? subtitle.build() : null;
        }

        @Override
        public final Builder subtitle(VisualSubtitleLabelOptions subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final InsightConfiguration.Builder getInsightConfiguration() {
            return this.insightConfiguration != null ? this.insightConfiguration.toBuilder() : null;
        }

        public final void setInsightConfiguration(InsightConfiguration.BuilderImpl insightConfiguration) {
            this.insightConfiguration = insightConfiguration != null ? insightConfiguration.build() : null;
        }

        @Override
        public final Builder insightConfiguration(InsightConfiguration insightConfiguration) {
            this.insightConfiguration = insightConfiguration;
            return this;
        }

        public final List<VisualCustomAction.Builder> getActions() {
            List<VisualCustomAction.Builder> result = VisualCustomActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<VisualCustomAction.BuilderImpl> actions) {
            this.actions = VisualCustomActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<VisualCustomAction> actions) {
            this.actions = VisualCustomActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VisualCustomAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<VisualCustomAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (VisualCustomAction)((VisualCustomAction.Builder)VisualCustomAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataSetIdentifier() {
            return this.dataSetIdentifier;
        }

        public final void setDataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
        }

        @Override
        public final Builder dataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
            return this;
        }

        public InsightVisual build() {
            return new InsightVisual(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightVisual> {
        public Builder visualId(String var1);

        public Builder title(VisualTitleLabelOptions var1);

        default public Builder title(Consumer<VisualTitleLabelOptions.Builder> title) {
            return this.title((VisualTitleLabelOptions)((VisualTitleLabelOptions.Builder)VisualTitleLabelOptions.builder().applyMutation(title)).build());
        }

        public Builder subtitle(VisualSubtitleLabelOptions var1);

        default public Builder subtitle(Consumer<VisualSubtitleLabelOptions.Builder> subtitle) {
            return this.subtitle((VisualSubtitleLabelOptions)((VisualSubtitleLabelOptions.Builder)VisualSubtitleLabelOptions.builder().applyMutation(subtitle)).build());
        }

        public Builder insightConfiguration(InsightConfiguration var1);

        default public Builder insightConfiguration(Consumer<InsightConfiguration.Builder> insightConfiguration) {
            return this.insightConfiguration((InsightConfiguration)((InsightConfiguration.Builder)InsightConfiguration.builder().applyMutation(insightConfiguration)).build());
        }

        public Builder actions(Collection<VisualCustomAction> var1);

        public Builder actions(VisualCustomAction ... var1);

        public Builder actions(Consumer<VisualCustomAction.Builder> ... var1);

        public Builder dataSetIdentifier(String var1);
    }
}

