/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AggregationFunction;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnTooltipItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnTooltipItem> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(ColumnTooltipItem.getter(ColumnTooltipItem::column)).setter(ColumnTooltipItem.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(ColumnTooltipItem.getter(ColumnTooltipItem::label)).setter(ColumnTooltipItem.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(ColumnTooltipItem.getter(ColumnTooltipItem::visibilityAsString)).setter(ColumnTooltipItem.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<AggregationFunction> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Aggregation").getter(ColumnTooltipItem.getter(ColumnTooltipItem::aggregation)).setter(ColumnTooltipItem.setter(Builder::aggregation)).constructor(AggregationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, LABEL_FIELD, VISIBILITY_FIELD, AGGREGATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ColumnIdentifier column;
    private final String label;
    private final String visibility;
    private final AggregationFunction aggregation;

    private ColumnTooltipItem(BuilderImpl builder) {
        this.column = builder.column;
        this.label = builder.label;
        this.visibility = builder.visibility;
        this.aggregation = builder.aggregation;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final String label() {
        return this.label;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final AggregationFunction aggregation() {
        return this.aggregation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnTooltipItem)) {
            return false;
        }
        ColumnTooltipItem other = (ColumnTooltipItem)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.aggregation(), other.aggregation());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnTooltipItem").add("Column", (Object)this.column()).add("Label", (Object)this.label()).add("Visibility", (Object)this.visibilityAsString()).add("Aggregation", (Object)this.aggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "Aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnTooltipItem, T> g) {
        return obj -> g.apply((ColumnTooltipItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColumnIdentifier column;
        private String label;
        private String visibility;
        private AggregationFunction aggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnTooltipItem model) {
            this.column(model.column);
            this.label(model.label);
            this.visibility(model.visibility);
            this.aggregation(model.aggregation);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final AggregationFunction.Builder getAggregation() {
            return this.aggregation != null ? this.aggregation.toBuilder() : null;
        }

        public final void setAggregation(AggregationFunction.BuilderImpl aggregation) {
            this.aggregation = aggregation != null ? aggregation.build() : null;
        }

        @Override
        public final Builder aggregation(AggregationFunction aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        public ColumnTooltipItem build() {
            return new ColumnTooltipItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnTooltipItem> {
        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder label(String var1);

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder aggregation(AggregationFunction var1);

        default public Builder aggregation(Consumer<AggregationFunction.Builder> aggregation) {
            return this.aggregation((AggregationFunction)((AggregationFunction.Builder)AggregationFunction.builder().applyMutation(aggregation)).build());
        }
    }
}

