/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.Font;
import software.amazon.awssdk.services.quicksight.model.FontListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Typography
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Typography> {
    private static final SdkField<List<Font>> FONT_FAMILIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FontFamilies").getter(Typography.getter(Typography::fontFamilies)).setter(Typography.setter(Builder::fontFamilies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontFamilies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Font::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_FAMILIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Font> fontFamilies;

    private Typography(BuilderImpl builder) {
        this.fontFamilies = builder.fontFamilies;
    }

    public final boolean hasFontFamilies() {
        return this.fontFamilies != null && !(this.fontFamilies instanceof SdkAutoConstructList);
    }

    public final List<Font> fontFamilies() {
        return this.fontFamilies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFontFamilies() ? this.fontFamilies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Typography)) {
            return false;
        }
        Typography other = (Typography)obj;
        return this.hasFontFamilies() == other.hasFontFamilies() && Objects.equals(this.fontFamilies(), other.fontFamilies());
    }

    public final String toString() {
        return ToString.builder((String)"Typography").add("FontFamilies", this.hasFontFamilies() ? this.fontFamilies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FontFamilies": {
                return Optional.ofNullable(clazz.cast(this.fontFamilies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Typography, T> g) {
        return obj -> g.apply((Typography)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Font> fontFamilies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Typography model) {
            this.fontFamilies(model.fontFamilies);
        }

        public final List<Font.Builder> getFontFamilies() {
            List<Font.Builder> result = FontListCopier.copyToBuilder(this.fontFamilies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFontFamilies(Collection<Font.BuilderImpl> fontFamilies) {
            this.fontFamilies = FontListCopier.copyFromBuilder(fontFamilies);
        }

        @Override
        public final Builder fontFamilies(Collection<Font> fontFamilies) {
            this.fontFamilies = FontListCopier.copy(fontFamilies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fontFamilies(Font ... fontFamilies) {
            this.fontFamilies(Arrays.asList(fontFamilies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fontFamilies(Consumer<Font.Builder> ... fontFamilies) {
            this.fontFamilies(Stream.of(fontFamilies).map(c -> (Font)((Font.Builder)Font.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Typography build() {
            return new Typography(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Typography> {
        public Builder fontFamilies(Collection<Font> var1);

        public Builder fontFamilies(Font ... var1);

        public Builder fontFamilies(Consumer<Font.Builder> ... var1);
    }
}

