/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A sankey diagram.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html">Using
 * Sankey diagrams</a> in the <i>Amazon QuickSight User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SankeyDiagramVisual implements SdkPojo, Serializable,
        ToCopyableBuilder<SankeyDiagramVisual.Builder, SankeyDiagramVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualId").getter(getter(SankeyDiagramVisual::visualId)).setter(setter(Builder::visualId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()).build();

    private static final SdkField<VisualTitleLabelOptions> TITLE_FIELD = SdkField
            .<VisualTitleLabelOptions> builder(MarshallingType.SDK_POJO).memberName("Title")
            .getter(getter(SankeyDiagramVisual::title)).setter(setter(Builder::title))
            .constructor(VisualTitleLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<VisualSubtitleLabelOptions> SUBTITLE_FIELD = SdkField
            .<VisualSubtitleLabelOptions> builder(MarshallingType.SDK_POJO).memberName("Subtitle")
            .getter(getter(SankeyDiagramVisual::subtitle)).setter(setter(Builder::subtitle))
            .constructor(VisualSubtitleLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtitle").build()).build();

    private static final SdkField<SankeyDiagramChartConfiguration> CHART_CONFIGURATION_FIELD = SdkField
            .<SankeyDiagramChartConfiguration> builder(MarshallingType.SDK_POJO).memberName("ChartConfiguration")
            .getter(getter(SankeyDiagramVisual::chartConfiguration)).setter(setter(Builder::chartConfiguration))
            .constructor(SankeyDiagramChartConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChartConfiguration").build())
            .build();

    private static final SdkField<List<VisualCustomAction>> ACTIONS_FIELD = SdkField
            .<List<VisualCustomAction>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(SankeyDiagramVisual::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VisualCustomAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(VisualCustomAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD, TITLE_FIELD,
            SUBTITLE_FIELD, CHART_CONFIGURATION_FIELD, ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String visualId;

    private final VisualTitleLabelOptions title;

    private final VisualSubtitleLabelOptions subtitle;

    private final SankeyDiagramChartConfiguration chartConfiguration;

    private final List<VisualCustomAction> actions;

    private SankeyDiagramVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.chartConfiguration = builder.chartConfiguration;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or
     * analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
     * </p>
     * 
     * @return The unique identifier of a visual. This identifier must be unique within the context of a dashboard,
     *         template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
     */
    public final String visualId() {
        return visualId;
    }

    /**
     * <p>
     * The title that is displayed on the visual.
     * </p>
     * 
     * @return The title that is displayed on the visual.
     */
    public final VisualTitleLabelOptions title() {
        return title;
    }

    /**
     * <p>
     * The subtitle that is displayed on the visual.
     * </p>
     * 
     * @return The subtitle that is displayed on the visual.
     */
    public final VisualSubtitleLabelOptions subtitle() {
        return subtitle;
    }

    /**
     * <p>
     * The configuration of a sankey diagram.
     * </p>
     * 
     * @return The configuration of a sankey diagram.
     */
    public final SankeyDiagramChartConfiguration chartConfiguration() {
        return chartConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of custom actions that are configured for a visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The list of custom actions that are configured for a visual.
     */
    public final List<VisualCustomAction> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visualId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(chartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SankeyDiagramVisual)) {
            return false;
        }
        SankeyDiagramVisual other = (SankeyDiagramVisual) obj;
        return Objects.equals(visualId(), other.visualId()) && Objects.equals(title(), other.title())
                && Objects.equals(subtitle(), other.subtitle())
                && Objects.equals(chartConfiguration(), other.chartConfiguration()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SankeyDiagramVisual").add("VisualId", visualId()).add("Title", title())
                .add("Subtitle", subtitle()).add("ChartConfiguration", chartConfiguration())
                .add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VisualId":
            return Optional.ofNullable(clazz.cast(visualId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Subtitle":
            return Optional.ofNullable(clazz.cast(subtitle()));
        case "ChartConfiguration":
            return Optional.ofNullable(clazz.cast(chartConfiguration()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SankeyDiagramVisual, T> g) {
        return obj -> g.apply((SankeyDiagramVisual) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SankeyDiagramVisual> {
        /**
         * <p>
         * The unique identifier of a visual. This identifier must be unique within the context of a dashboard,
         * template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         * </p>
         * 
         * @param visualId
         *        The unique identifier of a visual. This identifier must be unique within the context of a dashboard,
         *        template, or analysis. Two dashboards, analyses, or templates can have visuals with the same
         *        identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualId(String visualId);

        /**
         * <p>
         * The title that is displayed on the visual.
         * </p>
         * 
         * @param title
         *        The title that is displayed on the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(VisualTitleLabelOptions title);

        /**
         * <p>
         * The title that is displayed on the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualTitleLabelOptions.Builder} avoiding
         * the need to create one manually via {@link VisualTitleLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualTitleLabelOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #title(VisualTitleLabelOptions)}.
         * 
         * @param title
         *        a consumer that will call methods on {@link VisualTitleLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(VisualTitleLabelOptions)
         */
        default Builder title(Consumer<VisualTitleLabelOptions.Builder> title) {
            return title(VisualTitleLabelOptions.builder().applyMutation(title).build());
        }

        /**
         * <p>
         * The subtitle that is displayed on the visual.
         * </p>
         * 
         * @param subtitle
         *        The subtitle that is displayed on the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitle(VisualSubtitleLabelOptions subtitle);

        /**
         * <p>
         * The subtitle that is displayed on the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualSubtitleLabelOptions.Builder}
         * avoiding the need to create one manually via {@link VisualSubtitleLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualSubtitleLabelOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #subtitle(VisualSubtitleLabelOptions)}.
         * 
         * @param subtitle
         *        a consumer that will call methods on {@link VisualSubtitleLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subtitle(VisualSubtitleLabelOptions)
         */
        default Builder subtitle(Consumer<VisualSubtitleLabelOptions.Builder> subtitle) {
            return subtitle(VisualSubtitleLabelOptions.builder().applyMutation(subtitle).build());
        }

        /**
         * <p>
         * The configuration of a sankey diagram.
         * </p>
         * 
         * @param chartConfiguration
         *        The configuration of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chartConfiguration(SankeyDiagramChartConfiguration chartConfiguration);

        /**
         * <p>
         * The configuration of a sankey diagram.
         * </p>
         * This is a convenience method that creates an instance of the {@link SankeyDiagramChartConfiguration.Builder}
         * avoiding the need to create one manually via {@link SankeyDiagramChartConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SankeyDiagramChartConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #chartConfiguration(SankeyDiagramChartConfiguration)}.
         * 
         * @param chartConfiguration
         *        a consumer that will call methods on {@link SankeyDiagramChartConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chartConfiguration(SankeyDiagramChartConfiguration)
         */
        default Builder chartConfiguration(Consumer<SankeyDiagramChartConfiguration.Builder> chartConfiguration) {
            return chartConfiguration(SankeyDiagramChartConfiguration.builder().applyMutation(chartConfiguration).build());
        }

        /**
         * <p>
         * The list of custom actions that are configured for a visual.
         * </p>
         * 
         * @param actions
         *        The list of custom actions that are configured for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<VisualCustomAction> actions);

        /**
         * <p>
         * The list of custom actions that are configured for a visual.
         * </p>
         * 
         * @param actions
         *        The list of custom actions that are configured for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(VisualCustomAction... actions);

        /**
         * <p>
         * The list of custom actions that are configured for a visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.VisualCustomAction.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.VisualCustomAction#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.VisualCustomAction.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<VisualCustomAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.VisualCustomAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<VisualCustomAction>)
         */
        Builder actions(Consumer<VisualCustomAction.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private String visualId;

        private VisualTitleLabelOptions title;

        private VisualSubtitleLabelOptions subtitle;

        private SankeyDiagramChartConfiguration chartConfiguration;

        private List<VisualCustomAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SankeyDiagramVisual model) {
            visualId(model.visualId);
            title(model.title);
            subtitle(model.subtitle);
            chartConfiguration(model.chartConfiguration);
            actions(model.actions);
        }

        public final String getVisualId() {
            return visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final VisualTitleLabelOptions.Builder getTitle() {
            return title != null ? title.toBuilder() : null;
        }

        public final void setTitle(VisualTitleLabelOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(VisualTitleLabelOptions title) {
            this.title = title;
            return this;
        }

        public final VisualSubtitleLabelOptions.Builder getSubtitle() {
            return subtitle != null ? subtitle.toBuilder() : null;
        }

        public final void setSubtitle(VisualSubtitleLabelOptions.BuilderImpl subtitle) {
            this.subtitle = subtitle != null ? subtitle.build() : null;
        }

        @Override
        public final Builder subtitle(VisualSubtitleLabelOptions subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final SankeyDiagramChartConfiguration.Builder getChartConfiguration() {
            return chartConfiguration != null ? chartConfiguration.toBuilder() : null;
        }

        public final void setChartConfiguration(SankeyDiagramChartConfiguration.BuilderImpl chartConfiguration) {
            this.chartConfiguration = chartConfiguration != null ? chartConfiguration.build() : null;
        }

        @Override
        public final Builder chartConfiguration(SankeyDiagramChartConfiguration chartConfiguration) {
            this.chartConfiguration = chartConfiguration;
            return this;
        }

        public final List<VisualCustomAction.Builder> getActions() {
            List<VisualCustomAction.Builder> result = VisualCustomActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<VisualCustomAction.BuilderImpl> actions) {
            this.actions = VisualCustomActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<VisualCustomAction> actions) {
            this.actions = VisualCustomActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VisualCustomAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<VisualCustomAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> VisualCustomAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SankeyDiagramVisual build() {
            return new SankeyDiagramVisual(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
