/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An element within a free-form layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FreeFormLayoutElement implements SdkPojo, Serializable,
        ToCopyableBuilder<FreeFormLayoutElement.Builder, FreeFormLayoutElement> {
    private static final SdkField<String> ELEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElementId").getter(getter(FreeFormLayoutElement::elementId)).setter(setter(Builder::elementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElementId").build()).build();

    private static final SdkField<String> ELEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElementType").getter(getter(FreeFormLayoutElement::elementTypeAsString))
            .setter(setter(Builder::elementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElementType").build()).build();

    private static final SdkField<String> X_AXIS_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XAxisLocation").getter(getter(FreeFormLayoutElement::xAxisLocation))
            .setter(setter(Builder::xAxisLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisLocation").build()).build();

    private static final SdkField<String> Y_AXIS_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("YAxisLocation").getter(getter(FreeFormLayoutElement::yAxisLocation))
            .setter(setter(Builder::yAxisLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAxisLocation").build()).build();

    private static final SdkField<String> WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Width")
            .getter(getter(FreeFormLayoutElement::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()).build();

    private static final SdkField<String> HEIGHT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Height")
            .getter(getter(FreeFormLayoutElement::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(FreeFormLayoutElement::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<List<SheetElementRenderingRule>> RENDERING_RULES_FIELD = SdkField
            .<List<SheetElementRenderingRule>> builder(MarshallingType.LIST)
            .memberName("RenderingRules")
            .getter(getter(FreeFormLayoutElement::renderingRules))
            .setter(setter(Builder::renderingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenderingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SheetElementRenderingRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(SheetElementRenderingRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FreeFormLayoutElementBorderStyle> BORDER_STYLE_FIELD = SdkField
            .<FreeFormLayoutElementBorderStyle> builder(MarshallingType.SDK_POJO).memberName("BorderStyle")
            .getter(getter(FreeFormLayoutElement::borderStyle)).setter(setter(Builder::borderStyle))
            .constructor(FreeFormLayoutElementBorderStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderStyle").build()).build();

    private static final SdkField<FreeFormLayoutElementBorderStyle> SELECTED_BORDER_STYLE_FIELD = SdkField
            .<FreeFormLayoutElementBorderStyle> builder(MarshallingType.SDK_POJO).memberName("SelectedBorderStyle")
            .getter(getter(FreeFormLayoutElement::selectedBorderStyle)).setter(setter(Builder::selectedBorderStyle))
            .constructor(FreeFormLayoutElementBorderStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedBorderStyle").build())
            .build();

    private static final SdkField<FreeFormLayoutElementBackgroundStyle> BACKGROUND_STYLE_FIELD = SdkField
            .<FreeFormLayoutElementBackgroundStyle> builder(MarshallingType.SDK_POJO).memberName("BackgroundStyle")
            .getter(getter(FreeFormLayoutElement::backgroundStyle)).setter(setter(Builder::backgroundStyle))
            .constructor(FreeFormLayoutElementBackgroundStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundStyle").build()).build();

    private static final SdkField<LoadingAnimation> LOADING_ANIMATION_FIELD = SdkField
            .<LoadingAnimation> builder(MarshallingType.SDK_POJO).memberName("LoadingAnimation")
            .getter(getter(FreeFormLayoutElement::loadingAnimation)).setter(setter(Builder::loadingAnimation))
            .constructor(LoadingAnimation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadingAnimation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_ID_FIELD,
            ELEMENT_TYPE_FIELD, X_AXIS_LOCATION_FIELD, Y_AXIS_LOCATION_FIELD, WIDTH_FIELD, HEIGHT_FIELD, VISIBILITY_FIELD,
            RENDERING_RULES_FIELD, BORDER_STYLE_FIELD, SELECTED_BORDER_STYLE_FIELD, BACKGROUND_STYLE_FIELD,
            LOADING_ANIMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String elementId;

    private final String elementType;

    private final String xAxisLocation;

    private final String yAxisLocation;

    private final String width;

    private final String height;

    private final String visibility;

    private final List<SheetElementRenderingRule> renderingRules;

    private final FreeFormLayoutElementBorderStyle borderStyle;

    private final FreeFormLayoutElementBorderStyle selectedBorderStyle;

    private final FreeFormLayoutElementBackgroundStyle backgroundStyle;

    private final LoadingAnimation loadingAnimation;

    private FreeFormLayoutElement(BuilderImpl builder) {
        this.elementId = builder.elementId;
        this.elementType = builder.elementType;
        this.xAxisLocation = builder.xAxisLocation;
        this.yAxisLocation = builder.yAxisLocation;
        this.width = builder.width;
        this.height = builder.height;
        this.visibility = builder.visibility;
        this.renderingRules = builder.renderingRules;
        this.borderStyle = builder.borderStyle;
        this.selectedBorderStyle = builder.selectedBorderStyle;
        this.backgroundStyle = builder.backgroundStyle;
        this.loadingAnimation = builder.loadingAnimation;
    }

    /**
     * <p>
     * A unique identifier for an element within a free-form layout.
     * </p>
     * 
     * @return A unique identifier for an element within a free-form layout.
     */
    public final String elementId() {
        return elementId;
    }

    /**
     * <p>
     * The type of element.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #elementType} will
     * return {@link LayoutElementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #elementTypeAsString}.
     * </p>
     * 
     * @return The type of element.
     * @see LayoutElementType
     */
    public final LayoutElementType elementType() {
        return LayoutElementType.fromValue(elementType);
    }

    /**
     * <p>
     * The type of element.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #elementType} will
     * return {@link LayoutElementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #elementTypeAsString}.
     * </p>
     * 
     * @return The type of element.
     * @see LayoutElementType
     */
    public final String elementTypeAsString() {
        return elementType;
    }

    /**
     * <p>
     * The x-axis coordinate of the element.
     * </p>
     * 
     * @return The x-axis coordinate of the element.
     */
    public final String xAxisLocation() {
        return xAxisLocation;
    }

    /**
     * <p>
     * The y-axis coordinate of the element.
     * </p>
     * 
     * @return The y-axis coordinate of the element.
     */
    public final String yAxisLocation() {
        return yAxisLocation;
    }

    /**
     * <p>
     * The width of an element within a free-form layout.
     * </p>
     * 
     * @return The width of an element within a free-form layout.
     */
    public final String width() {
        return width;
    }

    /**
     * <p>
     * The height of an element within a free-form layout.
     * </p>
     * 
     * @return The height of an element within a free-form layout.
     */
    public final String height() {
        return height;
    }

    /**
     * <p>
     * The visibility of an element within a free-form layout.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of an element within a free-form layout.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of an element within a free-form layout.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of an element within a free-form layout.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * For responses, this returns true if the service returned a value for the RenderingRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRenderingRules() {
        return renderingRules != null && !(renderingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rendering rules that determine when an element should be displayed within a free-form layout.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRenderingRules} method.
     * </p>
     * 
     * @return The rendering rules that determine when an element should be displayed within a free-form layout.
     */
    public final List<SheetElementRenderingRule> renderingRules() {
        return renderingRules;
    }

    /**
     * <p>
     * The border style configuration of a free-form layout element.
     * </p>
     * 
     * @return The border style configuration of a free-form layout element.
     */
    public final FreeFormLayoutElementBorderStyle borderStyle() {
        return borderStyle;
    }

    /**
     * <p>
     * The border style configuration of a free-form layout element. This border style is used when the element is
     * selected.
     * </p>
     * 
     * @return The border style configuration of a free-form layout element. This border style is used when the element
     *         is selected.
     */
    public final FreeFormLayoutElementBorderStyle selectedBorderStyle() {
        return selectedBorderStyle;
    }

    /**
     * <p>
     * The background style configuration of a free-form layout element.
     * </p>
     * 
     * @return The background style configuration of a free-form layout element.
     */
    public final FreeFormLayoutElementBackgroundStyle backgroundStyle() {
        return backgroundStyle;
    }

    /**
     * <p>
     * The loading animation configuration of a free-form layout element.
     * </p>
     * 
     * @return The loading animation configuration of a free-form layout element.
     */
    public final LoadingAnimation loadingAnimation() {
        return loadingAnimation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elementId());
        hashCode = 31 * hashCode + Objects.hashCode(elementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(xAxisLocation());
        hashCode = 31 * hashCode + Objects.hashCode(yAxisLocation());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRenderingRules() ? renderingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(borderStyle());
        hashCode = 31 * hashCode + Objects.hashCode(selectedBorderStyle());
        hashCode = 31 * hashCode + Objects.hashCode(backgroundStyle());
        hashCode = 31 * hashCode + Objects.hashCode(loadingAnimation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeFormLayoutElement)) {
            return false;
        }
        FreeFormLayoutElement other = (FreeFormLayoutElement) obj;
        return Objects.equals(elementId(), other.elementId())
                && Objects.equals(elementTypeAsString(), other.elementTypeAsString())
                && Objects.equals(xAxisLocation(), other.xAxisLocation())
                && Objects.equals(yAxisLocation(), other.yAxisLocation()) && Objects.equals(width(), other.width())
                && Objects.equals(height(), other.height()) && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && hasRenderingRules() == other.hasRenderingRules() && Objects.equals(renderingRules(), other.renderingRules())
                && Objects.equals(borderStyle(), other.borderStyle())
                && Objects.equals(selectedBorderStyle(), other.selectedBorderStyle())
                && Objects.equals(backgroundStyle(), other.backgroundStyle())
                && Objects.equals(loadingAnimation(), other.loadingAnimation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FreeFormLayoutElement").add("ElementId", elementId()).add("ElementType", elementTypeAsString())
                .add("XAxisLocation", xAxisLocation()).add("YAxisLocation", yAxisLocation()).add("Width", width())
                .add("Height", height()).add("Visibility", visibilityAsString())
                .add("RenderingRules", hasRenderingRules() ? renderingRules() : null).add("BorderStyle", borderStyle())
                .add("SelectedBorderStyle", selectedBorderStyle()).add("BackgroundStyle", backgroundStyle())
                .add("LoadingAnimation", loadingAnimation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElementId":
            return Optional.ofNullable(clazz.cast(elementId()));
        case "ElementType":
            return Optional.ofNullable(clazz.cast(elementTypeAsString()));
        case "XAxisLocation":
            return Optional.ofNullable(clazz.cast(xAxisLocation()));
        case "YAxisLocation":
            return Optional.ofNullable(clazz.cast(yAxisLocation()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "RenderingRules":
            return Optional.ofNullable(clazz.cast(renderingRules()));
        case "BorderStyle":
            return Optional.ofNullable(clazz.cast(borderStyle()));
        case "SelectedBorderStyle":
            return Optional.ofNullable(clazz.cast(selectedBorderStyle()));
        case "BackgroundStyle":
            return Optional.ofNullable(clazz.cast(backgroundStyle()));
        case "LoadingAnimation":
            return Optional.ofNullable(clazz.cast(loadingAnimation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FreeFormLayoutElement, T> g) {
        return obj -> g.apply((FreeFormLayoutElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FreeFormLayoutElement> {
        /**
         * <p>
         * A unique identifier for an element within a free-form layout.
         * </p>
         * 
         * @param elementId
         *        A unique identifier for an element within a free-form layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elementId(String elementId);

        /**
         * <p>
         * The type of element.
         * </p>
         * 
         * @param elementType
         *        The type of element.
         * @see LayoutElementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayoutElementType
         */
        Builder elementType(String elementType);

        /**
         * <p>
         * The type of element.
         * </p>
         * 
         * @param elementType
         *        The type of element.
         * @see LayoutElementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayoutElementType
         */
        Builder elementType(LayoutElementType elementType);

        /**
         * <p>
         * The x-axis coordinate of the element.
         * </p>
         * 
         * @param xAxisLocation
         *        The x-axis coordinate of the element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxisLocation(String xAxisLocation);

        /**
         * <p>
         * The y-axis coordinate of the element.
         * </p>
         * 
         * @param yAxisLocation
         *        The y-axis coordinate of the element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAxisLocation(String yAxisLocation);

        /**
         * <p>
         * The width of an element within a free-form layout.
         * </p>
         * 
         * @param width
         *        The width of an element within a free-form layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(String width);

        /**
         * <p>
         * The height of an element within a free-form layout.
         * </p>
         * 
         * @param height
         *        The height of an element within a free-form layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(String height);

        /**
         * <p>
         * The visibility of an element within a free-form layout.
         * </p>
         * 
         * @param visibility
         *        The visibility of an element within a free-form layout.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of an element within a free-form layout.
         * </p>
         * 
         * @param visibility
         *        The visibility of an element within a free-form layout.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The rendering rules that determine when an element should be displayed within a free-form layout.
         * </p>
         * 
         * @param renderingRules
         *        The rendering rules that determine when an element should be displayed within a free-form layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderingRules(Collection<SheetElementRenderingRule> renderingRules);

        /**
         * <p>
         * The rendering rules that determine when an element should be displayed within a free-form layout.
         * </p>
         * 
         * @param renderingRules
         *        The rendering rules that determine when an element should be displayed within a free-form layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderingRules(SheetElementRenderingRule... renderingRules);

        /**
         * <p>
         * The rendering rules that determine when an element should be displayed within a free-form layout.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SheetElementRenderingRule.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SheetElementRenderingRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SheetElementRenderingRule.Builder#build()} is called
         * immediately and its result is passed to {@link #renderingRules(List<SheetElementRenderingRule>)}.
         * 
         * @param renderingRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SheetElementRenderingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renderingRules(java.util.Collection<SheetElementRenderingRule>)
         */
        Builder renderingRules(Consumer<SheetElementRenderingRule.Builder>... renderingRules);

        /**
         * <p>
         * The border style configuration of a free-form layout element.
         * </p>
         * 
         * @param borderStyle
         *        The border style configuration of a free-form layout element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder borderStyle(FreeFormLayoutElementBorderStyle borderStyle);

        /**
         * <p>
         * The border style configuration of a free-form layout element.
         * </p>
         * This is a convenience method that creates an instance of the {@link FreeFormLayoutElementBorderStyle.Builder}
         * avoiding the need to create one manually via {@link FreeFormLayoutElementBorderStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FreeFormLayoutElementBorderStyle.Builder#build()} is called
         * immediately and its result is passed to {@link #borderStyle(FreeFormLayoutElementBorderStyle)}.
         * 
         * @param borderStyle
         *        a consumer that will call methods on {@link FreeFormLayoutElementBorderStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #borderStyle(FreeFormLayoutElementBorderStyle)
         */
        default Builder borderStyle(Consumer<FreeFormLayoutElementBorderStyle.Builder> borderStyle) {
            return borderStyle(FreeFormLayoutElementBorderStyle.builder().applyMutation(borderStyle).build());
        }

        /**
         * <p>
         * The border style configuration of a free-form layout element. This border style is used when the element is
         * selected.
         * </p>
         * 
         * @param selectedBorderStyle
         *        The border style configuration of a free-form layout element. This border style is used when the
         *        element is selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedBorderStyle(FreeFormLayoutElementBorderStyle selectedBorderStyle);

        /**
         * <p>
         * The border style configuration of a free-form layout element. This border style is used when the element is
         * selected.
         * </p>
         * This is a convenience method that creates an instance of the {@link FreeFormLayoutElementBorderStyle.Builder}
         * avoiding the need to create one manually via {@link FreeFormLayoutElementBorderStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FreeFormLayoutElementBorderStyle.Builder#build()} is called
         * immediately and its result is passed to {@link #selectedBorderStyle(FreeFormLayoutElementBorderStyle)}.
         * 
         * @param selectedBorderStyle
         *        a consumer that will call methods on {@link FreeFormLayoutElementBorderStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedBorderStyle(FreeFormLayoutElementBorderStyle)
         */
        default Builder selectedBorderStyle(Consumer<FreeFormLayoutElementBorderStyle.Builder> selectedBorderStyle) {
            return selectedBorderStyle(FreeFormLayoutElementBorderStyle.builder().applyMutation(selectedBorderStyle).build());
        }

        /**
         * <p>
         * The background style configuration of a free-form layout element.
         * </p>
         * 
         * @param backgroundStyle
         *        The background style configuration of a free-form layout element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backgroundStyle(FreeFormLayoutElementBackgroundStyle backgroundStyle);

        /**
         * <p>
         * The background style configuration of a free-form layout element.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FreeFormLayoutElementBackgroundStyle.Builder} avoiding the need to create one manually via
         * {@link FreeFormLayoutElementBackgroundStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FreeFormLayoutElementBackgroundStyle.Builder#build()} is called
         * immediately and its result is passed to {@link #backgroundStyle(FreeFormLayoutElementBackgroundStyle)}.
         * 
         * @param backgroundStyle
         *        a consumer that will call methods on {@link FreeFormLayoutElementBackgroundStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backgroundStyle(FreeFormLayoutElementBackgroundStyle)
         */
        default Builder backgroundStyle(Consumer<FreeFormLayoutElementBackgroundStyle.Builder> backgroundStyle) {
            return backgroundStyle(FreeFormLayoutElementBackgroundStyle.builder().applyMutation(backgroundStyle).build());
        }

        /**
         * <p>
         * The loading animation configuration of a free-form layout element.
         * </p>
         * 
         * @param loadingAnimation
         *        The loading animation configuration of a free-form layout element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadingAnimation(LoadingAnimation loadingAnimation);

        /**
         * <p>
         * The loading animation configuration of a free-form layout element.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoadingAnimation.Builder} avoiding the
         * need to create one manually via {@link LoadingAnimation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoadingAnimation.Builder#build()} is called immediately and its
         * result is passed to {@link #loadingAnimation(LoadingAnimation)}.
         * 
         * @param loadingAnimation
         *        a consumer that will call methods on {@link LoadingAnimation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadingAnimation(LoadingAnimation)
         */
        default Builder loadingAnimation(Consumer<LoadingAnimation.Builder> loadingAnimation) {
            return loadingAnimation(LoadingAnimation.builder().applyMutation(loadingAnimation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String elementId;

        private String elementType;

        private String xAxisLocation;

        private String yAxisLocation;

        private String width;

        private String height;

        private String visibility;

        private List<SheetElementRenderingRule> renderingRules = DefaultSdkAutoConstructList.getInstance();

        private FreeFormLayoutElementBorderStyle borderStyle;

        private FreeFormLayoutElementBorderStyle selectedBorderStyle;

        private FreeFormLayoutElementBackgroundStyle backgroundStyle;

        private LoadingAnimation loadingAnimation;

        private BuilderImpl() {
        }

        private BuilderImpl(FreeFormLayoutElement model) {
            elementId(model.elementId);
            elementType(model.elementType);
            xAxisLocation(model.xAxisLocation);
            yAxisLocation(model.yAxisLocation);
            width(model.width);
            height(model.height);
            visibility(model.visibility);
            renderingRules(model.renderingRules);
            borderStyle(model.borderStyle);
            selectedBorderStyle(model.selectedBorderStyle);
            backgroundStyle(model.backgroundStyle);
            loadingAnimation(model.loadingAnimation);
        }

        public final String getElementId() {
            return elementId;
        }

        public final void setElementId(String elementId) {
            this.elementId = elementId;
        }

        @Override
        public final Builder elementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final String getElementType() {
            return elementType;
        }

        public final void setElementType(String elementType) {
            this.elementType = elementType;
        }

        @Override
        public final Builder elementType(String elementType) {
            this.elementType = elementType;
            return this;
        }

        @Override
        public final Builder elementType(LayoutElementType elementType) {
            this.elementType(elementType == null ? null : elementType.toString());
            return this;
        }

        public final String getXAxisLocation() {
            return xAxisLocation;
        }

        public final void setXAxisLocation(String xAxisLocation) {
            this.xAxisLocation = xAxisLocation;
        }

        @Override
        public final Builder xAxisLocation(String xAxisLocation) {
            this.xAxisLocation = xAxisLocation;
            return this;
        }

        public final String getYAxisLocation() {
            return yAxisLocation;
        }

        public final void setYAxisLocation(String yAxisLocation) {
            this.yAxisLocation = yAxisLocation;
        }

        @Override
        public final Builder yAxisLocation(String yAxisLocation) {
            this.yAxisLocation = yAxisLocation;
            return this;
        }

        public final String getWidth() {
            return width;
        }

        public final void setWidth(String width) {
            this.width = width;
        }

        @Override
        public final Builder width(String width) {
            this.width = width;
            return this;
        }

        public final String getHeight() {
            return height;
        }

        public final void setHeight(String height) {
            this.height = height;
        }

        @Override
        public final Builder height(String height) {
            this.height = height;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final List<SheetElementRenderingRule.Builder> getRenderingRules() {
            List<SheetElementRenderingRule.Builder> result = SheetElementRenderingRuleListCopier
                    .copyToBuilder(this.renderingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRenderingRules(Collection<SheetElementRenderingRule.BuilderImpl> renderingRules) {
            this.renderingRules = SheetElementRenderingRuleListCopier.copyFromBuilder(renderingRules);
        }

        @Override
        public final Builder renderingRules(Collection<SheetElementRenderingRule> renderingRules) {
            this.renderingRules = SheetElementRenderingRuleListCopier.copy(renderingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder renderingRules(SheetElementRenderingRule... renderingRules) {
            renderingRules(Arrays.asList(renderingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder renderingRules(Consumer<SheetElementRenderingRule.Builder>... renderingRules) {
            renderingRules(Stream.of(renderingRules).map(c -> SheetElementRenderingRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final FreeFormLayoutElementBorderStyle.Builder getBorderStyle() {
            return borderStyle != null ? borderStyle.toBuilder() : null;
        }

        public final void setBorderStyle(FreeFormLayoutElementBorderStyle.BuilderImpl borderStyle) {
            this.borderStyle = borderStyle != null ? borderStyle.build() : null;
        }

        @Override
        public final Builder borderStyle(FreeFormLayoutElementBorderStyle borderStyle) {
            this.borderStyle = borderStyle;
            return this;
        }

        public final FreeFormLayoutElementBorderStyle.Builder getSelectedBorderStyle() {
            return selectedBorderStyle != null ? selectedBorderStyle.toBuilder() : null;
        }

        public final void setSelectedBorderStyle(FreeFormLayoutElementBorderStyle.BuilderImpl selectedBorderStyle) {
            this.selectedBorderStyle = selectedBorderStyle != null ? selectedBorderStyle.build() : null;
        }

        @Override
        public final Builder selectedBorderStyle(FreeFormLayoutElementBorderStyle selectedBorderStyle) {
            this.selectedBorderStyle = selectedBorderStyle;
            return this;
        }

        public final FreeFormLayoutElementBackgroundStyle.Builder getBackgroundStyle() {
            return backgroundStyle != null ? backgroundStyle.toBuilder() : null;
        }

        public final void setBackgroundStyle(FreeFormLayoutElementBackgroundStyle.BuilderImpl backgroundStyle) {
            this.backgroundStyle = backgroundStyle != null ? backgroundStyle.build() : null;
        }

        @Override
        public final Builder backgroundStyle(FreeFormLayoutElementBackgroundStyle backgroundStyle) {
            this.backgroundStyle = backgroundStyle;
            return this;
        }

        public final LoadingAnimation.Builder getLoadingAnimation() {
            return loadingAnimation != null ? loadingAnimation.toBuilder() : null;
        }

        public final void setLoadingAnimation(LoadingAnimation.BuilderImpl loadingAnimation) {
            this.loadingAnimation = loadingAnimation != null ? loadingAnimation.build() : null;
        }

        @Override
        public final Builder loadingAnimation(LoadingAnimation loadingAnimation) {
            this.loadingAnimation = loadingAnimation;
            return this;
        }

        @Override
        public FreeFormLayoutElement build() {
            return new FreeFormLayoutElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
