/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The computation union that is used in an insight visual.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Computation implements SdkPojo, Serializable, ToCopyableBuilder<Computation.Builder, Computation> {
    private static final SdkField<TopBottomRankedComputation> TOP_BOTTOM_RANKED_FIELD = SdkField
            .<TopBottomRankedComputation> builder(MarshallingType.SDK_POJO).memberName("TopBottomRanked")
            .getter(getter(Computation::topBottomRanked)).setter(setter(Builder::topBottomRanked))
            .constructor(TopBottomRankedComputation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopBottomRanked").build()).build();

    private static final SdkField<TopBottomMoversComputation> TOP_BOTTOM_MOVERS_FIELD = SdkField
            .<TopBottomMoversComputation> builder(MarshallingType.SDK_POJO).memberName("TopBottomMovers")
            .getter(getter(Computation::topBottomMovers)).setter(setter(Builder::topBottomMovers))
            .constructor(TopBottomMoversComputation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopBottomMovers").build()).build();

    private static final SdkField<TotalAggregationComputation> TOTAL_AGGREGATION_FIELD = SdkField
            .<TotalAggregationComputation> builder(MarshallingType.SDK_POJO).memberName("TotalAggregation")
            .getter(getter(Computation::totalAggregation)).setter(setter(Builder::totalAggregation))
            .constructor(TotalAggregationComputation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAggregation").build()).build();

    private static final SdkField<MaximumMinimumComputation> MAXIMUM_MINIMUM_FIELD = SdkField
            .<MaximumMinimumComputation> builder(MarshallingType.SDK_POJO).memberName("MaximumMinimum")
            .getter(getter(Computation::maximumMinimum)).setter(setter(Builder::maximumMinimum))
            .constructor(MaximumMinimumComputation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumMinimum").build()).build();

    private static final SdkField<MetricComparisonComputation> METRIC_COMPARISON_FIELD = SdkField
            .<MetricComparisonComputation> builder(MarshallingType.SDK_POJO).memberName("MetricComparison")
            .getter(getter(Computation::metricComparison)).setter(setter(Builder::metricComparison))
            .constructor(MetricComparisonComputation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricComparison").build()).build();

    private static final SdkField<PeriodOverPeriodComputation> PERIOD_OVER_PERIOD_FIELD = SdkField
            .<PeriodOverPeriodComputation> builder(MarshallingType.SDK_POJO).memberName("PeriodOverPeriod")
            .getter(getter(Computation::periodOverPeriod)).setter(setter(Builder::periodOverPeriod))
            .constructor(PeriodOverPeriodComputation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodOverPeriod").build()).build();

    private static final SdkField<PeriodToDateComputation> PERIOD_TO_DATE_FIELD = SdkField
            .<PeriodToDateComputation> builder(MarshallingType.SDK_POJO).memberName("PeriodToDate")
            .getter(getter(Computation::periodToDate)).setter(setter(Builder::periodToDate))
            .constructor(PeriodToDateComputation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodToDate").build()).build();

    private static final SdkField<GrowthRateComputation> GROWTH_RATE_FIELD = SdkField
            .<GrowthRateComputation> builder(MarshallingType.SDK_POJO).memberName("GrowthRate")
            .getter(getter(Computation::growthRate)).setter(setter(Builder::growthRate))
            .constructor(GrowthRateComputation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthRate").build()).build();

    private static final SdkField<UniqueValuesComputation> UNIQUE_VALUES_FIELD = SdkField
            .<UniqueValuesComputation> builder(MarshallingType.SDK_POJO).memberName("UniqueValues")
            .getter(getter(Computation::uniqueValues)).setter(setter(Builder::uniqueValues))
            .constructor(UniqueValuesComputation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueValues").build()).build();

    private static final SdkField<ForecastComputation> FORECAST_FIELD = SdkField
            .<ForecastComputation> builder(MarshallingType.SDK_POJO).memberName("Forecast").getter(getter(Computation::forecast))
            .setter(setter(Builder::forecast)).constructor(ForecastComputation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Forecast").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOP_BOTTOM_RANKED_FIELD,
            TOP_BOTTOM_MOVERS_FIELD, TOTAL_AGGREGATION_FIELD, MAXIMUM_MINIMUM_FIELD, METRIC_COMPARISON_FIELD,
            PERIOD_OVER_PERIOD_FIELD, PERIOD_TO_DATE_FIELD, GROWTH_RATE_FIELD, UNIQUE_VALUES_FIELD, FORECAST_FIELD));

    private static final long serialVersionUID = 1L;

    private final TopBottomRankedComputation topBottomRanked;

    private final TopBottomMoversComputation topBottomMovers;

    private final TotalAggregationComputation totalAggregation;

    private final MaximumMinimumComputation maximumMinimum;

    private final MetricComparisonComputation metricComparison;

    private final PeriodOverPeriodComputation periodOverPeriod;

    private final PeriodToDateComputation periodToDate;

    private final GrowthRateComputation growthRate;

    private final UniqueValuesComputation uniqueValues;

    private final ForecastComputation forecast;

    private Computation(BuilderImpl builder) {
        this.topBottomRanked = builder.topBottomRanked;
        this.topBottomMovers = builder.topBottomMovers;
        this.totalAggregation = builder.totalAggregation;
        this.maximumMinimum = builder.maximumMinimum;
        this.metricComparison = builder.metricComparison;
        this.periodOverPeriod = builder.periodOverPeriod;
        this.periodToDate = builder.periodToDate;
        this.growthRate = builder.growthRate;
        this.uniqueValues = builder.uniqueValues;
        this.forecast = builder.forecast;
    }

    /**
     * <p>
     * The top ranked and bottom ranked computation configuration.
     * </p>
     * 
     * @return The top ranked and bottom ranked computation configuration.
     */
    public final TopBottomRankedComputation topBottomRanked() {
        return topBottomRanked;
    }

    /**
     * <p>
     * The top movers and bottom movers computation configuration.
     * </p>
     * 
     * @return The top movers and bottom movers computation configuration.
     */
    public final TopBottomMoversComputation topBottomMovers() {
        return topBottomMovers;
    }

    /**
     * <p>
     * The total aggregation computation configuration.
     * </p>
     * 
     * @return The total aggregation computation configuration.
     */
    public final TotalAggregationComputation totalAggregation() {
        return totalAggregation;
    }

    /**
     * <p>
     * The maximum and minimum computation configuration.
     * </p>
     * 
     * @return The maximum and minimum computation configuration.
     */
    public final MaximumMinimumComputation maximumMinimum() {
        return maximumMinimum;
    }

    /**
     * <p>
     * The metric comparison computation configuration.
     * </p>
     * 
     * @return The metric comparison computation configuration.
     */
    public final MetricComparisonComputation metricComparison() {
        return metricComparison;
    }

    /**
     * <p>
     * The period over period computation configuration.
     * </p>
     * 
     * @return The period over period computation configuration.
     */
    public final PeriodOverPeriodComputation periodOverPeriod() {
        return periodOverPeriod;
    }

    /**
     * <p>
     * The period to <code>DataSetIdentifier</code> computation configuration.
     * </p>
     * 
     * @return The period to <code>DataSetIdentifier</code> computation configuration.
     */
    public final PeriodToDateComputation periodToDate() {
        return periodToDate;
    }

    /**
     * <p>
     * The growth rate computation configuration.
     * </p>
     * 
     * @return The growth rate computation configuration.
     */
    public final GrowthRateComputation growthRate() {
        return growthRate;
    }

    /**
     * <p>
     * The unique values computation configuration.
     * </p>
     * 
     * @return The unique values computation configuration.
     */
    public final UniqueValuesComputation uniqueValues() {
        return uniqueValues;
    }

    /**
     * <p>
     * The forecast computation configuration.
     * </p>
     * 
     * @return The forecast computation configuration.
     */
    public final ForecastComputation forecast() {
        return forecast;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topBottomRanked());
        hashCode = 31 * hashCode + Objects.hashCode(topBottomMovers());
        hashCode = 31 * hashCode + Objects.hashCode(totalAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(maximumMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(metricComparison());
        hashCode = 31 * hashCode + Objects.hashCode(periodOverPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(periodToDate());
        hashCode = 31 * hashCode + Objects.hashCode(growthRate());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueValues());
        hashCode = 31 * hashCode + Objects.hashCode(forecast());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Computation)) {
            return false;
        }
        Computation other = (Computation) obj;
        return Objects.equals(topBottomRanked(), other.topBottomRanked())
                && Objects.equals(topBottomMovers(), other.topBottomMovers())
                && Objects.equals(totalAggregation(), other.totalAggregation())
                && Objects.equals(maximumMinimum(), other.maximumMinimum())
                && Objects.equals(metricComparison(), other.metricComparison())
                && Objects.equals(periodOverPeriod(), other.periodOverPeriod())
                && Objects.equals(periodToDate(), other.periodToDate()) && Objects.equals(growthRate(), other.growthRate())
                && Objects.equals(uniqueValues(), other.uniqueValues()) && Objects.equals(forecast(), other.forecast());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Computation").add("TopBottomRanked", topBottomRanked())
                .add("TopBottomMovers", topBottomMovers()).add("TotalAggregation", totalAggregation())
                .add("MaximumMinimum", maximumMinimum()).add("MetricComparison", metricComparison())
                .add("PeriodOverPeriod", periodOverPeriod()).add("PeriodToDate", periodToDate()).add("GrowthRate", growthRate())
                .add("UniqueValues", uniqueValues()).add("Forecast", forecast()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopBottomRanked":
            return Optional.ofNullable(clazz.cast(topBottomRanked()));
        case "TopBottomMovers":
            return Optional.ofNullable(clazz.cast(topBottomMovers()));
        case "TotalAggregation":
            return Optional.ofNullable(clazz.cast(totalAggregation()));
        case "MaximumMinimum":
            return Optional.ofNullable(clazz.cast(maximumMinimum()));
        case "MetricComparison":
            return Optional.ofNullable(clazz.cast(metricComparison()));
        case "PeriodOverPeriod":
            return Optional.ofNullable(clazz.cast(periodOverPeriod()));
        case "PeriodToDate":
            return Optional.ofNullable(clazz.cast(periodToDate()));
        case "GrowthRate":
            return Optional.ofNullable(clazz.cast(growthRate()));
        case "UniqueValues":
            return Optional.ofNullable(clazz.cast(uniqueValues()));
        case "Forecast":
            return Optional.ofNullable(clazz.cast(forecast()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Computation, T> g) {
        return obj -> g.apply((Computation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Computation> {
        /**
         * <p>
         * The top ranked and bottom ranked computation configuration.
         * </p>
         * 
         * @param topBottomRanked
         *        The top ranked and bottom ranked computation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topBottomRanked(TopBottomRankedComputation topBottomRanked);

        /**
         * <p>
         * The top ranked and bottom ranked computation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopBottomRankedComputation.Builder}
         * avoiding the need to create one manually via {@link TopBottomRankedComputation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopBottomRankedComputation.Builder#build()} is called immediately
         * and its result is passed to {@link #topBottomRanked(TopBottomRankedComputation)}.
         * 
         * @param topBottomRanked
         *        a consumer that will call methods on {@link TopBottomRankedComputation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topBottomRanked(TopBottomRankedComputation)
         */
        default Builder topBottomRanked(Consumer<TopBottomRankedComputation.Builder> topBottomRanked) {
            return topBottomRanked(TopBottomRankedComputation.builder().applyMutation(topBottomRanked).build());
        }

        /**
         * <p>
         * The top movers and bottom movers computation configuration.
         * </p>
         * 
         * @param topBottomMovers
         *        The top movers and bottom movers computation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topBottomMovers(TopBottomMoversComputation topBottomMovers);

        /**
         * <p>
         * The top movers and bottom movers computation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopBottomMoversComputation.Builder}
         * avoiding the need to create one manually via {@link TopBottomMoversComputation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopBottomMoversComputation.Builder#build()} is called immediately
         * and its result is passed to {@link #topBottomMovers(TopBottomMoversComputation)}.
         * 
         * @param topBottomMovers
         *        a consumer that will call methods on {@link TopBottomMoversComputation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topBottomMovers(TopBottomMoversComputation)
         */
        default Builder topBottomMovers(Consumer<TopBottomMoversComputation.Builder> topBottomMovers) {
            return topBottomMovers(TopBottomMoversComputation.builder().applyMutation(topBottomMovers).build());
        }

        /**
         * <p>
         * The total aggregation computation configuration.
         * </p>
         * 
         * @param totalAggregation
         *        The total aggregation computation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAggregation(TotalAggregationComputation totalAggregation);

        /**
         * <p>
         * The total aggregation computation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TotalAggregationComputation.Builder}
         * avoiding the need to create one manually via {@link TotalAggregationComputation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TotalAggregationComputation.Builder#build()} is called
         * immediately and its result is passed to {@link #totalAggregation(TotalAggregationComputation)}.
         * 
         * @param totalAggregation
         *        a consumer that will call methods on {@link TotalAggregationComputation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalAggregation(TotalAggregationComputation)
         */
        default Builder totalAggregation(Consumer<TotalAggregationComputation.Builder> totalAggregation) {
            return totalAggregation(TotalAggregationComputation.builder().applyMutation(totalAggregation).build());
        }

        /**
         * <p>
         * The maximum and minimum computation configuration.
         * </p>
         * 
         * @param maximumMinimum
         *        The maximum and minimum computation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumMinimum(MaximumMinimumComputation maximumMinimum);

        /**
         * <p>
         * The maximum and minimum computation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaximumMinimumComputation.Builder}
         * avoiding the need to create one manually via {@link MaximumMinimumComputation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaximumMinimumComputation.Builder#build()} is called immediately
         * and its result is passed to {@link #maximumMinimum(MaximumMinimumComputation)}.
         * 
         * @param maximumMinimum
         *        a consumer that will call methods on {@link MaximumMinimumComputation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumMinimum(MaximumMinimumComputation)
         */
        default Builder maximumMinimum(Consumer<MaximumMinimumComputation.Builder> maximumMinimum) {
            return maximumMinimum(MaximumMinimumComputation.builder().applyMutation(maximumMinimum).build());
        }

        /**
         * <p>
         * The metric comparison computation configuration.
         * </p>
         * 
         * @param metricComparison
         *        The metric comparison computation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricComparison(MetricComparisonComputation metricComparison);

        /**
         * <p>
         * The metric comparison computation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricComparisonComputation.Builder}
         * avoiding the need to create one manually via {@link MetricComparisonComputation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricComparisonComputation.Builder#build()} is called
         * immediately and its result is passed to {@link #metricComparison(MetricComparisonComputation)}.
         * 
         * @param metricComparison
         *        a consumer that will call methods on {@link MetricComparisonComputation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricComparison(MetricComparisonComputation)
         */
        default Builder metricComparison(Consumer<MetricComparisonComputation.Builder> metricComparison) {
            return metricComparison(MetricComparisonComputation.builder().applyMutation(metricComparison).build());
        }

        /**
         * <p>
         * The period over period computation configuration.
         * </p>
         * 
         * @param periodOverPeriod
         *        The period over period computation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodOverPeriod(PeriodOverPeriodComputation periodOverPeriod);

        /**
         * <p>
         * The period over period computation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PeriodOverPeriodComputation.Builder}
         * avoiding the need to create one manually via {@link PeriodOverPeriodComputation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PeriodOverPeriodComputation.Builder#build()} is called
         * immediately and its result is passed to {@link #periodOverPeriod(PeriodOverPeriodComputation)}.
         * 
         * @param periodOverPeriod
         *        a consumer that will call methods on {@link PeriodOverPeriodComputation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #periodOverPeriod(PeriodOverPeriodComputation)
         */
        default Builder periodOverPeriod(Consumer<PeriodOverPeriodComputation.Builder> periodOverPeriod) {
            return periodOverPeriod(PeriodOverPeriodComputation.builder().applyMutation(periodOverPeriod).build());
        }

        /**
         * <p>
         * The period to <code>DataSetIdentifier</code> computation configuration.
         * </p>
         * 
         * @param periodToDate
         *        The period to <code>DataSetIdentifier</code> computation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodToDate(PeriodToDateComputation periodToDate);

        /**
         * <p>
         * The period to <code>DataSetIdentifier</code> computation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PeriodToDateComputation.Builder} avoiding
         * the need to create one manually via {@link PeriodToDateComputation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PeriodToDateComputation.Builder#build()} is called immediately
         * and its result is passed to {@link #periodToDate(PeriodToDateComputation)}.
         * 
         * @param periodToDate
         *        a consumer that will call methods on {@link PeriodToDateComputation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #periodToDate(PeriodToDateComputation)
         */
        default Builder periodToDate(Consumer<PeriodToDateComputation.Builder> periodToDate) {
            return periodToDate(PeriodToDateComputation.builder().applyMutation(periodToDate).build());
        }

        /**
         * <p>
         * The growth rate computation configuration.
         * </p>
         * 
         * @param growthRate
         *        The growth rate computation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder growthRate(GrowthRateComputation growthRate);

        /**
         * <p>
         * The growth rate computation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link GrowthRateComputation.Builder} avoiding
         * the need to create one manually via {@link GrowthRateComputation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GrowthRateComputation.Builder#build()} is called immediately and
         * its result is passed to {@link #growthRate(GrowthRateComputation)}.
         * 
         * @param growthRate
         *        a consumer that will call methods on {@link GrowthRateComputation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #growthRate(GrowthRateComputation)
         */
        default Builder growthRate(Consumer<GrowthRateComputation.Builder> growthRate) {
            return growthRate(GrowthRateComputation.builder().applyMutation(growthRate).build());
        }

        /**
         * <p>
         * The unique values computation configuration.
         * </p>
         * 
         * @param uniqueValues
         *        The unique values computation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueValues(UniqueValuesComputation uniqueValues);

        /**
         * <p>
         * The unique values computation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link UniqueValuesComputation.Builder} avoiding
         * the need to create one manually via {@link UniqueValuesComputation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UniqueValuesComputation.Builder#build()} is called immediately
         * and its result is passed to {@link #uniqueValues(UniqueValuesComputation)}.
         * 
         * @param uniqueValues
         *        a consumer that will call methods on {@link UniqueValuesComputation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uniqueValues(UniqueValuesComputation)
         */
        default Builder uniqueValues(Consumer<UniqueValuesComputation.Builder> uniqueValues) {
            return uniqueValues(UniqueValuesComputation.builder().applyMutation(uniqueValues).build());
        }

        /**
         * <p>
         * The forecast computation configuration.
         * </p>
         * 
         * @param forecast
         *        The forecast computation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecast(ForecastComputation forecast);

        /**
         * <p>
         * The forecast computation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ForecastComputation.Builder} avoiding the
         * need to create one manually via {@link ForecastComputation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ForecastComputation.Builder#build()} is called immediately and
         * its result is passed to {@link #forecast(ForecastComputation)}.
         * 
         * @param forecast
         *        a consumer that will call methods on {@link ForecastComputation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forecast(ForecastComputation)
         */
        default Builder forecast(Consumer<ForecastComputation.Builder> forecast) {
            return forecast(ForecastComputation.builder().applyMutation(forecast).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TopBottomRankedComputation topBottomRanked;

        private TopBottomMoversComputation topBottomMovers;

        private TotalAggregationComputation totalAggregation;

        private MaximumMinimumComputation maximumMinimum;

        private MetricComparisonComputation metricComparison;

        private PeriodOverPeriodComputation periodOverPeriod;

        private PeriodToDateComputation periodToDate;

        private GrowthRateComputation growthRate;

        private UniqueValuesComputation uniqueValues;

        private ForecastComputation forecast;

        private BuilderImpl() {
        }

        private BuilderImpl(Computation model) {
            topBottomRanked(model.topBottomRanked);
            topBottomMovers(model.topBottomMovers);
            totalAggregation(model.totalAggregation);
            maximumMinimum(model.maximumMinimum);
            metricComparison(model.metricComparison);
            periodOverPeriod(model.periodOverPeriod);
            periodToDate(model.periodToDate);
            growthRate(model.growthRate);
            uniqueValues(model.uniqueValues);
            forecast(model.forecast);
        }

        public final TopBottomRankedComputation.Builder getTopBottomRanked() {
            return topBottomRanked != null ? topBottomRanked.toBuilder() : null;
        }

        public final void setTopBottomRanked(TopBottomRankedComputation.BuilderImpl topBottomRanked) {
            this.topBottomRanked = topBottomRanked != null ? topBottomRanked.build() : null;
        }

        @Override
        public final Builder topBottomRanked(TopBottomRankedComputation topBottomRanked) {
            this.topBottomRanked = topBottomRanked;
            return this;
        }

        public final TopBottomMoversComputation.Builder getTopBottomMovers() {
            return topBottomMovers != null ? topBottomMovers.toBuilder() : null;
        }

        public final void setTopBottomMovers(TopBottomMoversComputation.BuilderImpl topBottomMovers) {
            this.topBottomMovers = topBottomMovers != null ? topBottomMovers.build() : null;
        }

        @Override
        public final Builder topBottomMovers(TopBottomMoversComputation topBottomMovers) {
            this.topBottomMovers = topBottomMovers;
            return this;
        }

        public final TotalAggregationComputation.Builder getTotalAggregation() {
            return totalAggregation != null ? totalAggregation.toBuilder() : null;
        }

        public final void setTotalAggregation(TotalAggregationComputation.BuilderImpl totalAggregation) {
            this.totalAggregation = totalAggregation != null ? totalAggregation.build() : null;
        }

        @Override
        public final Builder totalAggregation(TotalAggregationComputation totalAggregation) {
            this.totalAggregation = totalAggregation;
            return this;
        }

        public final MaximumMinimumComputation.Builder getMaximumMinimum() {
            return maximumMinimum != null ? maximumMinimum.toBuilder() : null;
        }

        public final void setMaximumMinimum(MaximumMinimumComputation.BuilderImpl maximumMinimum) {
            this.maximumMinimum = maximumMinimum != null ? maximumMinimum.build() : null;
        }

        @Override
        public final Builder maximumMinimum(MaximumMinimumComputation maximumMinimum) {
            this.maximumMinimum = maximumMinimum;
            return this;
        }

        public final MetricComparisonComputation.Builder getMetricComparison() {
            return metricComparison != null ? metricComparison.toBuilder() : null;
        }

        public final void setMetricComparison(MetricComparisonComputation.BuilderImpl metricComparison) {
            this.metricComparison = metricComparison != null ? metricComparison.build() : null;
        }

        @Override
        public final Builder metricComparison(MetricComparisonComputation metricComparison) {
            this.metricComparison = metricComparison;
            return this;
        }

        public final PeriodOverPeriodComputation.Builder getPeriodOverPeriod() {
            return periodOverPeriod != null ? periodOverPeriod.toBuilder() : null;
        }

        public final void setPeriodOverPeriod(PeriodOverPeriodComputation.BuilderImpl periodOverPeriod) {
            this.periodOverPeriod = periodOverPeriod != null ? periodOverPeriod.build() : null;
        }

        @Override
        public final Builder periodOverPeriod(PeriodOverPeriodComputation periodOverPeriod) {
            this.periodOverPeriod = periodOverPeriod;
            return this;
        }

        public final PeriodToDateComputation.Builder getPeriodToDate() {
            return periodToDate != null ? periodToDate.toBuilder() : null;
        }

        public final void setPeriodToDate(PeriodToDateComputation.BuilderImpl periodToDate) {
            this.periodToDate = periodToDate != null ? periodToDate.build() : null;
        }

        @Override
        public final Builder periodToDate(PeriodToDateComputation periodToDate) {
            this.periodToDate = periodToDate;
            return this;
        }

        public final GrowthRateComputation.Builder getGrowthRate() {
            return growthRate != null ? growthRate.toBuilder() : null;
        }

        public final void setGrowthRate(GrowthRateComputation.BuilderImpl growthRate) {
            this.growthRate = growthRate != null ? growthRate.build() : null;
        }

        @Override
        public final Builder growthRate(GrowthRateComputation growthRate) {
            this.growthRate = growthRate;
            return this;
        }

        public final UniqueValuesComputation.Builder getUniqueValues() {
            return uniqueValues != null ? uniqueValues.toBuilder() : null;
        }

        public final void setUniqueValues(UniqueValuesComputation.BuilderImpl uniqueValues) {
            this.uniqueValues = uniqueValues != null ? uniqueValues.build() : null;
        }

        @Override
        public final Builder uniqueValues(UniqueValuesComputation uniqueValues) {
            this.uniqueValues = uniqueValues;
            return this;
        }

        public final ForecastComputation.Builder getForecast() {
            return forecast != null ? forecast.toBuilder() : null;
        }

        public final void setForecast(ForecastComputation.BuilderImpl forecast) {
            this.forecast = forecast != null ? forecast.build() : null;
        }

        @Override
        public final Builder forecast(ForecastComputation forecast) {
            this.forecast = forecast;
            return this;
        }

        @Override
        public Computation build() {
            return new Computation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
