/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.Dashboard;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDashboardResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeDashboardResponse> {
    private static final SdkField<Dashboard> DASHBOARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Dashboard").getter(DescribeDashboardResponse.getter(DescribeDashboardResponse::dashboard)).setter(DescribeDashboardResponse.setter(Builder::dashboard)).constructor(Dashboard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboard").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeDashboardResponse.getter(DescribeDashboardResponse::status)).setter(DescribeDashboardResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeDashboardResponse.getter(DescribeDashboardResponse::requestId)).setter(DescribeDashboardResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final Dashboard dashboard;
    private final Integer status;
    private final String requestId;

    private DescribeDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboard = builder.dashboard;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final Dashboard dashboard() {
        return this.dashboard;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboard());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardResponse)) {
            return false;
        }
        DescribeDashboardResponse other = (DescribeDashboardResponse)((Object)obj);
        return Objects.equals(this.dashboard(), other.dashboard()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDashboardResponse").add("Dashboard", (Object)this.dashboard()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dashboard": {
                return Optional.ofNullable(clazz.cast(this.dashboard()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardResponse, T> g) {
        return obj -> g.apply((DescribeDashboardResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Dashboard dashboard;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardResponse model) {
            super(model);
            this.dashboard(model.dashboard);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final Dashboard.Builder getDashboard() {
            return this.dashboard != null ? this.dashboard.toBuilder() : null;
        }

        public final void setDashboard(Dashboard.BuilderImpl dashboard) {
            this.dashboard = dashboard != null ? dashboard.build() : null;
        }

        @Override
        public final Builder dashboard(Dashboard dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeDashboardResponse build() {
            return new DescribeDashboardResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDashboardResponse> {
        public Builder dashboard(Dashboard var1);

        default public Builder dashboard(Consumer<Dashboard.Builder> dashboard) {
            return this.dashboard((Dashboard)((Dashboard.Builder)Dashboard.builder().applyMutation(dashboard)).build());
        }

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

