/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSetResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, CreateDataSetResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateDataSetResponse.getter(CreateDataSetResponse::arn)).setter(CreateDataSetResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(CreateDataSetResponse.getter(CreateDataSetResponse::dataSetId)).setter(CreateDataSetResponse.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> INGESTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestionArn").getter(CreateDataSetResponse.getter(CreateDataSetResponse::ingestionArn)).setter(CreateDataSetResponse.setter(Builder::ingestionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionArn").build()}).build();
    private static final SdkField<String> INGESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestionId").getter(CreateDataSetResponse.getter(CreateDataSetResponse::ingestionId)).setter(CreateDataSetResponse.setter(Builder::ingestionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionId").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateDataSetResponse.getter(CreateDataSetResponse::requestId)).setter(CreateDataSetResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(CreateDataSetResponse.getter(CreateDataSetResponse::status)).setter(CreateDataSetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_SET_ID_FIELD, INGESTION_ARN_FIELD, INGESTION_ID_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final String arn;
    private final String dataSetId;
    private final String ingestionArn;
    private final String ingestionId;
    private final String requestId;
    private final Integer status;

    private CreateDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.dataSetId = builder.dataSetId;
        this.ingestionArn = builder.ingestionArn;
        this.ingestionId = builder.ingestionId;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final String ingestionArn() {
        return this.ingestionArn;
    }

    public final String ingestionId() {
        return this.ingestionId;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSetResponse)) {
            return false;
        }
        CreateDataSetResponse other = (CreateDataSetResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.ingestionArn(), other.ingestionArn()) && Objects.equals(this.ingestionId(), other.ingestionId()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataSetResponse").add("Arn", (Object)this.arn()).add("DataSetId", (Object)this.dataSetId()).add("IngestionArn", (Object)this.ingestionArn()).add("IngestionId", (Object)this.ingestionId()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "IngestionArn": {
                return Optional.ofNullable(clazz.cast(this.ingestionArn()));
            }
            case "IngestionId": {
                return Optional.ofNullable(clazz.cast(this.ingestionId()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSetResponse, T> g) {
        return obj -> g.apply((CreateDataSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String dataSetId;
        private String ingestionArn;
        private String ingestionId;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSetResponse model) {
            super(model);
            this.arn(model.arn);
            this.dataSetId(model.dataSetId);
            this.ingestionArn(model.ingestionArn);
            this.ingestionId(model.ingestionId);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getIngestionArn() {
            return this.ingestionArn;
        }

        @Override
        public final Builder ingestionArn(String ingestionArn) {
            this.ingestionArn = ingestionArn;
            return this;
        }

        public final void setIngestionArn(String ingestionArn) {
            this.ingestionArn = ingestionArn;
        }

        public final String getIngestionId() {
            return this.ingestionId;
        }

        @Override
        public final Builder ingestionId(String ingestionId) {
            this.ingestionId = ingestionId;
            return this;
        }

        public final void setIngestionId(String ingestionId) {
            this.ingestionId = ingestionId;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public CreateDataSetResponse build() {
            return new CreateDataSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSetResponse> {
        public Builder arn(String var1);

        public Builder dataSetId(String var1);

        public Builder ingestionArn(String var1);

        public Builder ingestionId(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

