/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnListCopier;
import software.amazon.awssdk.services.quicksight.model.GeoSpatialCountryCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoSpatialColumnGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoSpatialColumnGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GeoSpatialColumnGroup.getter(GeoSpatialColumnGroup::name)).setter(GeoSpatialColumnGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GeoSpatialColumnGroup.getter(GeoSpatialColumnGroup::countryCodeAsString)).setter(GeoSpatialColumnGroup.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()}).build();
    private static final SdkField<List<String>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GeoSpatialColumnGroup.getter(GeoSpatialColumnGroup::columns)).setter(GeoSpatialColumnGroup.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COUNTRY_CODE_FIELD, COLUMNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String countryCode;
    private final List<String> columns;

    private GeoSpatialColumnGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.countryCode = builder.countryCode;
        this.columns = builder.columns;
    }

    public String name() {
        return this.name;
    }

    public GeoSpatialCountryCode countryCode() {
        return GeoSpatialCountryCode.fromValue(this.countryCode);
    }

    public String countryCodeAsString() {
        return this.countryCode;
    }

    public List<String> columns() {
        return this.columns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.columns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoSpatialColumnGroup)) {
            return false;
        }
        GeoSpatialColumnGroup other = (GeoSpatialColumnGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.countryCodeAsString(), other.countryCodeAsString()) && Objects.equals(this.columns(), other.columns());
    }

    public String toString() {
        return ToString.builder((String)"GeoSpatialColumnGroup").add("Name", (Object)this.name()).add("CountryCode", (Object)this.countryCodeAsString()).add("Columns", this.columns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCodeAsString()));
            }
            case "Columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoSpatialColumnGroup, T> g) {
        return obj -> g.apply((GeoSpatialColumnGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String countryCode;
        private List<String> columns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeoSpatialColumnGroup model) {
            this.name(model.name);
            this.countryCode(model.countryCode);
            this.columns(model.columns);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCountryCodeAsString() {
            return this.countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(GeoSpatialCountryCode countryCode) {
            this.countryCode(countryCode == null ? null : countryCode.toString());
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final Collection<String> getColumns() {
            return this.columns;
        }

        @Override
        public final Builder columns(Collection<String> columns) {
            this.columns = ColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(String ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        public final void setColumns(Collection<String> columns) {
            this.columns = ColumnListCopier.copy(columns);
        }

        public GeoSpatialColumnGroup build() {
            return new GeoSpatialColumnGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoSpatialColumnGroup> {
        public Builder name(String var1);

        public Builder countryCode(String var1);

        public Builder countryCode(GeoSpatialCountryCode var1);

        public Builder columns(Collection<String> var1);

        public Builder columns(String ... var1);
    }
}

