/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qapps.QAppsClient;
import software.amazon.awssdk.services.qapps.internal.UserAgentUtils;
import software.amazon.awssdk.services.qapps.model.ListQAppsRequest;
import software.amazon.awssdk.services.qapps.model.ListQAppsResponse;
import software.amazon.awssdk.services.qapps.model.UserAppItem;

public class ListQAppsIterable
implements SdkIterable<ListQAppsResponse> {
    private final QAppsClient client;
    private final ListQAppsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQAppsIterable(QAppsClient client, ListQAppsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQAppsResponseFetcher();
    }

    public Iterator<ListQAppsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UserAppItem> apps() {
        Function<ListQAppsResponse, Iterator> getIterator = response -> {
            if (response != null && response.apps() != null) {
                return response.apps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQAppsResponseFetcher
    implements SyncPageFetcher<ListQAppsResponse> {
        private ListQAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListQAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQAppsResponse nextPage(ListQAppsResponse previousPage) {
            if (previousPage == null) {
                return ListQAppsIterable.this.client.listQApps(ListQAppsIterable.this.firstRequest);
            }
            return ListQAppsIterable.this.client.listQApps((ListQAppsRequest)((Object)ListQAppsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

