/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSyncEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSyncEvent> {
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("event").getter(ResourceSyncEvent.getter(ResourceSyncEvent::event)).setter(ResourceSyncEvent.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(ResourceSyncEvent.getter(ResourceSyncEvent::externalId)).setter(ResourceSyncEvent.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<Instant> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("time").getter(ResourceSyncEvent.getter(ResourceSyncEvent::time)).setter(ResourceSyncEvent.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("time").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ResourceSyncEvent.getter(ResourceSyncEvent::type)).setter(ResourceSyncEvent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD, EXTERNAL_ID_FIELD, TIME_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceSyncEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String event;
    private final String externalId;
    private final Instant time;
    private final String type;

    private ResourceSyncEvent(BuilderImpl builder) {
        this.event = builder.event;
        this.externalId = builder.externalId;
        this.time = builder.time;
        this.type = builder.type;
    }

    public final String event() {
        return this.event;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final Instant time() {
        return this.time;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.event());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSyncEvent)) {
            return false;
        }
        ResourceSyncEvent other = (ResourceSyncEvent)obj;
        return Objects.equals(this.event(), other.event()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.time(), other.time()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceSyncEvent").add("Event", (Object)this.event()).add("ExternalId", (Object)this.externalId()).add("Time", (Object)this.time()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "event": {
                return Optional.ofNullable(clazz.cast(this.event()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("event", EVENT_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("time", TIME_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceSyncEvent, T> g) {
        return obj -> g.apply((ResourceSyncEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String event;
        private String externalId;
        private Instant time;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSyncEvent model) {
            this.event(model.event);
            this.externalId(model.externalId);
            this.time(model.time);
            this.type(model.type);
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Instant getTime() {
            return this.time;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public ResourceSyncEvent build() {
            return new ResourceSyncEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSyncEvent> {
        public Builder event(String var1);

        public Builder externalId(String var1);

        public Builder time(Instant var1);

        public Builder type(String var1);
    }
}

