/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInHeadersRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link MembersInHeadersRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MembersInHeadersRequestModelMarshaller {
    private static final MarshallingInfo<String> STRINGMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-string").isBinary(false).build();

    private static final MarshallingInfo<Boolean> BOOLEANMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-boolean").isBinary(false).build();

    private static final MarshallingInfo<Integer> INTEGERMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-integer").isBinary(false).build();

    private static final MarshallingInfo<Long> LONGMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-long").isBinary(false).build();

    private static final MarshallingInfo<Float> FLOATMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-float").isBinary(false).build();

    private static final MarshallingInfo<Double> DOUBLEMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-double").isBinary(false).build();

    private static final MarshallingInfo<Instant> TIMESTAMPMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-timestamp").isBinary(false).build();

    private static final MembersInHeadersRequestModelMarshaller INSTANCE = new MembersInHeadersRequestModelMarshaller();

    private MembersInHeadersRequestModelMarshaller() {
    }

    public static MembersInHeadersRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(MembersInHeadersRequest membersInHeadersRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(membersInHeadersRequest, "membersInHeadersRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(membersInHeadersRequest.stringMember(), STRINGMEMBER_BINDING);
            protocolMarshaller.marshall(membersInHeadersRequest.booleanMember(), BOOLEANMEMBER_BINDING);
            protocolMarshaller.marshall(membersInHeadersRequest.integerMember(), INTEGERMEMBER_BINDING);
            protocolMarshaller.marshall(membersInHeadersRequest.longMember(), LONGMEMBER_BINDING);
            protocolMarshaller.marshall(membersInHeadersRequest.floatMember(), FLOATMEMBER_BINDING);
            protocolMarshaller.marshall(membersInHeadersRequest.doubleMember(), DOUBLEMEMBER_BINDING);
            protocolMarshaller.marshall(membersInHeadersRequest.timestampMember(), TIMESTAMPMEMBER_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
