/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml;

import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.protocolrestxml.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolrestxml.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolrestxml.model.DeleteOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.DeleteOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.EmptyModeledException;
import software.amazon.awssdk.services.protocolrestxml.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MapOfStringToListOfStringInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MapOfStringToListOfStringInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInHeadersRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInHeadersResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MultiLocationOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MultiLocationOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithExplicitPayloadBlobRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithExplicitPayloadBlobResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithGreedyLabelRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithGreedyLabelResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithModeledContentTypeRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithModeledContentTypeResponse;
import software.amazon.awssdk.services.protocolrestxml.model.ProtocolRestXmlException;
import software.amazon.awssdk.services.protocolrestxml.model.QueryParamWithoutValueRequest;
import software.amazon.awssdk.services.protocolrestxml.model.QueryParamWithoutValueResponse;
import software.amazon.awssdk.services.protocolrestxml.model.RestXmlTypesRequest;
import software.amazon.awssdk.services.protocolrestxml.model.RestXmlTypesResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing AmazonProtocolRestXml. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolRestXmlClient extends SdkClient, SdkAutoCloseable {
    String SERVICE_NAME = "restxml";

    /**
     * Create a {@link ProtocolRestXmlClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static ProtocolRestXmlClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolRestXmlClient}.
     */
    static ProtocolRestXmlClientBuilder builder() {
        return new DefaultProtocolRestXmlClientBuilder();
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.AllTypes
     * @see #allTypes(AllTypesRequest)
     */
    default AllTypesResponse allTypes() throws EmptyModeledException, SdkServiceException, SdkClientException,
            ProtocolRestXmlException {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.AllTypes
     */
    default AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws EmptyModeledException, SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.AllTypes
     */
    default AllTypesResponse allTypes(Consumer<AllTypesRequest.Builder> allTypesRequest) throws EmptyModeledException,
            SdkServiceException, SdkClientException, ProtocolRestXmlException {
        return allTypes(AllTypesRequest.builder().apply(allTypesRequest).build());
    }

    /**
     * Invokes the DeleteOperation operation.
     *
     * @return Result of the DeleteOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.DeleteOperation
     * @see #deleteOperation(DeleteOperationRequest)
     */
    default DeleteOperationResponse deleteOperation() throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        return deleteOperation(DeleteOperationRequest.builder().build());
    }

    /**
     * Invokes the DeleteOperation operation.
     *
     * @param deleteOperationRequest
     * @return Result of the DeleteOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.DeleteOperation
     */
    default DeleteOperationResponse deleteOperation(DeleteOperationRequest deleteOperationRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteOperation operation.
     *
     * @param deleteOperationRequest
     * @return Result of the DeleteOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.DeleteOperation
     */
    default DeleteOperationResponse deleteOperation(Consumer<DeleteOperationRequest.Builder> deleteOperationRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        return deleteOperation(DeleteOperationRequest.builder().apply(deleteOperationRequest).build());
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.IdempotentOperation
     */
    default IdempotentOperationResponse idempotentOperation(IdempotentOperationRequest idempotentOperationRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.IdempotentOperation
     */
    default IdempotentOperationResponse idempotentOperation(
            Consumer<IdempotentOperationRequest.Builder> idempotentOperationRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        return idempotentOperation(IdempotentOperationRequest.builder().apply(idempotentOperationRequest).build());
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.
     *
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MapOfStringToListOfStringInQueryParams
     * @see #mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest)
     */
    default MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams() throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        return mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest.builder().build());
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MapOfStringToListOfStringInQueryParams
     */
    default MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams(
            MapOfStringToListOfStringInQueryParamsRequest mapOfStringToListOfStringInQueryParamsRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MapOfStringToListOfStringInQueryParams
     */
    default MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams(
            Consumer<MapOfStringToListOfStringInQueryParamsRequest.Builder> mapOfStringToListOfStringInQueryParamsRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        return mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest.builder()
                .apply(mapOfStringToListOfStringInQueryParamsRequest).build());
    }

    /**
     * Invokes the MembersInHeaders operation.
     *
     * @return Result of the MembersInHeaders operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MembersInHeaders
     * @see #membersInHeaders(MembersInHeadersRequest)
     */
    default MembersInHeadersResponse membersInHeaders() throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        return membersInHeaders(MembersInHeadersRequest.builder().build());
    }

    /**
     * Invokes the MembersInHeaders operation.
     *
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MembersInHeaders
     */
    default MembersInHeadersResponse membersInHeaders(MembersInHeadersRequest membersInHeadersRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInHeaders operation.
     *
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MembersInHeaders
     */
    default MembersInHeadersResponse membersInHeaders(Consumer<MembersInHeadersRequest.Builder> membersInHeadersRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        return membersInHeaders(MembersInHeadersRequest.builder().apply(membersInHeadersRequest).build());
    }

    /**
     * Invokes the MembersInQueryParams operation.
     *
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MembersInQueryParams
     * @see #membersInQueryParams(MembersInQueryParamsRequest)
     */
    default MembersInQueryParamsResponse membersInQueryParams() throws SdkServiceException, SdkClientException,
            ProtocolRestXmlException {
        return membersInQueryParams(MembersInQueryParamsRequest.builder().build());
    }

    /**
     * Invokes the MembersInQueryParams operation.
     *
     * @param membersInQueryParamsRequest
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MembersInQueryParams
     */
    default MembersInQueryParamsResponse membersInQueryParams(MembersInQueryParamsRequest membersInQueryParamsRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInQueryParams operation.
     *
     * @param membersInQueryParamsRequest
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MembersInQueryParams
     */
    default MembersInQueryParamsResponse membersInQueryParams(
            Consumer<MembersInQueryParamsRequest.Builder> membersInQueryParamsRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        return membersInQueryParams(MembersInQueryParamsRequest.builder().apply(membersInQueryParamsRequest).build());
    }

    /**
     * Invokes the MultiLocationOperation operation.
     *
     * @param multiLocationOperationRequest
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MultiLocationOperation
     */
    default MultiLocationOperationResponse multiLocationOperation(MultiLocationOperationRequest multiLocationOperationRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MultiLocationOperation operation.
     *
     * @param multiLocationOperationRequest
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MultiLocationOperation
     */
    default MultiLocationOperationResponse multiLocationOperation(
            Consumer<MultiLocationOperationRequest.Builder> multiLocationOperationRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        return multiLocationOperation(MultiLocationOperationRequest.builder().apply(multiLocationOperationRequest).build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.
     *
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithExplicitPayloadBlob
     * @see #operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest)
     */
    default OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob() throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        return operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest.builder().build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.
     *
     * @param operationWithExplicitPayloadBlobRequest
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithExplicitPayloadBlob
     */
    default OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob(
            OperationWithExplicitPayloadBlobRequest operationWithExplicitPayloadBlobRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.
     *
     * @param operationWithExplicitPayloadBlobRequest
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithExplicitPayloadBlob
     */
    default OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob(
            Consumer<OperationWithExplicitPayloadBlobRequest.Builder> operationWithExplicitPayloadBlobRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        return operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest.builder()
                .apply(operationWithExplicitPayloadBlobRequest).build());
    }

    /**
     * Invokes the OperationWithGreedyLabel operation.
     *
     * @param operationWithGreedyLabelRequest
     * @return Result of the OperationWithGreedyLabel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithGreedyLabel
     */
    default OperationWithGreedyLabelResponse operationWithGreedyLabel(
            OperationWithGreedyLabelRequest operationWithGreedyLabelRequest) throws SdkServiceException, SdkClientException,
            ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithGreedyLabel operation.
     *
     * @param operationWithGreedyLabelRequest
     * @return Result of the OperationWithGreedyLabel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithGreedyLabel
     */
    default OperationWithGreedyLabelResponse operationWithGreedyLabel(
            Consumer<OperationWithGreedyLabelRequest.Builder> operationWithGreedyLabelRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        return operationWithGreedyLabel(OperationWithGreedyLabelRequest.builder().apply(operationWithGreedyLabelRequest).build());
    }

    /**
     * Invokes the OperationWithModeledContentType operation.
     *
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithModeledContentType
     * @see #operationWithModeledContentType(OperationWithModeledContentTypeRequest)
     */
    default OperationWithModeledContentTypeResponse operationWithModeledContentType() throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        return operationWithModeledContentType(OperationWithModeledContentTypeRequest.builder().build());
    }

    /**
     * Invokes the OperationWithModeledContentType operation.
     *
     * @param operationWithModeledContentTypeRequest
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithModeledContentType
     */
    default OperationWithModeledContentTypeResponse operationWithModeledContentType(
            OperationWithModeledContentTypeRequest operationWithModeledContentTypeRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithModeledContentType operation.
     *
     * @param operationWithModeledContentTypeRequest
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithModeledContentType
     */
    default OperationWithModeledContentTypeResponse operationWithModeledContentType(
            Consumer<OperationWithModeledContentTypeRequest.Builder> operationWithModeledContentTypeRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        return operationWithModeledContentType(OperationWithModeledContentTypeRequest.builder()
                .apply(operationWithModeledContentTypeRequest).build());
    }

    /**
     * Invokes the QueryParamWithoutValue operation.
     *
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.QueryParamWithoutValue
     * @see #queryParamWithoutValue(QueryParamWithoutValueRequest)
     */
    default QueryParamWithoutValueResponse queryParamWithoutValue() throws SdkServiceException, SdkClientException,
            ProtocolRestXmlException {
        return queryParamWithoutValue(QueryParamWithoutValueRequest.builder().build());
    }

    /**
     * Invokes the QueryParamWithoutValue operation.
     *
     * @param queryParamWithoutValueRequest
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.QueryParamWithoutValue
     */
    default QueryParamWithoutValueResponse queryParamWithoutValue(QueryParamWithoutValueRequest queryParamWithoutValueRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the QueryParamWithoutValue operation.
     *
     * @param queryParamWithoutValueRequest
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.QueryParamWithoutValue
     */
    default QueryParamWithoutValueResponse queryParamWithoutValue(
            Consumer<QueryParamWithoutValueRequest.Builder> queryParamWithoutValueRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        return queryParamWithoutValue(QueryParamWithoutValueRequest.builder().apply(queryParamWithoutValueRequest).build());
    }

    /**
     * Invokes the RestXmlTypes operation.
     *
     * @return Result of the RestXmlTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.RestXmlTypes
     * @see #restXmlTypes(RestXmlTypesRequest)
     */
    default RestXmlTypesResponse restXmlTypes() throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        return restXmlTypes(RestXmlTypesRequest.builder().build());
    }

    /**
     * Invokes the RestXmlTypes operation.
     *
     * @param restXmlTypesRequest
     * @return Result of the RestXmlTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.RestXmlTypes
     */
    default RestXmlTypesResponse restXmlTypes(RestXmlTypesRequest restXmlTypesRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the RestXmlTypes operation.
     *
     * @param restXmlTypesRequest
     * @return Result of the RestXmlTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.RestXmlTypes
     */
    default RestXmlTypesResponse restXmlTypes(Consumer<RestXmlTypesRequest.Builder> restXmlTypesRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {
        return restXmlTypes(RestXmlTypesRequest.builder().apply(restXmlTypesRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("restxml");
    }
}
