/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SdkAsyncClientHandler;
import software.amazon.awssdk.core.config.AsyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.core.http.StaxResponseHandler;
import software.amazon.awssdk.core.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.protocolrestxml.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolrestxml.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolrestxml.model.DeleteOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.DeleteOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MapOfStringToListOfStringInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MapOfStringToListOfStringInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInHeadersRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInHeadersResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MultiLocationOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MultiLocationOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithExplicitPayloadBlobRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithExplicitPayloadBlobResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithGreedyLabelRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithGreedyLabelResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithModeledContentTypeRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithModeledContentTypeResponse;
import software.amazon.awssdk.services.protocolrestxml.model.ProtocolRestXmlException;
import software.amazon.awssdk.services.protocolrestxml.model.QueryParamWithoutValueRequest;
import software.amazon.awssdk.services.protocolrestxml.model.QueryParamWithoutValueResponse;
import software.amazon.awssdk.services.protocolrestxml.model.RestXmlTypesRequest;
import software.amazon.awssdk.services.protocolrestxml.model.RestXmlTypesResponse;
import software.amazon.awssdk.services.protocolrestxml.transform.AllTypesRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.AllTypesResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.DeleteOperationRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.DeleteOperationResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.EmptyModeledExceptionUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.IdempotentOperationRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.IdempotentOperationResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MapOfStringToListOfStringInQueryParamsRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MapOfStringToListOfStringInQueryParamsResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MembersInHeadersRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MembersInHeadersResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MembersInQueryParamsRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MembersInQueryParamsResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MultiLocationOperationRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MultiLocationOperationResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithExplicitPayloadBlobRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithExplicitPayloadBlobResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithGreedyLabelRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithGreedyLabelResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithModeledContentTypeRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithModeledContentTypeResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.QueryParamWithoutValueRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.QueryParamWithoutValueResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.RestXmlTypesRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.RestXmlTypesResponseUnmarshaller;

/**
 * Internal implementation of {@link ProtocolRestXmlAsyncClient}.
 *
 * @see ProtocolRestXmlAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultProtocolRestXmlAsyncClient implements ProtocolRestXmlAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final List<Unmarshaller<SdkServiceException, Node>> exceptionUnmarshallers;

    protected DefaultProtocolRestXmlAsyncClient(AsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkAsyncClientHandler(clientConfiguration, null);
        this.exceptionUnmarshallers = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     *
     * @param allTypesRequest
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.AllTypes
     */
    @Override
    public CompletableFuture<AllTypesResponse> allTypes(AllTypesRequest allTypesRequest) {

        StaxResponseHandler<AllTypesResponse> responseHandler = new StaxResponseHandler<AllTypesResponse>(
                new AllTypesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AllTypesRequest, AllTypesResponse>()
                .withMarshaller(new AllTypesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(allTypesRequest));
    }

    /**
     * Invokes the DeleteOperation operation asynchronously.
     *
     * @param deleteOperationRequest
     * @return A Java Future containing the result of the DeleteOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.DeleteOperation
     */
    @Override
    public CompletableFuture<DeleteOperationResponse> deleteOperation(DeleteOperationRequest deleteOperationRequest) {

        StaxResponseHandler<DeleteOperationResponse> responseHandler = new StaxResponseHandler<DeleteOperationResponse>(
                new DeleteOperationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteOperationRequest, DeleteOperationResponse>()
                .withMarshaller(new DeleteOperationRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteOperationRequest));
    }

    /**
     * Invokes the IdempotentOperation operation asynchronously.
     *
     * @param idempotentOperationRequest
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.IdempotentOperation
     */
    @Override
    public CompletableFuture<IdempotentOperationResponse> idempotentOperation(
            IdempotentOperationRequest idempotentOperationRequest) {

        StaxResponseHandler<IdempotentOperationResponse> responseHandler = new StaxResponseHandler<IdempotentOperationResponse>(
                new IdempotentOperationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<IdempotentOperationRequest, IdempotentOperationResponse>()
                .withMarshaller(new IdempotentOperationRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(idempotentOperationRequest));
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation asynchronously.
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return A Java Future containing the result of the MapOfStringToListOfStringInQueryParams operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.MapOfStringToListOfStringInQueryParams
     */
    @Override
    public CompletableFuture<MapOfStringToListOfStringInQueryParamsResponse> mapOfStringToListOfStringInQueryParams(
            MapOfStringToListOfStringInQueryParamsRequest mapOfStringToListOfStringInQueryParamsRequest) {

        StaxResponseHandler<MapOfStringToListOfStringInQueryParamsResponse> responseHandler = new StaxResponseHandler<MapOfStringToListOfStringInQueryParamsResponse>(
                new MapOfStringToListOfStringInQueryParamsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<MapOfStringToListOfStringInQueryParamsRequest, MapOfStringToListOfStringInQueryParamsResponse>()
                        .withMarshaller(new MapOfStringToListOfStringInQueryParamsRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(mapOfStringToListOfStringInQueryParamsRequest));
    }

    /**
     * Invokes the MembersInHeaders operation asynchronously.
     *
     * @param membersInHeadersRequest
     * @return A Java Future containing the result of the MembersInHeaders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.MembersInHeaders
     */
    @Override
    public CompletableFuture<MembersInHeadersResponse> membersInHeaders(MembersInHeadersRequest membersInHeadersRequest) {

        StaxResponseHandler<MembersInHeadersResponse> responseHandler = new StaxResponseHandler<MembersInHeadersResponse>(
                new MembersInHeadersResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<MembersInHeadersRequest, MembersInHeadersResponse>()
                .withMarshaller(new MembersInHeadersRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(membersInHeadersRequest));
    }

    /**
     * Invokes the MembersInQueryParams operation asynchronously.
     *
     * @param membersInQueryParamsRequest
     * @return A Java Future containing the result of the MembersInQueryParams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.MembersInQueryParams
     */
    @Override
    public CompletableFuture<MembersInQueryParamsResponse> membersInQueryParams(
            MembersInQueryParamsRequest membersInQueryParamsRequest) {

        StaxResponseHandler<MembersInQueryParamsResponse> responseHandler = new StaxResponseHandler<MembersInQueryParamsResponse>(
                new MembersInQueryParamsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<MembersInQueryParamsRequest, MembersInQueryParamsResponse>()
                .withMarshaller(new MembersInQueryParamsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(membersInQueryParamsRequest));
    }

    /**
     * Invokes the MultiLocationOperation operation asynchronously.
     *
     * @param multiLocationOperationRequest
     * @return A Java Future containing the result of the MultiLocationOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.MultiLocationOperation
     */
    @Override
    public CompletableFuture<MultiLocationOperationResponse> multiLocationOperation(
            MultiLocationOperationRequest multiLocationOperationRequest) {

        StaxResponseHandler<MultiLocationOperationResponse> responseHandler = new StaxResponseHandler<MultiLocationOperationResponse>(
                new MultiLocationOperationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<MultiLocationOperationRequest, MultiLocationOperationResponse>()
                .withMarshaller(new MultiLocationOperationRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(multiLocationOperationRequest));
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation asynchronously.
     *
     * @param operationWithExplicitPayloadBlobRequest
     * @return A Java Future containing the result of the OperationWithExplicitPayloadBlob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.OperationWithExplicitPayloadBlob
     */
    @Override
    public CompletableFuture<OperationWithExplicitPayloadBlobResponse> operationWithExplicitPayloadBlob(
            OperationWithExplicitPayloadBlobRequest operationWithExplicitPayloadBlobRequest) {

        StaxResponseHandler<OperationWithExplicitPayloadBlobResponse> responseHandler = new StaxResponseHandler<OperationWithExplicitPayloadBlobResponse>(
                new OperationWithExplicitPayloadBlobResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<OperationWithExplicitPayloadBlobRequest, OperationWithExplicitPayloadBlobResponse>()
                        .withMarshaller(new OperationWithExplicitPayloadBlobRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(operationWithExplicitPayloadBlobRequest));
    }

    /**
     * Invokes the OperationWithGreedyLabel operation asynchronously.
     *
     * @param operationWithGreedyLabelRequest
     * @return A Java Future containing the result of the OperationWithGreedyLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.OperationWithGreedyLabel
     */
    @Override
    public CompletableFuture<OperationWithGreedyLabelResponse> operationWithGreedyLabel(
            OperationWithGreedyLabelRequest operationWithGreedyLabelRequest) {

        StaxResponseHandler<OperationWithGreedyLabelResponse> responseHandler = new StaxResponseHandler<OperationWithGreedyLabelResponse>(
                new OperationWithGreedyLabelResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<OperationWithGreedyLabelRequest, OperationWithGreedyLabelResponse>()
                        .withMarshaller(new OperationWithGreedyLabelRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(operationWithGreedyLabelRequest));
    }

    /**
     * Invokes the OperationWithModeledContentType operation asynchronously.
     *
     * @param operationWithModeledContentTypeRequest
     * @return A Java Future containing the result of the OperationWithModeledContentType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.OperationWithModeledContentType
     */
    @Override
    public CompletableFuture<OperationWithModeledContentTypeResponse> operationWithModeledContentType(
            OperationWithModeledContentTypeRequest operationWithModeledContentTypeRequest) {

        StaxResponseHandler<OperationWithModeledContentTypeResponse> responseHandler = new StaxResponseHandler<OperationWithModeledContentTypeResponse>(
                new OperationWithModeledContentTypeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<OperationWithModeledContentTypeRequest, OperationWithModeledContentTypeResponse>()
                        .withMarshaller(new OperationWithModeledContentTypeRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(operationWithModeledContentTypeRequest));
    }

    /**
     * Invokes the QueryParamWithoutValue operation asynchronously.
     *
     * @param queryParamWithoutValueRequest
     * @return A Java Future containing the result of the QueryParamWithoutValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.QueryParamWithoutValue
     */
    @Override
    public CompletableFuture<QueryParamWithoutValueResponse> queryParamWithoutValue(
            QueryParamWithoutValueRequest queryParamWithoutValueRequest) {

        StaxResponseHandler<QueryParamWithoutValueResponse> responseHandler = new StaxResponseHandler<QueryParamWithoutValueResponse>(
                new QueryParamWithoutValueResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<QueryParamWithoutValueRequest, QueryParamWithoutValueResponse>()
                .withMarshaller(new QueryParamWithoutValueRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(queryParamWithoutValueRequest));
    }

    /**
     * Invokes the RestXmlTypes operation asynchronously.
     *
     * @param restXmlTypesRequest
     * @return A Java Future containing the result of the RestXmlTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.RestXmlTypes
     */
    @Override
    public CompletableFuture<RestXmlTypesResponse> restXmlTypes(RestXmlTypesRequest restXmlTypesRequest) {

        StaxResponseHandler<RestXmlTypesResponse> responseHandler = new StaxResponseHandler<RestXmlTypesResponse>(
                new RestXmlTypesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<RestXmlTypesRequest, RestXmlTypesResponse>()
                .withMarshaller(new RestXmlTypesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(restXmlTypesRequest));
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private List<Unmarshaller<SdkServiceException, Node>> init() {
        List<Unmarshaller<SdkServiceException, Node>> unmarshallers = new ArrayList<>();
        unmarshallers.add(new EmptyModeledExceptionUnmarshaller());
        unmarshallers.add(new StandardErrorUnmarshaller(ProtocolRestXmlException.class));
        return unmarshallers;
    }
}
