/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery.transform;

import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.protocolquery.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * QueryTypesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class QueryTypesResponseUnmarshaller implements Unmarshaller<QueryTypesResponse, StaxUnmarshallerContext> {

    private static class FlattenedMapMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final FlattenedMapMapEntryUnmarshaller INSTANCE = new FlattenedMapMapEntryUnmarshaller();

        public static FlattenedMapMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    private static class FlattenedMapWithLocationMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("thekey", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("thevalue", targetDepth)) {
                        entry.setValue(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final FlattenedMapWithLocationMapEntryUnmarshaller INSTANCE = new FlattenedMapWithLocationMapEntryUnmarshaller();

        public static FlattenedMapWithLocationMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    private static class NonFlattenedMapWithLocationMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("thekey", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("thevalue", targetDepth)) {
                        entry.setValue(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final NonFlattenedMapWithLocationMapEntryUnmarshaller INSTANCE = new NonFlattenedMapWithLocationMapEntryUnmarshaller();

        public static NonFlattenedMapWithLocationMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    public QueryTypesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        QueryTypesResponse.Builder queryTypesResponse = QueryTypesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<String> flattenedListOfStrings = null;
        java.util.List<String> nonFlattenedListWithLocation = null;
        java.util.List<SimpleStruct> flattenedListOfStructs = null;
        java.util.List<String> flattenedListWithLocation = null;
        java.util.Map<String, String> flattenedMap = null;
        java.util.Map<String, String> flattenedMapWithLocation = null;
        java.util.Map<String, String> nonFlattenedMapWithLocation = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                queryTypesResponse.flattenedListOfStrings(flattenedListOfStrings);
                queryTypesResponse.nonFlattenedListWithLocation(nonFlattenedListWithLocation);
                queryTypesResponse.flattenedListOfStructs(flattenedListOfStructs);
                queryTypesResponse.flattenedListWithLocation(flattenedListWithLocation);
                queryTypesResponse.flattenedMap(flattenedMap);
                queryTypesResponse.flattenedMapWithLocation(flattenedMapWithLocation);
                queryTypesResponse.nonFlattenedMapWithLocation(nonFlattenedMapWithLocation);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("FlattenedListOfStrings", targetDepth)) {
                    if (flattenedListOfStrings == null) {
                        flattenedListOfStrings = new ArrayList<>();
                    }
                    flattenedListOfStrings.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NonFlattenedListWithLocation", targetDepth)) {
                    nonFlattenedListWithLocation = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("NonFlattenedListWithLocation/item", targetDepth)) {
                    nonFlattenedListWithLocation.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FlattenedListOfStructs", targetDepth)) {
                    if (flattenedListOfStructs == null) {
                        flattenedListOfStructs = new ArrayList<>();
                    }
                    flattenedListOfStructs.add(SimpleStructUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("item", targetDepth)) {
                    if (flattenedListWithLocation == null) {
                        flattenedListWithLocation = new ArrayList<>();
                    }
                    flattenedListWithLocation.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FlattenedMap", targetDepth)) {
                    if (flattenedMap == null) {
                        flattenedMap = new java.util.HashMap<>();
                    }
                    Entry<String, String> entry = FlattenedMapMapEntryUnmarshaller.getInstance().unmarshall(context);
                    // queryTypesResponse.addFlattenedMapEntry(entry.getKey(), entry.getValue());

                    flattenedMap.put(entry.getKey(), entry.getValue());
                    continue;
                }

                if (context.testExpression("flatmap", targetDepth)) {
                    if (flattenedMapWithLocation == null) {
                        flattenedMapWithLocation = new java.util.HashMap<>();
                    }
                    Entry<String, String> entry = FlattenedMapWithLocationMapEntryUnmarshaller.getInstance().unmarshall(context);
                    // queryTypesResponse.addFlattenedMapWithLocationEntry(entry.getKey(), entry.getValue());

                    flattenedMapWithLocation.put(entry.getKey(), entry.getValue());
                    continue;
                }

                if (context.testExpression("themap/entry", targetDepth)) {
                    if (nonFlattenedMapWithLocation == null) {
                        nonFlattenedMapWithLocation = new java.util.HashMap<>();
                    }
                    Entry<String, String> entry = NonFlattenedMapWithLocationMapEntryUnmarshaller.getInstance().unmarshall(
                            context);
                    // queryTypesResponse.addNonFlattenedMapWithLocationEntry(entry.getKey(), entry.getValue());

                    nonFlattenedMapWithLocation.put(entry.getKey(), entry.getValue());
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    queryTypesResponse.flattenedListOfStrings(flattenedListOfStrings);
                    queryTypesResponse.nonFlattenedListWithLocation(nonFlattenedListWithLocation);
                    queryTypesResponse.flattenedListOfStructs(flattenedListOfStructs);
                    queryTypesResponse.flattenedListWithLocation(flattenedListWithLocation);
                    queryTypesResponse.flattenedMap(flattenedMap);
                    queryTypesResponse.flattenedMapWithLocation(flattenedMapWithLocation);
                    queryTypesResponse.nonFlattenedMapWithLocation(nonFlattenedMapWithLocation);
                    break;
                }
            }
        }
        return queryTypesResponse.build();
    }

    private static final QueryTypesResponseUnmarshaller INSTANCE = new QueryTypesResponseUnmarshaller();

    public static QueryTypesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
