/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class MapOfStringToListOfStringInQueryParamsRequest extends ProtocolRestJsonRequest implements
        ToCopyableBuilder<MapOfStringToListOfStringInQueryParamsRequest.Builder, MapOfStringToListOfStringInQueryParamsRequest> {
    private final Map<String, List<String>> mapOfStringToListOfStrings;

    private MapOfStringToListOfStringInQueryParamsRequest(BuilderImpl builder) {
        super(builder);
        this.mapOfStringToListOfStrings = builder.mapOfStringToListOfStrings;
    }

    /**
     * Returns the value of the MapOfStringToListOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the MapOfStringToListOfStrings property for this object.
     */
    public Map<String, List<String>> mapOfStringToListOfStrings() {
        return mapOfStringToListOfStrings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mapOfStringToListOfStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapOfStringToListOfStringInQueryParamsRequest)) {
            return false;
        }
        MapOfStringToListOfStringInQueryParamsRequest other = (MapOfStringToListOfStringInQueryParamsRequest) obj;
        return Objects.equals(mapOfStringToListOfStrings(), other.mapOfStringToListOfStrings());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (mapOfStringToListOfStrings() != null) {
            sb.append("MapOfStringToListOfStrings: ").append(mapOfStringToListOfStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MapOfStringToListOfStrings":
            return Optional.of(clazz.cast(mapOfStringToListOfStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ProtocolRestJsonRequest.Builder,
            CopyableBuilder<Builder, MapOfStringToListOfStringInQueryParamsRequest> {
        /**
         * Sets the value of the MapOfStringToListOfStrings property for this object.
         *
         * @param mapOfStringToListOfStrings
         *        The new value for the MapOfStringToListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapOfStringToListOfStrings(Map<String, ? extends Collection<String>> mapOfStringToListOfStrings);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends ProtocolRestJsonRequest.BuilderImpl implements Builder {
        private Map<String, List<String>> mapOfStringToListOfStrings;

        private BuilderImpl() {
        }

        private BuilderImpl(MapOfStringToListOfStringInQueryParamsRequest model) {
            mapOfStringToListOfStrings(model.mapOfStringToListOfStrings);
        }

        public final Map<String, ? extends Collection<String>> getMapOfStringToListOfStrings() {
            return mapOfStringToListOfStrings;
        }

        @Override
        public final Builder mapOfStringToListOfStrings(Map<String, ? extends Collection<String>> mapOfStringToListOfStrings) {
            this.mapOfStringToListOfStrings = MapOfStringToListOfStringsCopier.copy(mapOfStringToListOfStrings);
            return this;
        }

        public final void setMapOfStringToListOfStrings(Map<String, ? extends Collection<String>> mapOfStringToListOfStrings) {
            this.mapOfStringToListOfStrings = MapOfStringToListOfStringsCopier.copy(mapOfStringToListOfStrings);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public MapOfStringToListOfStringInQueryParamsRequest build() {
            return new MapOfStringToListOfStringInQueryParamsRequest(this);
        }
    }
}
